/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.device;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class DeviceMaintRepository {
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"managerMongoTemplate");
    private static final DeviceMaintRepository instance = new DeviceMaintRepository();

    private DeviceMaintRepository() {
    }

    public static DeviceMaintRepository getInstance() {
        return instance;
    }

    public List<DevicePO> findByOmadacId(String omadacId) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId)), DevicePO.class);
    }

    public List<DevicePO> findByOmadacIdAndSiteId(String omadacId, String siteId) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId)), DevicePO.class);
    }

    public DevicePO findByOmadacIdAndMac(String omadacId, String mac) {
        return (DevicePO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("mac").is((Object)mac)), DevicePO.class);
    }

    public List<DevicePO> findByOmadacIdAndSiteIdAndMacIn(c omadacId, d siteId, Set<String> macs) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("mac").in(macs)), DevicePO.class);
    }

    public void deleteByOmadacId(String omadacId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId)), DevicePO.class);
    }

    public List<DevicePO> deleteByOmadacIdAndSiteId(String omadacId, String siteId) {
        return this.mongoTemplate.findAllAndRemove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId)), DevicePO.class);
    }

    public Set<String> listMacsByOmadacId(String omadacId) {
        Query query = new Query();
        query.fields().include("mac");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        List devices = this.mongoTemplate.find(query, DevicePO.class, "device");
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return Collections.emptySet();
        }
        return devices.stream().map(DevicePO::getMac).collect(Collectors.toSet());
    }

    public Set<String> listMacsByOmadacIdAndSiteId(String omadacId, String siteId) {
        Query query = new Query();
        query.fields().include("mac");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId));
        List devices = this.mongoTemplate.find(query, DevicePO.class, "device");
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return Collections.emptySet();
        }
        return devices.stream().map(DevicePO::getMac).collect(Collectors.toSet());
    }

    public boolean existMacsByOmadacId(String omadacId, Set<String> macs) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mac").in(macs));
        return this.mongoTemplate.exists(query, DevicePO.class, "device");
    }

    public List<DevicePO> listBriefDeviceByOmadacId(String omadacId) {
        Query query = new Query();
        query.fields().include("mac");
        query.fields().include("last_seen");
        query.fields().include("type");
        query.fields().include("model");
        query.fields().include("hw_version");
        query.fields().include("added_in_advance");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        List devices = this.mongoTemplate.find(query, DevicePO.class, "device");
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return new ArrayList<DevicePO>();
        }
        return devices;
    }

    public List<DevicePO> listBriefDeviceByOmadacIdAndSiteId(String omadacId, String siteId) {
        Query query = new Query();
        query.fields().include("mac");
        query.fields().include("last_seen");
        query.fields().include("type");
        query.fields().include("model");
        query.fields().include("hw_version");
        query.fields().include("added_in_advance");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        List devices = this.mongoTemplate.find(query, DevicePO.class, "device");
        if (CollectionUtils.isEmpty((Collection)devices)) {
            return new ArrayList<DevicePO>();
        }
        return devices;
    }

    public Long countDeviceNumber(String omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        return this.mongoTemplate.count(query, DevicePO.class);
    }

    public Long countDeviceNumberOfSite(String omadacId, String siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        return this.mongoTemplate.count(query, DevicePO.class);
    }

    public List<DevicePO> findByOmadacIdAndSiteIdAndTemplateId(c omadacId, d siteId, String templateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").is((Object)templateId));
        return this.mongoTemplate.find(query, DevicePO.class);
    }

    public boolean existsESByOmadacIdAndSiteId(String omadacId, String siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId).and("type").is((Object)DeviceTypeEnum.c.b()).and("device_misc.category").is((Object)"EMS"));
        return this.mongoTemplate.exists(query, DevicePO.class);
    }

    public void saveAll(List<DevicePO> devicePOS) {
        devicePOS.forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).save(arg_0));
    }
}

