/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.port.mongo.configuration.site.auth;

import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.BuiltInRadiusCheckResultPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.BaseLdapProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.BaseRadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.server.SslVpnServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.vpn.vpn.VpnPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class AuthenticationMaintRepository {
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"managerMongoTemplate");
    private static final AuthenticationMaintRepository instance = new AuthenticationMaintRepository();

    private AuthenticationMaintRepository() {
    }

    public static AuthenticationMaintRepository getInstance() {
        return instance;
    }

    public List<RadiusProfileTemplatePO> findRadiusProfilesTemplates(c omadacId, String siteTemplateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_template_id").is((Object)siteTemplateId));
        return this.mongoTemplate.find(query, RadiusProfileTemplatePO.class);
    }

    public List<RadiusProfileTemplatePO> findRadiusProfilesTemplatesByOmadacId(String omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        return this.mongoTemplate.find(query, RadiusProfileTemplatePO.class);
    }

    public List<RadiusProfilePO> findRadiusProfiles(c omadacId, d siteId) {
        List radiusProfilePOS;
        ArrayList<RadiusProfilePO> allProfiles = new ArrayList<RadiusProfilePO>();
        RadiusProfilePO buildInProfile = (RadiusProfilePO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"built_in_server").is((Object)true)), RadiusProfilePO.class);
        if (buildInProfile != null) {
            allProfiles.add(buildInProfile);
        }
        if (!CollectionUtils.isEmpty((Collection)(radiusProfilePOS = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a())), RadiusProfilePO.class)))) {
            allProfiles.addAll(radiusProfilePOS);
        }
        return allProfiles;
    }

    public List<RadiusProfilePO> findRadiusProfilesByOmadacId(String omadacId) {
        List radiusProfilePOS;
        ArrayList<RadiusProfilePO> allProfiles = new ArrayList<RadiusProfilePO>();
        RadiusProfilePO buildInProfile = (RadiusProfilePO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"built_in_server").is((Object)true)), RadiusProfilePO.class);
        if (buildInProfile != null) {
            allProfiles.add(buildInProfile);
        }
        if (!CollectionUtils.isEmpty((Collection)(radiusProfilePOS = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId)), RadiusProfilePO.class)))) {
            allProfiles.addAll(radiusProfilePOS);
        }
        return allProfiles;
    }

    public RadiusProfilePO insert(RadiusProfilePO radiusProfile) {
        radiusProfile.setId(null);
        return (RadiusProfilePO)this.mongoTemplate.insert((Object)radiusProfile);
    }

    public RadiusProfilePO saveAndReturn(RadiusProfilePO radiusProfile) {
        return (RadiusProfilePO)this.mongoTemplate.save((Object)radiusProfile);
    }

    public RadiusProfileTemplatePO insert(RadiusProfileTemplatePO radiusProfile) {
        radiusProfile.setId(null);
        return (RadiusProfileTemplatePO)this.mongoTemplate.insert((Object)radiusProfile);
    }

    public void deleteRadiusByOmadacIdAndSiteIdAndIds(c omadacId, d siteId, Set<String> ids) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").in(ids));
        this.mongoTemplate.remove(query, RadiusProfilePO.class);
    }

    public void deleteLdapByOmadacIdAndSiteIdAndIds(c omadacId, d siteId, Set<String> ids) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").in(ids));
        this.mongoTemplate.remove(query, LdapProfilePO.class);
    }

    public void deleteAllByOmadacId(c omadacId, x typeEnum) {
        if (x.a == typeEnum) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
            this.mongoTemplate.remove(query, RadiusProfilePO.class);
            this.mongoTemplate.remove(query, LdapProfilePO.class);
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
            this.mongoTemplate.remove(query, RadiusProfileTemplatePO.class);
            this.mongoTemplate.remove(query, LdapProfileTemplatePO.class);
        }
    }

    public void deleteByOmadacIdAndSiteId(c omadacId, d siteId, x typeEnum) {
        if (x.a == typeEnum) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
            this.mongoTemplate.remove(query, RadiusProfilePO.class);
            this.mongoTemplate.remove(query, LdapProfilePO.class);
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
            this.mongoTemplate.remove(query, RadiusProfileTemplatePO.class);
            this.mongoTemplate.remove(query, LdapProfileTemplatePO.class);
        }
    }

    @Deprecated
    public void deleteAllCustomAndAssociatedVpn(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").isNull());
        query.fields().include("_id");
        List radiusPOList = this.mongoTemplate.find(query, RadiusProfilePO.class);
        if (!CollectionUtils.isEmpty((Collection)radiusPOList)) {
            List radiusIdList = radiusPOList.stream().map(BaseRadiusProfilePO::getId).collect(Collectors.toList());
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("auth_type").is((Object)1).and("radius_setting.radius").in(radiusIdList)), SslVpnServerPO.class);
        }
        this.mongoTemplate.remove(query, RadiusProfilePO.class);
        List ldapPOList = this.mongoTemplate.find(query, LdapProfilePO.class);
        if (!CollectionUtils.isEmpty((Collection)ldapPOList)) {
            List ldapIdList = ldapPOList.stream().map(BaseLdapProfilePO::getId).collect(Collectors.toList());
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("auth_type").is((Object)1).and("ldap_profile").in(ldapIdList)), VpnPO.class);
        }
        this.mongoTemplate.remove(query, LdapProfilePO.class);
    }

    public void deleteLdapAllCustomAndAssociatedVpn(@NonNull c omadacId, @NonNull d siteId) {
        if (omadacId == null) {
            throw new NullPointerException("omadacId is marked non-null but is null");
        }
        if (siteId == null) {
            throw new NullPointerException("siteId is marked non-null but is null");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").isNull());
        query.fields().include("_id");
        List ldapPOList = this.mongoTemplate.find(query, LdapProfilePO.class);
        if (!CollectionUtils.isEmpty((Collection)ldapPOList)) {
            List ldapIdList = ldapPOList.stream().map(BaseLdapProfilePO::getId).collect(Collectors.toList());
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("auth_type").is((Object)1).and("ldap_profile").in(ldapIdList)), VpnPO.class);
        }
        this.mongoTemplate.remove(query, LdapProfilePO.class);
    }

    public void deleteRadiusAllCustomAndAssociatedVpn(@NonNull c omadacId, @NonNull d siteId) {
        if (omadacId == null) {
            throw new NullPointerException("omadacId is marked non-null but is null");
        }
        if (siteId == null) {
            throw new NullPointerException("siteId is marked non-null but is null");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("template_id").isNull());
        query.fields().include("_id");
        List radiusPOList = this.mongoTemplate.find(query, RadiusProfilePO.class);
        if (!CollectionUtils.isEmpty((Collection)radiusPOList)) {
            List radiusIdList = radiusPOList.stream().map(BaseRadiusProfilePO::getId).collect(Collectors.toList());
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("auth_type").is((Object)1).and("radius_setting.radius").in(radiusIdList)), SslVpnServerPO.class);
        }
        this.mongoTemplate.remove(query, RadiusProfilePO.class);
    }

    public List<RadiusProfilePO> findAll() {
        return this.mongoTemplate.findAll(RadiusProfilePO.class);
    }

    public void save(RadiusProfilePO radiusProfilePO) {
        this.mongoTemplate.save((Object)radiusProfilePO);
    }

    public void save(RadiusProfileTemplatePO radiusProfileTemplatePO) {
        this.mongoTemplate.save((Object)radiusProfileTemplatePO);
    }

    public List<LdapProfilePO> findLdapProfiles(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()));
        return this.mongoTemplate.find(query, LdapProfilePO.class);
    }

    public List<LdapProfileTemplatePO> findLdapProfileTemplates(c omadacId, String siteTemplateId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_template_id").is((Object)siteTemplateId));
        return this.mongoTemplate.find(query, LdapProfileTemplatePO.class);
    }

    public LdapProfilePO insert(LdapProfilePO ldapProfile) {
        ldapProfile.setId(null);
        return (LdapProfilePO)this.mongoTemplate.insert((Object)ldapProfile);
    }

    public LdapProfilePO save(LdapProfilePO ldapProfile) {
        return (LdapProfilePO)this.mongoTemplate.save((Object)ldapProfile);
    }

    public LdapProfileTemplatePO insert(LdapProfileTemplatePO ldapProfile) {
        ldapProfile.setId(null);
        return (LdapProfileTemplatePO)this.mongoTemplate.insert((Object)ldapProfile);
    }

    public boolean builtInProfileExist() {
        return this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"built_in_server").is((Object)true)), RadiusProfilePO.class);
    }

    public RadiusProfilePO findBuiltInProfile() {
        return (RadiusProfilePO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"built_in_server").is((Object)true)), RadiusProfilePO.class);
    }

    public void deleteBuiltInProfile() {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"built_in_server").is((Object)true)), RadiusProfilePO.class);
    }

    public boolean existLdapProfileByOmadacIdAndSiteIdAndId(c omadacId, d siteId, String id) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a()).and("_id").is((Object)id));
        return this.mongoTemplate.exists(query, LdapProfilePO.class);
    }

    public BuiltInRadiusCheckResultPO findBuiltInRadiusCheckResult() {
        return (BuiltInRadiusCheckResultPO)this.mongoTemplate.findOne(new Query(), BuiltInRadiusCheckResultPO.class);
    }

    public void save(BuiltInRadiusCheckResultPO radiusCheckResultPO) {
        this.mongoTemplate.save((Object)radiusCheckResultPO);
    }
}

