/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.logsetting.site;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.logmanager.api.internal.dto.ClearAlertCacheRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.ClearLogSettingCacheDTO;
import com.tplink.smb.omada.logmanager.api.internal.e;
import com.tplink.smb.omada.logmanager.port.mongo.sitesetting.LogSiteSettingTemplatePO;
import com.tplink.smb.omada.logmanager.port.mongo.sitesetting.OmadaLogSiteSettingPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import java.util.List;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class OmadaLogSiteSettingMaintRepository {
    private static final OmadaLogSiteSettingMaintRepository instance = new OmadaLogSiteSettingMaintRepository();
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"logManagerMongoTemplate");
    private final e logManagerInternalApiService = (e)a.b(e.class);

    public static OmadaLogSiteSettingMaintRepository getInstance() {
        return instance;
    }

    private OmadaLogSiteSettingMaintRepository() {
    }

    public Optional<OmadaLogSiteSettingPO> findByOmadacIdAndSiteId(c omadacId, d siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId.a()));
        return Optional.ofNullable((OmadaLogSiteSettingPO)this.mongoTemplate.findOne(query, OmadaLogSiteSettingPO.class));
    }

    public Optional<List<OmadaLogSiteSettingPO>> findByOmadacId(c omadacId) {
        Query query = new Query();
        if (OmadacType.s()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        }
        return Optional.ofNullable(this.mongoTemplate.find(query, OmadaLogSiteSettingPO.class));
    }

    public OmadaLogSiteSettingPO save(OmadaLogSiteSettingPO logSiteSettingPO) {
        return (OmadaLogSiteSettingPO)this.mongoTemplate.save((Object)logSiteSettingPO);
    }

    public void deleteByOmadacId(c omadacId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.mongoTemplate.remove(query, OmadaLogSiteSettingPO.class);
    }

    public void deleteByOmadacIdAndSiteId(c omadacId, d siteId, x siteSettingTypeEnum) {
        switch (siteSettingTypeEnum) {
            case a: {
                this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a())), OmadaLogSiteSettingPO.class);
                return;
            }
            case b: {
                this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_template_id").is((Object)siteId.a())), LogSiteSettingTemplatePO.class);
                return;
            }
        }
    }

    public void saveAll(List<OmadaLogSiteSettingPO> logSiteSettingPOs) {
        if (CollectionUtil.isEmpty(logSiteSettingPOs)) {
            return;
        }
        if (logSiteSettingPOs.stream().allMatch(po -> po.getId() == null)) {
            this.mongoTemplate.insertAll(logSiteSettingPOs);
        } else {
            logSiteSettingPOs.forEach(arg_0 -> ((MongoTemplate)this.mongoTemplate).save(arg_0));
        }
    }

    public void deleteCacheByOmadacId(c omadacId) {
        this.logManagerInternalApiService.a(new ClearLogSettingCacheDTO(omadacId.a()));
    }

    public void clearNotificationCacheByOmadacIdAndSiteId(c omadacId, d siteId, boolean siteTemplate) {
        ClearAlertCacheRequestDTO request = new ClearAlertCacheRequestDTO();
        request.setOmadacId(omadacId.a());
        request.setSiteId(siteId.a());
        request.setSiteTemplate(Boolean.valueOf(siteTemplate));
        this.logManagerInternalApiService.c(request);
    }
}

