/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.logsetting.msp;

import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.logmanager.api.internal.dto.ClearLogSettingCacheDTO;
import com.tplink.smb.omada.logmanager.api.internal.e;
import com.tplink.smb.omada.logmanager.port.mongo.mspsetting.LogMspSettingPO;
import com.tplink.smb.omada.logmanager.port.mongo.omadacsetting.MailServerPO;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class LogMspSettingMaintRepository {
    private final e logManagerInternalApiService = (e)a.b(e.class);
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"logManagerMongoTemplate");
    private static final LogMspSettingMaintRepository instance = new LogMspSettingMaintRepository();

    private LogMspSettingMaintRepository() {
    }

    public static LogMspSettingMaintRepository getInstance() {
        return instance;
    }

    public void deleteByMspId(String mspId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        this.mongoTemplate.remove(query, LogMspSettingPO.class);
    }

    public void save(LogMspSettingPO logMspSettingPO) {
        if (Objects.isNull(logMspSettingPO.getMailServer())) {
            MailServerPO mailServer = new MailServerPO();
            mailServer.setSmtpEnable(Boolean.valueOf(false));
            mailServer.setAuthEnable(Boolean.valueOf(false));
            mailServer.setSslEnable(Boolean.valueOf(false));
            logMspSettingPO.setMailServer(mailServer);
        }
        this.mongoTemplate.save((Object)logMspSettingPO);
    }

    public Optional<LogMspSettingPO> findByMspId(String mspId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        return Optional.ofNullable((LogMspSettingPO)this.mongoTemplate.findOne(query, LogMspSettingPO.class));
    }

    public void deleteCacheByMspId(String mspId) {
        this.logManagerInternalApiService.d(new ClearLogSettingCacheDTO(mspId));
    }
}

