/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.data;

import com.mongodb.client.MongoIterable;
import com.tplink.smb.omada.client.port.mongo.data.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.port.mongo.data.OmadaLogUpgradeDTO;
import com.tplink.smb.omada.logmanager.port.mongo.data.a.n;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.maintenance.common.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.util.CollectionUtils;

public class m
extends q<OmadaLogPO, c>
implements g<OmadaLogPO> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(m.class);
    private final n b = (n)com.tplink.smb.omada.common.spring.a.b(n.class);
    private final MongoTemplate c = (MongoTemplate)com.tplink.smb.omada.common.spring.a.a((String)"dataLogManagerMongoTemplate");
    private static final m d = new m();
    private static final String e = "omadac_id_1_site_1_key_1";
    private static final String f = "site_1";

    private m() {
    }

    public static m a() {
        return d;
    }

    public void b() {
        Query globalQuery = new Query();
        globalQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        Query siteQuery = new Query();
        siteQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"site").exists(true));
        this.iteratorCollections(collectionName -> {
            BulkOperations bulkOperations = this.c.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            ArrayList<Pair> updates = new ArrayList<Pair>();
            Pair globalPair = Pair.of((Object)globalQuery, (Object)Update.update((String)"global", (Object)true));
            Pair sitePair = Pair.of((Object)siteQuery, (Object)Update.update((String)"global", (Object)false));
            updates.add(globalPair);
            updates.add(sitePair);
            bulkOperations.updateMulti(updates);
            bulkOperations.execute();
        });
    }

    public void c() {
        this.iteratorCollections(collectionName -> this.c.indexOps(collectionName).dropAllIndexes());
    }

    public void d() {
        this.iteratorCollections(collectionName -> this.checkThenEnsureIndexes((String)collectionName, new IndexDefinition[]{new CompoundIndexDefinition(new Document("site", (Object)1))}));
    }

    public void e() {
        this.iteratorCollections(collectionName -> this.c.indexOps(collectionName).dropIndex(f));
    }

    public void a(c omadacId, String collectionName, Set<String> alertKeys, Set<String> eventKeys) {
        Query alertQuery = new Query();
        alertQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        alertQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        Query eventQuery = new Query();
        eventQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        eventQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(eventKeys));
        BulkOperations bulkOperations = this.c.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        ArrayList<Pair> updates = new ArrayList<Pair>();
        Pair alertPair = Pair.of((Object)alertQuery, (Object)Update.update((String)"alert", (Object)true).set("global", (Object)true));
        Pair eventPair = Pair.of((Object)eventQuery, (Object)Update.update((String)"event", (Object)true).set("global", (Object)true));
        updates.add(alertPair);
        updates.add(eventPair);
        bulkOperations.updateMulti(updates);
        bulkOperations.execute();
    }

    public void a(String omadacId, String collectionName, List<OmadaLogUpgradeDTO> omadaLogUpgradeList) {
        ArrayList<Pair> updateQuerys = new ArrayList<Pair>(10);
        for (OmadaLogUpgradeDTO upgradeDTO : omadaLogUpgradeList) {
            Query alertQuery = new Query();
            alertQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
            alertQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)upgradeDTO.getSiteId()));
            alertQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(upgradeDTO.getAlertKeys()));
            updateQuerys.add(Pair.of((Object)alertQuery, (Object)Update.update((String)"alert", (Object)true).set("global", (Object)false)));
            Query eventQuery = new Query();
            eventQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
            eventQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)upgradeDTO.getSiteId()));
            eventQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(upgradeDTO.getEventKeys()));
            updateQuerys.add(Pair.of((Object)eventQuery, (Object)Update.update((String)"event", (Object)true).set("global", (Object)false)));
        }
        BulkOperations bulkOperations = this.c.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        bulkOperations.updateMulti(updateQuerys);
        bulkOperations.execute();
    }

    public void a(c omadacId) {
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.c.indexOps(collectionName).dropAllIndexes());
    }

    public void a(String omadacId) {
        Set<String> lastCollectionNames = this.e(omadacId);
        this.iteratorCollectionsBySliceKey(new c(omadacId), collectionName -> {
            if (lastCollectionNames.contains(collectionName)) {
                a.info("Skip last collection:{}", collectionName);
                return;
            }
            this.checkThenEnsureIndexes((String)collectionName, this.getIndexDefinitions());
        });
    }

    public void b(String omadacId) {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeEnd = currentTime + 2678400L;
        long timeStart = currentTime - 31536000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, timeStart, timeEnd, new c(omadacId), collectionName -> this.checkThenEnsureIndexes((String)collectionName, this.getIndexDefinitions()));
    }

    public Set<String> c(String omadacId) {
        LinkedHashSet<String> logCollectionNames = new LinkedHashSet<String>(12);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, this.a(System.currentTimeMillis()) / 1000L, new c(omadacId), collectionName -> logCollectionNames.add((String)collectionName));
        a.info("Omada Log all Collections:{}", (Object)((Object)logCollectionNames).toString());
        return logCollectionNames;
    }

    private Set<String> e(String omadacId) {
        long currentTimeMillis = System.currentTimeMillis();
        long nextMonthTime = this.a(currentTimeMillis);
        LinkedHashSet<String> collectionNames = new LinkedHashSet<String>(2);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, currentTimeMillis / 1000L, nextMonthTime / 1000L, new c(omadacId), collectionName -> collectionNames.add((String)collectionName));
        a.info("Omada Log last Collections:{}", (Object)((Object)collectionNames).toString());
        return collectionNames;
    }

    public void b(c omadacId) {
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.checkThenEnsureIndexes((String)collectionName, new IndexDefinition[]{new CompoundIndexDefinition(new Document("omadac_id", (Object)1).append("site", (Object)1).append("key", (Object)1))}));
    }

    public void d(String omadacId) {
        this.iteratorCollectionsBySliceKey(new c(omadacId), collectionName -> this.c.indexOps(collectionName).dropIndex(e));
    }

    public void c(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.c.remove(query, collectionName));
    }

    public long d(c omadacId) {
        AtomicLong total = new AtomicLong(0L);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> {
            long size = this.c.count(query, collectionName);
            total.addAndGet(size);
        });
        return total.get();
    }

    @Override
    public Iterable<OmadaLogPO> findForBackup(@Nonnull String collectionName, c omadacId, d siteId, long startTimeSec, long endTimeSec) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)(startTimeSec * 1000L)).lte((Object)(endTimeSec * 1000L)));
        return this.c.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(3000).map(src -> (OmadaLogPO)this.c.getConverter().read(OmadaLogPO.class, src));
    }

    public void a(List<OmadaLogPO> logs) {
        this.c.insertAll(logs);
    }

    public void a(c omadacId, OmadaLogPO log) {
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, log.getTimeSec(), log.getTimeSec(), omadacId, collectionName -> this.c.save((Object)log, collectionName));
    }

    public void a(c omadacId, List<OmadaLogPO> list, String collectionName) {
        if (CollectionUtils.isEmpty(list) || !collectionName.startsWith(this.getCollectionNameOrPrefixIfSliced())) {
            return;
        }
        String newSuffix = this.b.b(new String[]{omadacId.a()});
        String newCollectionName = collectionName.replaceFirst("t\\d+s\\d+", newSuffix);
        if (this.getCollectionNames().stream().noneMatch(c2 -> c2.a().equals(newCollectionName))) {
            this.ensureCollection(newCollectionName);
        }
        this.c.insert(list, newCollectionName);
    }

    public long a(com.tplink.smb.omada.common.gridquery.b queryData, c omadacId, String siteId) {
        AtomicLong total = new AtomicLong(0L);
        Map filterMap = queryData.f();
        Long timeStart = Optional.ofNullable(filterMap).map(filters -> filters.get("timeStart")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Long timeEnd = Optional.ofNullable(filterMap).map(filters -> filters.get("timeEnd")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId.a());
        ArrayList<Criteria> andCriteria = new ArrayList<Criteria>();
        if (Objects.nonNull(siteId)) {
            andCriteria.add(Criteria.where((String)"site").is((Object)siteId));
        } else {
            andCriteria.add(Criteria.where((String)"site").is(null));
        }
        if (timeStart != null || timeEnd != null) {
            Criteria timeCriteria = Criteria.where((String)"time");
            if (timeStart != null) {
                timeCriteria.gte((Object)timeStart);
            }
            if (timeEnd != null) {
                timeCriteria.lte((Object)timeEnd);
            }
            andCriteria.add(timeCriteria);
        }
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{this.a(andCriteria, queryData.f(), queryData), criteria}));
        long startTimeSec = timeStart == null ? 0L : timeStart / 1000L;
        long endTimeSec = (timeEnd == null ? System.currentTimeMillis() : timeEnd) / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTimeSec, endTimeSec, omadacId, collectionName -> {
            long size = this.c.count(query, collectionName);
            total.addAndGet(size);
        });
        return total.get();
    }

    public void a(c omadacId, @Nullable String siteId, com.tplink.smb.omada.common.gridquery.b queryData, @Nonnull com.tplink.smb.omada.common.util.c.a<OmadaLogPO> consumer) {
        Map filterMap = queryData.f();
        Long timeStart = Optional.ofNullable(filterMap).map(filters -> filters.get("timeStart")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Long timeEnd = Optional.ofNullable(filterMap).map(filters -> filters.get("timeEnd")).map(obj -> ((Number)obj).longValue()).orElse(null);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId.a());
        ArrayList<Criteria> andCriteria = new ArrayList<Criteria>();
        if (Objects.nonNull(siteId)) {
            andCriteria.add(Criteria.where((String)"site").is((Object)siteId));
        } else {
            andCriteria.add(Criteria.where((String)"global").is((Object)Boolean.TRUE));
        }
        if (timeStart != null || timeEnd != null) {
            Criteria timeCriteria = Criteria.where((String)"time");
            if (timeStart != null) {
                timeCriteria.gte((Object)timeStart);
            }
            if (timeEnd != null) {
                timeCriteria.lte((Object)timeEnd);
            }
            andCriteria.add(timeCriteria);
        }
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{this.a(andCriteria, queryData.f(), queryData), criteria})).cursorBatchSize(1000);
        long startTimeSec = timeStart == null ? 0L : timeStart / 1000L;
        long endTimeSec = (timeEnd == null ? System.currentTimeMillis() : timeEnd) / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTimeSec, endTimeSec, omadacId, collectionName -> {
            MongoIterable iterable = this.c.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).map(src -> (OmadaLogPO)this.c.getConverter().read(OmadaLogPO.class, src));
            iterable.forEach(omadaLogPO -> consumer.a(omadaLogPO));
        });
    }

    private Criteria a(List<Criteria> andCriteria, Map<String, Object> filterMap, com.tplink.smb.omada.common.gridquery.b queryData) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(filterMap)) {
            for (Map.Entry<String, Object> entry : filterMap.entrySet()) {
                this.a(andCriteria, entry, queryData);
            }
        }
        if (andCriteria.size() > 0) {
            criteria.andOperator(andCriteria.toArray(new Criteria[0]));
        }
        ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
        if (Objects.nonNull(queryData.e())) {
            orCriteria.add(new Criteria("searchNames").regex(T.g((String)String.valueOf(queryData.e())), "i"));
            orCriteria.add(new Criteria("content").regex(T.g((String)String.valueOf(queryData.e())), "i"));
            orCriteria.add(Criteria.where((String)"module").regex(T.g((String)String.valueOf(queryData.e())), "i"));
        }
        if (orCriteria.size() > 0) {
            criteria.orOperator(orCriteria.toArray(new Criteria[0]));
        }
        return criteria;
    }

    private void a(List<Criteria> andCriteria, Map.Entry<String, Object> entry, com.tplink.smb.omada.common.gridquery.b queryData) {
        if (Objects.equals(entry.getKey(), "timeStart") || Objects.equals(entry.getKey(), "timeEnd")) {
            return;
        }
        String dbKey = (String)com.tplink.smb.omada.maintenance.common.b.ai.get(entry.getKey());
        if (T.a((String)dbKey)) {
            a.warn("invalid search key {} in log data export.", (Object)entry.getKey());
            return;
        }
        andCriteria.add(Criteria.where((String)dbKey).is(entry.getValue()));
    }

    @Override
    public List<String> getCollectionNameList() {
        return this.listCollectionNamesFromDB();
    }

    protected int e(@Nullable c key) {
        return Optional.ofNullable(key).map(c::a).map(String::hashCode).orElse(0);
    }

    protected n f() {
        return this.b;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaLogPO.INDEX_DEFINITIONS;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.c;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "omadalog";
    }

    protected Class<OmadaLogPO> getPOClass() {
        return OmadaLogPO.class;
    }

    public Long a(Long timeStamp) {
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(timeStamp / 1000L, 0, ZoneOffset.ofHours(8));
        return localDateTime.plus(30L, ChronoUnit.DAYS).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    protected /* synthetic */ p getStrategy() {
        return this.f();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.e((c)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.f();
    }
}

