/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.port.mongo;

import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.insight.api.internal.d;
import com.tplink.smb.omada.insight.api.internal.dto.ClearIncidentNotificationCacheDTO;
import com.tplink.smb.omada.insight.port.mongo.anomaly.notification.NotificationPO;
import com.tplink.smb.omada.insight.port.mongo.anomaly.notification.NotificationTemplatePO;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class IncidentNotificationMaintRepository {
    private final d incidentNotificationInternalApiService = (d)a.b(d.class);
    private final MongoTemplate mongoTemplate = (MongoTemplate)a.a((String)"insightMongoTemplate");
    private static final IncidentNotificationMaintRepository instance = new IncidentNotificationMaintRepository();

    private IncidentNotificationMaintRepository() {
    }

    public static IncidentNotificationMaintRepository getInstance() {
        return instance;
    }

    public Optional<NotificationPO> findByOmadacIdAndSiteId(String omadacId, String siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)siteId));
        return Optional.ofNullable((NotificationPO)this.mongoTemplate.findOne(query, NotificationPO.class));
    }

    public NotificationPO save(NotificationPO notificationPO) {
        return (NotificationPO)this.mongoTemplate.save((Object)notificationPO);
    }

    public NotificationTemplatePO save(NotificationTemplatePO notificationTemplate) {
        return (NotificationTemplatePO)this.mongoTemplate.save((Object)notificationTemplate);
    }

    public Optional<NotificationTemplatePO> findTemplateByOmadacIdAndSiteTemplateId(String omadacId, String siteTemplateId) {
        return Optional.ofNullable((NotificationTemplatePO)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("_id").is((Object)siteTemplateId)), NotificationTemplatePO.class));
    }

    public void deleteByOmadacId(String omadacId, n typeEnum) {
        if (n.a.equals((Object)typeEnum)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
            this.mongoTemplate.remove(query, NotificationPO.class);
        } else {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
            this.mongoTemplate.remove(query, NotificationTemplatePO.class);
        }
    }

    public void deleteByOmadacIdAndSiteId(String omadacId, String siteId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("_id").is((Object)siteId)), NotificationPO.class);
    }

    public void deleteTemplateByOmadacIdAndSiteId(String omadacId, String siteId) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("_id").is((Object)siteId)), NotificationTemplatePO.class);
    }

    public void deleteCacheByOmadacId(String omadacId) {
        this.incidentNotificationInternalApiService.a(new ClearIncidentNotificationCacheDTO(omadacId));
    }

    public void deleteCacheByOmadacIdAndSiteId(String omadacId, String siteId, boolean siteTemplate) {
        ClearIncidentNotificationCacheDTO dto = new ClearIncidentNotificationCacheDTO();
        dto.setOmadacId(omadacId);
        dto.setSiteId(siteId);
        dto.setSiteTemplate(Boolean.valueOf(siteTemplate));
        this.incidentNotificationInternalApiService.b(dto);
    }
}

