/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.mongo.omada;

import com.google.common.collect.ImmutableSet;
import com.mongodb.MongoCommandException;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoIterable;
import com.tplink.smb.omada.client.port.mongo.omada.client.ClientPO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.mongo.repository.r;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class a {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(a.class);
    private MongoTemplate c = (MongoTemplate)com.tplink.smb.omada.common.spring.a.a((String)"clientMongoTemplate");
    private static final a d = new a();
    public static final ImmutableSet<String> a = ImmutableSet.of((Object)"wireless", (Object)"guest", (Object)"block", (Object)"rate.enable");

    public static a a() {
        return d;
    }

    private a() {
    }

    public List<ClientPO> a(c omadacId, d siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()).orOperator(new Criteria[]{Criteria.where((String)"block").is((Object)true), Criteria.where((String)"rate.enable").is((Object)true), Criteria.where((String)"lock_to_ap").exists(true).and("lock_to_ap.enable").is((Object)true), Criteria.where((String)"alias").exists(true)}));
        return this.c.find(query, ClientPO.class);
    }

    public Set<String> a(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("lock_to_ap.enable").is((Object)true));
        query.fields().include("mac");
        return this.c.find(query, ClientPO.class).stream().map(ClientPO::getMac).collect(Collectors.toSet());
    }

    public void a(c omadacId, Set<String> macs) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("mac").in(macs).and("lock_to_ap.enable").in(new Object[]{null, false}));
        this.c.remove(query, ClientPO.class);
    }

    public long a(c omadacId, d siteId, long start, long end) {
        if (start > end) {
            long tmp = start;
            start = end;
            end = tmp;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()).and("last").gte((Object)start).lte((Object)end).and("block").is((Object)false).and("rate.enable").is((Object)false).and("lock_to_ap.enable").in(new Object[]{null, false}));
        return this.c.count(query, ClientPO.class);
    }

    public List<ClientPO> a(c omadacId, d siteId, long start, long end, com.tplink.smb.omada.common.gridquery.d page) {
        if (start > end) {
            long tmp = start;
            start = end;
            end = tmp;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()).and("last").gte((Object)start).lte((Object)end).and("block").is((Object)false).and("rate.enable").is((Object)false).and("lock_to_ap.enable").in(new Object[]{null, false}));
        query.fields().exclude("_id").exclude("block").exclude("rate").exclude("ip");
        query.with((Pageable)PageRequest.of((int)page.a(), (int)page.b()));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"last")}));
        query.withHint("site_1_last_-1");
        return this.c.find(query, ClientPO.class);
    }

    public void b(c omadacId) {
        this.c.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())), ClientPO.class);
    }

    public void b(c omadacId, d siteId) {
        this.c.remove(Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId.a())), ClientPO.class);
    }

    public long c(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        return this.c.count(query, ClientPO.class);
    }

    public ClientPO a(c omadacId, d siteId, String clientMac) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()).and("mac").is((Object)clientMac));
        return (ClientPO)this.c.findOne(query, ClientPO.class);
    }

    public void a(List<ClientPO> clientPOS) {
        if (CollectionUtils.isEmpty(clientPOS)) {
            return;
        }
        if (clientPOS.stream().allMatch(clientPO -> clientPO.getId() == null)) {
            this.c.insertAll(clientPOS);
        } else {
            clientPOS.forEach(arg_0 -> ((MongoTemplate)this.c).save(arg_0));
        }
    }

    public void b() {
        this.c.findOne(new Query(), ClientPO.class);
    }

    public void c() {
    }

    public void d() {
        this.a("create");
        this.a("wireless");
    }

    private void a(String indexName) {
        try {
            this.c.indexOps(ClientPO.class).dropIndex(indexName);
        }
        catch (Exception e2) {
            b.warn(e2.getMessage(), (Throwable)e2);
        }
    }

    private void a(String collectionName, IndexDefinition[] indexDefinitions) {
        if (indexDefinitions == null || indexDefinitions.length < 1) {
            return;
        }
        IndexOperations indexOperations = this.c.indexOps(collectionName);
        String dbName = this.c.getDb().getName();
        long start = System.currentTimeMillis();
        Set<Document> idxes = this.b(collectionName);
        long end = System.currentTimeMillis();
        b.info("get client all indexes cost {} ms", (Object)(end - start));
        for (IndexDefinition indexDefinition : indexDefinitions) {
            if (idxes.contains(indexDefinition.getIndexKeys())) {
                b.debug("Index: {} of collection: {}, DB: {} already exists, skip create index.", new Object[]{indexDefinition, collectionName, dbName});
                continue;
            }
            try {
                b.debug("Ensuring index: {} of collection: {}, DB: {}", new Object[]{indexDefinition, collectionName, dbName});
                if (indexDefinition instanceof Index) {
                    ((Index)indexDefinition).background();
                }
                this.a(() -> indexOperations.ensureIndex(indexDefinition), (Throwable e2) -> b.error("Failed to create index: {}", (Object)indexDefinition, e2));
            }
            catch (Throwable e3) {
                b.error("Failed to create index: {}", (Object)indexDefinition, (Object)e3);
            }
        }
    }

    private Set<Document> b(String collectionName) {
        HashSet<Document> idxes = new HashSet<Document>(10);
        ListIndexesIterable idxIterable = this.c.getCollection(collectionName).listIndexes();
        for (Document index : idxIterable) {
            idxes.add((Document)index.get((Object)"key", Document.class));
        }
        return idxes;
    }

    private <T> T a(Supplier<T> supplier, Consumer<Throwable> onEachFailure) throws Throwable {
        Object ex = new com.tplink.smb.omada.common.h.c("Execution Failed!");
        for (int interval : r.RETRY_INTERVAL_MS) {
            try {
                return supplier.get();
            }
            catch (Throwable e2) {
                if (e2 instanceof MongoCommandException) {
                    throw e2;
                }
                ex = e2;
                onEachFailure.accept(e2);
                b.warn("MongoDB Command Execution failed, Waiting {}ms for next execution.", (Object)interval, (Object)e2);
                Thread.sleep(interval);
            }
        }
        throw ex;
    }

    public OperationResponse<Long> a(c omadacId, d siteId, com.tplink.smb.omada.common.gridquery.b queryData, long checkLimit) {
        Criteria criteria = this.a(omadacId, siteId, queryData);
        Query query = new Query((CriteriaDefinition)criteria);
        long count = this.c.count(query, ClientPO.class);
        if (count > checkLimit) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eE, (Object)count);
        }
        return OperationResponse.success((Object)count);
    }

    public OperationResponse<?> b(c omadacId, d siteId, com.tplink.smb.omada.common.gridquery.b queryData, long checkLimit) {
        Criteria criteria = this.a(omadacId, siteId, queryData);
        Query fakeCount = new Query((CriteriaDefinition)criteria).skip(checkLimit).limit(1);
        long fakeCountRes = this.c.count(fakeCount, ClientPO.class);
        if (fakeCountRes > 0L) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eE);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse<?> a(@Nonnull c omadacId, @Nonnull d siteId, @Nonnull com.tplink.smb.omada.common.gridquery.b queryData, @Nonnull Function<ClientPO, OperationResponse<?>> func) {
        Criteria criteria = this.a(omadacId, siteId, queryData);
        Query query = new Query((CriteriaDefinition)criteria);
        String collectionName = this.c.getCollectionName(ClientPO.class);
        MongoIterable iterable = this.c.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).sort((Bson)query.getSortObject()).map(src -> (ClientPO)this.c.getConverter().read(ClientPO.class, src));
        for (ClientPO po : iterable) {
            OperationResponse<?> innerResp = func.apply(po);
            if (innerResp.success()) continue;
            return innerResp;
        }
        return OperationResponse.SUCCESS;
    }

    public long d(c omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).orOperator(new Criteria[]{Criteria.where((String)"block").is((Object)true), Criteria.where((String)"rate.enable").is((Object)true), Criteria.where((String)"lock_to_ap").exists(true).and("lock_to_ap.enable").is((Object)true)}));
        return this.c.count(query, ClientPO.class);
    }

    public List<ClientPO> a(c omadacId, com.tplink.smb.omada.common.gridquery.d page) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()).orOperator(new Criteria[]{Criteria.where((String)"block").is((Object)true), Criteria.where((String)"rate.enable").is((Object)true), Criteria.where((String)"lock_to_ap").exists(true).and("lock_to_ap.enable").is((Object)true)}));
        query.with((Pageable)PageRequest.of((int)page.a(), (int)page.b()));
        return this.c.find(query, ClientPO.class);
    }

    private Criteria a(@Nonnull c omadacId, @Nonnull d siteId, @Nonnull com.tplink.smb.omada.common.gridquery.b queryData) {
        Map filterMap = queryData.f();
        Criteria criteria = OmadacType.s() ? new Criteria("omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId.a()) : new Criteria("site").is((Object)siteId.a());
        Optional<Long> optStartMs = Optional.ofNullable((Number)filterMap.get("timeStart")).map(Number::longValue);
        Optional<Long> optEndMs = Optional.ofNullable((Number)filterMap.get("timeEnd")).map(Number::longValue);
        if (optStartMs.isPresent() && optEndMs.isPresent()) {
            criteria.and("last").gte((Object)optStartMs.get()).lte((Object)optEndMs.get());
        } else {
            optStartMs.ifPresent(startMs -> criteria.and("last").gte(startMs));
            optEndMs.ifPresent(endMs -> criteria.and("last").lte(endMs));
        }
        Optional<String> nameFilter = Optional.ofNullable((String)filterMap.remove("name")).filter(T::b);
        nameFilter.ifPresent(val -> criteria.and("name").regex(T.g((String)val), "i"));
        Optional<String> macFilter = Optional.ofNullable((String)filterMap.remove("mac")).filter(T::b);
        macFilter.ifPresent(val -> criteria.and("mac").regex(T.g((String)val), "i"));
        filterMap.forEach((key, value) -> {
            if (a.contains(key)) {
                criteria.and(key).is(value);
            }
        });
        String searchKey = queryData.e();
        if (T.a((String)searchKey) || nameFilter.isPresent() || macFilter.isPresent()) {
            return criteria;
        }
        return new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"name").regex(T.g((String)searchKey), "i")}), new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"mac").regex(T.g((String)searchKey), "i")})});
    }
}

