/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.dpi.api.web.dto.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="EditRuleEntity")
public class RuleEditOpenApiVO {
    @Schema(name="ruleName", description="Rule name. It should be 1 - 128 characters")
    @NotNull(message="Parameter [ruleName] is null")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [ruleName] should be 1 - 128 characters")
    private @NotNull(message="Parameter [ruleName] is null") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [ruleName] should be 1 - 128 characters") String ruleName;
    @Schema(name="schedule", description="Schedule profile ID, which can be queried by request\uff1a Get time range profile list.")
    @NotNull(message="Parameter [schedule] is null")
    private @NotNull(message="Parameter [schedule] is null") String schedule;
    @Schema(name="qos", description="Enable qos. true:enable / false:disable")
    @NotNull(message="Parameter [qos] is null")
    private @NotNull(message="Parameter [qos] is null") Boolean qos;
    @Schema(name="qosClass", description="The Class value selected in the Qos Class configuration, required when qos is enable. Valid values is 0: Others, 1: Class 1, 2: Class 2, 3: Class 3.")
    @Range(min=0L, max=3L, message="Parameter [classType] must be 0, 1, 2 or 3.")
    private @Range(min=0L, max=3L, message="Parameter [classType] must be 0, 1, 2 or 3.") Integer qosClass;
    @Schema(name="applications", description="Application ID list can be obtained from 'Get application list' interface.")
    @NotEmpty(message="Parameter [applications] is empty")
    private @NotEmpty(message="Parameter [applications] is empty") List<Integer> applications;

    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    @Generated
    public String getSchedule() {
        return this.schedule;
    }

    @Generated
    public Boolean getQos() {
        return this.qos;
    }

    @Generated
    public Integer getQosClass() {
        return this.qosClass;
    }

    @Generated
    public List<Integer> getApplications() {
        return this.applications;
    }

    @Generated
    public RuleEditOpenApiVO setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    @Generated
    public RuleEditOpenApiVO setSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @Generated
    public RuleEditOpenApiVO setQos(Boolean qos) {
        this.qos = qos;
        return this;
    }

    @Generated
    public RuleEditOpenApiVO setQosClass(Integer qosClass) {
        this.qosClass = qosClass;
        return this;
    }

    @Generated
    public RuleEditOpenApiVO setApplications(List<Integer> applications) {
        this.applications = applications;
        return this;
    }

    @Generated
    public RuleEditOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "RuleEditOpenApiVO(ruleName=" + this.getRuleName() + ", schedule=" + this.getSchedule() + ", qos=" + this.getQos() + ", qosClass=" + this.getQosClass() + ", applications=" + this.getApplications() + ")";
    }
}

