/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.dpi.api.web.dto.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.FilterMapCache;
import com.tplink.smb.omada.common.gridquery.b;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class DpiOpenApiQueryDataVO {
    @NotNull(message="page should not be null.")
    @Range(min=1L, message="page should not be less than 1.")
    private @NotNull(message="page should not be null.") @Range(min=1L, message="page should not be less than 1.") Integer page;
    @NotNull(message="pageSize should not be null.")
    @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.")
    private @NotNull(message="pageSize should not be null.") @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.") Integer pageSize;
    private String searchKey;
    @a(e=true)
    private Map<String, Object> filters;
    private Integer filtersFamilyId;

    public static b transQueryDataWithFilter(DpiOpenApiQueryDataVO queryDataVO, String filterMapKey) {
        b queryData = new b();
        queryData.a(queryDataVO.getPage() == null ? 1 : queryDataVO.getPage());
        queryData.b(queryDataVO.getPageSize() == null ? 10 : queryDataVO.getPageSize());
        queryData.c(queryDataVO.getSearchKey());
        if (filterMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty(queryDataVO.getFilters())) {
            Map filterMap = FilterMapCache.a((String)filterMapKey);
            queryDataVO.getFilters().forEach((key, value) -> {
                FilterMapCache.FilterKeyItem item = (FilterMapCache.FilterKeyItem)filterMap.get(key);
                if (item != null) {
                    switch (item.getType()) {
                        case NUMBER: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.getKey(), (Object)number);
                            break;
                        }
                        case BOOLEAN: {
                            queryData.a(item.getKey(), (Object)Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.getKey(), (Object)value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public boolean noNeedPagingQuery() {
        return this.page == 0 && this.pageSize == 0;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public Integer getFiltersFamilyId() {
        return this.filtersFamilyId;
    }

    public void setFiltersFamilyId(Integer filtersFamilyId) {
        this.filtersFamilyId = filtersFamilyId;
    }
}

