/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.dto.batch;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.apigateway.openapi.dto.batch.ActionDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

@Schema(name="Batch request entity")
public class BatchRequestDTO {
    @JsonProperty(value="interrupt")
    @Schema(name="interrupt", description="Indicates whether to interrupt execution when encountering an error while executing openAPI, defaults to true")
    private Boolean interrupt;
    @Valid
    @JsonProperty(value="actions")
    @Schema(name="actions", description="List of OpenAPIs that require batch execution. Up to 20 entries are allowed for the action list")
    private List<ActionDTO> actions;

    public OperationResponse check(boolean fromApp) {
        if (this.interrupt == null) {
            this.setInterrupt(true);
        }
        if (CollectionUtils.isEmpty(this.actions)) {
            return OperationResponse.SUCCESS;
        }
        if (this.actions.size() > 20) {
            return new OperationResponse(b.d, "The size of actions should not exceed 20", null);
        }
        for (ActionDTO action : this.actions) {
            OperationResponse checkAction = action.check(fromApp);
            if (checkAction.success()) continue;
            return checkAction;
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getInterrupt() {
        return this.interrupt;
    }

    @Generated
    public List<ActionDTO> getActions() {
        return this.actions;
    }

    @JsonProperty(value="interrupt")
    @Generated
    public BatchRequestDTO setInterrupt(Boolean interrupt) {
        this.interrupt = interrupt;
        return this;
    }

    @JsonProperty(value="actions")
    @Generated
    public BatchRequestDTO setActions(List<ActionDTO> actions) {
        this.actions = actions;
        return this;
    }

    @Generated
    public String toString() {
        return "BatchRequestDTO(interrupt=" + this.getInterrupt() + ", actions=" + this.getActions() + ")";
    }

    @Generated
    public BatchRequestDTO() {
    }

    @Generated
    public BatchRequestDTO(Boolean interrupt, List<ActionDTO> actions) {
        this.interrupt = interrupt;
        this.actions = actions;
    }
}

