/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.dto.batch;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.apigateway.openapi.dto.batch.BatchApiConstant;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.json.JSONObject;

@Schema(name="Request action entity")
public class ActionDTO {
    @JsonProperty(value="path")
    @NotNull(message="Parameter [path] should not be null.")
    @Schema(name="path", description="OpenAPI request path. Same as regular OpenAPI, file upload and download are not supported.")
    private @NotNull(message="Parameter [path] should not be null.") String path;
    @JsonProperty(value="method")
    @NotNull(message="Parameter [method] should not be null.")
    @Schema(name="method", description="OpenAPI request method. Same as regular OpenAPI, it should be a value as follows: POST, PATCH, PUT, DELETE.")
    private @NotNull(message="Parameter [method] should not be null.") String method;
    @JsonProperty(value="body")
    @Schema(name="body", description="OpenAPI request body, same as regular OpenAPI. Should be a JSON object but not a string.")
    private JSONObject body;
    @JsonProperty(value="query")
    @Schema(name="query", description="OpenAPI request query of the path, same as regular OpenAPI.")
    private String query;

    public OperationResponse check(boolean fromApp) {
        if (T.a((String)this.path)) {
            return new OperationResponse(b.d, "A path in actions is null.", null);
        }
        if (this.path.contains("/files/") || this.path.contains("/filesWithData/")) {
            return new OperationResponse(b.d, "Batch API does not support uploading and downloading file operations.", null);
        }
        if (T.a((String)this.method)) {
            String errMsg = "Parameter method in action:{" + this.path + "} is null.";
            return new OperationResponse(b.d, errMsg, null);
        }
        this.setMethod(this.method.toUpperCase());
        if (!fromApp && !BatchApiConstant.METHOD_SET.contains(this.method)) {
            String errMsg = "Parameter method in action:{" + this.path + "} should be post, patch, put or delete.";
            return new OperationResponse(b.d, errMsg, null);
        }
        return OperationResponse.SUCCESS;
    }

    public String getBody() {
        return this.body == null ? null : this.body.toString();
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="path")
    @Generated
    public ActionDTO setPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="method")
    @Generated
    public ActionDTO setMethod(String method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="body")
    @Generated
    public ActionDTO setBody(JSONObject body) {
        this.body = body;
        return this;
    }

    @JsonProperty(value="query")
    @Generated
    public ActionDTO setQuery(String query) {
        this.query = query;
        return this;
    }

    @Generated
    public String toString() {
        return "ActionDTO(path=" + this.getPath() + ", method=" + this.getMethod() + ", body=" + this.getBody() + ", query=" + this.getQuery() + ")";
    }

    @Generated
    public ActionDTO() {
    }

    @Generated
    public ActionDTO(String path, String method, JSONObject body, String query) {
        this.path = path;
        this.method = method;
        this.body = body;
        this.query = query;
    }
}

