/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi;

import com.tplink.smb.omada.apigateway.openapi.OauthToken;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthGenerateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OauthGenerateService.class);
    private static final String OAUTH_CODE_PREFIX = "OC-";
    private static final String OAUTH_ACCESS_TOKEN_PREFIX = "AT-";
    private static final String OAUTH_REFRESH_TOKEN_PREFIX = "RT-";
    private static final int ACCESS_TOKEN_CACHE_TIME_TO_LIVE = 7200;

    public static OauthToken generateOauthTokenInfo(boolean needIncludeRefreshToken) {
        OauthToken oauthToken = new OauthToken();
        oauthToken.setAccessToken(OauthGenerateService.generateAccessToken());
        if (needIncludeRefreshToken) {
            oauthToken.setRefreshToken(OauthGenerateService.generateRefreshToken());
        }
        oauthToken.setTokenType("bearer");
        oauthToken.setExpiresIn(7200);
        return oauthToken;
    }

    public static String generateCode() {
        return OauthGenerateService.getUniqueTicket(OAUTH_CODE_PREFIX);
    }

    public static String generateAccessToken() {
        return OauthGenerateService.getUniqueTicket(OAUTH_ACCESS_TOKEN_PREFIX);
    }

    public static String generateRefreshToken() {
        return OauthGenerateService.getUniqueTicket(OAUTH_REFRESH_TOKEN_PREFIX);
    }

    private static String getUniqueTicket(String prefix) {
        return prefix + RandomStringUtils.randomAlphanumeric((int)32);
    }
}

