/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.starter.task;

import com.tplink.smb.omada.cloud.api.internal.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.obfuscate.KeepClassName;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.a.c;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.InitializationInfoDTO;
import com.tplink.smb.omada.starter.task.AbstractOmadaTask;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClassName
public class CloudStartUpTask
extends AbstractOmadaTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudStartUpTask.class);
    private static final int THREAD_SLEEP_BOUND = 10000;
    private static final String MSG_FAIL = "get bean fail.";

    @Override
    public int execute() {
        log.info("record: CloudStartUpTask start");
        log.debug("start cloudStartUpTask");
        if (OmadacType.r()) {
            return 1;
        }
        com.tplink.smb.omada.hwc.api.internal.a hwcService = (com.tplink.smb.omada.hwc.api.internal.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.hwc.api.internal.a.class);
        com.tplink.smb.omada.manager.configuration.api.internal.omadac.b omadacInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.b.class);
        c omadacLocalInternalApiService = (c)com.tplink.smb.omada.common.spring.a.b(c.class);
        if (hwcService == null || omadacInternalApiService == null || omadacLocalInternalApiService == null) {
            log.error(MSG_FAIL);
            return 0;
        }
        Runnable cloudStartUpTask = () -> {
            try {
                String omadacId;
                int count = 0;
                Random random = new Random();
                do {
                    Thread.sleep(3L + (long)random.nextInt(10000));
                } while ((omadacId = (String)Optional.ofNullable((OmadacVO)omadacLocalInternalApiService.b().getResult()).map(OmadacVO::getId).orElse(null)) == null && count++ < 10);
                if (omadacId == null) {
                    log.error("get default omadacId fail.");
                    return;
                }
                if (OmadacType.r()) {
                    hwcService.t();
                    log.info("start cloud access binding");
                    InitializationInfoDTO initializationInfo = (InitializationInfoDTO)omadacInternalApiService.e(omadacId).getResult();
                    if (initializationInfo != null && Objects.equals(initializationInfo.getConfigured(), true)) {
                        this.handleCloudAccessEnable();
                        return;
                    }
                    log.info("un-configured controller, start up cloud access");
                    this.startUpCloudAccess();
                    return;
                }
                this.handleCloudAccessEnable();
            }
            catch (InterruptedException e2) {
                log.warn("Error while waiting for starting cloud service.");
                Thread.currentThread().interrupt();
            }
        };
        boolean executed = b.a((Runnable)cloudStartUpTask);
        if (!executed) {
            log.error("Failed to execute cloudStartUpTask");
            return 0;
        }
        log.debug("end start cloudStartUpTask.");
        log.info("record: CloudStartUpTask finished");
        return 1;
    }

    private void handleCloudAccessEnable() {
        com.tplink.smb.omada.system.api.internal.c cloudDeviceService = (com.tplink.smb.omada.system.api.internal.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.system.api.internal.c.class);
        if (cloudDeviceService == null) {
            log.error(MSG_FAIL);
            return;
        }
        OperationResponse res = cloudDeviceService.a();
        boolean cloudAccessEnable = Objects.equals(res.getResult(), true);
        log.debug("Cloud Access Enable is {}", (Object)cloudAccessEnable);
        if (cloudAccessEnable) {
            this.startUpCloudAccess();
        } else {
            if (OmadacType.t()) {
                OperationResponse remoteBindingRes = cloudDeviceService.b();
                boolean remoteBindingEnable = Objects.equals(remoteBindingRes.getResult(), true);
                log.info("remote binding enable: {}", (Object)remoteBindingEnable);
                if (remoteBindingEnable) {
                    this.startUpCloudAccess();
                } else {
                    log.info("Cloud service is forbidden.");
                }
                return;
            }
            log.info("Cloud service is forbidden.");
        }
    }

    private void startUpCloudAccess() {
        com.tplink.smb.omada.system.api.internal.c cloudDeviceService = (com.tplink.smb.omada.system.api.internal.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.system.api.internal.c.class);
        a cloudAccessInternalApiService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
        if (cloudDeviceService == null || cloudAccessInternalApiService == null) {
            log.error(MSG_FAIL);
            return;
        }
        String deviceId = (String)cloudDeviceService.d().getResult();
        if (!T.a((String)deviceId)) {
            log.info("start cloud connect on a reset hwc");
            cloudAccessInternalApiService.a();
        }
    }
}

