/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.starter.adapter;

import com.mongodb.client.MongoClient;
import com.tplink.smb.component.storage.mongo.file.FileMongoRepositoryImpl;
import com.tplink.smb.omada.starter.adapter.a;
import com.tplink.smb.omada.starter.adapter.b;
import com.tplink.smb.omada.starter.adapter.c;
import java.util.Collections;
import java.util.Optional;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.data.convert.MappingContextTypeInformationMapper;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration(proxyBeanMethods=false)
@EnableMongoRepositories(basePackages={"com.tplink.smb.omada.identityaccess.port.mongo", "com.tplink.smb.omada.manager.port.mongo", "com.tplink.smb.omada.maintenance.port.mongo", "com.tplink.smb.omada.iam.port.mongo"}, mongoTemplateRef="mongoTemplate")
@DependsOn(value={"aesStrategy", "sha256Strategy"})
public class MongoConfigMain {
    private static final String a = "omada";

    public static String a() {
        return Optional.ofNullable(com.tplink.smb.omada.common.omadac.config.c.a((String)"omada.properties")).map(configuration -> configuration.a("db.name")).orElse(a);
    }

    @Bean
    public b dynamicMongoClientManager(MongoClient mongoClient) {
        return new b(mongoClient);
    }

    @Primary
    @Bean(name={"mongoMappingContext"})
    public MongoMappingContext mongoMappingContextWithoutSharding(MongoProperties properties) {
        c context = new c();
        context.setAutoIndexCreation(properties.isAutoIndexCreation());
        context.afterPropertiesSet();
        return context;
    }

    @Bean(value={"mongoTemplate", "clientMongoTemplate", "logManagerMongoTemplate", "monitorMongoTemplate", "insightMongoTemplate", "maintenanceMongoTemplate", "managerMongoTemplate", "identityAccessMongoTemplate"})
    @Primary
    public MongoTemplate mongoTemplate(MongoClient mongoClient, b mongoClientManager, MongoMappingContext context) {
        SimpleMongoClientDatabaseFactory factory;
        if (com.tplink.smb.omada.common.util.system.a.l()) {
            a dynamicDbFactory = new a(mongoClient, MongoConfigMain.a());
            factory = dynamicDbFactory;
            mongoClientManager.a(dynamicDbFactory);
        } else {
            factory = new SimpleMongoClientDatabaseFactory(mongoClient, MongoConfigMain.a());
        }
        DefaultMongoTypeMapper mapper = new DefaultMongoTypeMapper("_class", Collections.singletonList(new MappingContextTypeInformationMapper((MappingContext)context)));
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver((MongoDatabaseFactory)factory), (MappingContext)context);
        converter.setTypeMapper((MongoTypeMapper)mapper);
        return new MongoTemplate((MongoDatabaseFactory)factory, (MongoConverter)converter);
    }

    @Bean(value={"fileRepository", "clientFileRepository", "managerFileRepository"})
    @Primary
    public FileMongoRepositoryImpl fileRepository(MongoTemplate mongoTemplate) {
        GridFsTemplate gridFsTemplate = new GridFsTemplate(mongoTemplate.getMongoDatabaseFactory(), mongoTemplate.getConverter());
        return new FileMongoRepositoryImpl(gridFsTemplate, mongoTemplate);
    }
}

