/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.schedule;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.client.domain.model.statistic.ClientStatisticsScheduleProperties;
import com.tplink.smb.omada.client.domain.service.l;
import com.tplink.smb.omada.client.port.schedule.ClientHealthCollectScheduleTaskCronProperties;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.judgement.a.e;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@b
public class a
implements ScheduledEventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private ScheduleCenter b;
    @Autowired
    private LockService c;
    @Autowired
    private ClientStatisticsScheduleProperties d;
    @Autowired
    private l e;
    @Autowired
    private ClientHealthCollectScheduleTaskCronProperties f;
    @Autowired
    @Qualifier(value="clientStatisticsScheduleExecutor")
    private ExecutorService g;
    @Autowired
    private e h;
    private static final String i = "client_health_5min";
    private static final String j = "client_health_hourly";
    private static final String k = "client_health_daily";
    private static final String l = "client_health_statistic";

    @PostConstruct
    public void a() {
        com.tplink.smb.omada.common.concurrent.thread.a.a(() -> {
            List blackSheets = (List)this.h.a("schedule:task:limit", "black_sheet", List.class);
            if (!CollectionUtils.isEmpty((Collection)blackSheets) && blackSheets.contains(l)) {
                a.info("Platform not support {} schedule task.", (Object)l);
                return;
            }
            ScheduleTask fiveMinTask = ScheduleTask.builder().withIdentity(l, i).withCronTrigger(this.f.getFiveMinTask()).withEnableSharding(Integer.valueOf(this.d.getPartitions()), Integer.valueOf(this.d.getFiveMinShardBatchSize()), Long.valueOf(this.d.getFiveMinShardBatchDelayMill())).build();
            this.b.saveTask(fiveMinTask);
            ScheduleTask hourlyTask = ScheduleTask.builder().withIdentity(l, j).withCronTrigger(this.f.getOneHourTask()).withEnableSharding(Integer.valueOf(this.d.getPartitions()), Integer.valueOf(this.d.getHourShardBatchSize()), Long.valueOf(this.d.getHourShardBatchDelayMill())).build();
            this.b.saveTask(hourlyTask);
            ScheduleTask dailyTask = ScheduleTask.builder().withIdentity(l, k).withCronTrigger(this.f.getOneDayTask()).withEnableSharding(Integer.valueOf(this.d.getPartitions()), Integer.valueOf(this.d.getDailyShardBatchSize()), Long.valueOf(this.d.getDailyShardBatchDelayMill())).build();
            this.b.saveTask(dailyTask);
            this.b.registerEventHandler(l, (ScheduledEventHandler)this, this.g, com.tplink.smb.omada.common.concurrent.thread.b.f());
        });
    }

    public void handle(ScheduledEvent scheduledEvent) {
        long time;
        Integer shardingSize = scheduledEvent.getShardingParam().getShardingSize();
        Integer shardingIndex = scheduledEvent.getShardingParam().getShardingIndex();
        if (scheduledEvent.getTaskParam().equals(i)) {
            time = scheduledEvent.getScheduledTime() / 1000L / 300L * 300L;
            this.c.doWithTryLock("client:health:statistic:5min", (Object)shardingIndex, () -> {
                a.debug("client health statistic:5min: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                this.e.a(shardingIndex, time);
                return true;
            }, () -> {
                a.debug("client health statistic:5min: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                return false;
            });
        }
        if (scheduledEvent.getTaskParam().equals(j)) {
            time = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
            this.c.doWithTryLock("client:health:statistic:hourly", (Object)shardingIndex, () -> {
                a.debug("client health statistic:hourly: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                this.e.b(shardingIndex, time);
                return true;
            }, () -> {
                a.debug("client health statistic:hourly: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                return false;
            });
        }
        if (scheduledEvent.getTaskParam().equals(k)) {
            time = scheduledEvent.getScheduledTime() / 1000L / 3600L * 3600L;
            this.c.doWithTryLock("client:health:statistic:daily", (Object)shardingIndex, () -> {
                a.debug("client health statistic:daily: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                this.e.c(shardingIndex, time);
                return true;
            }, () -> {
                a.debug("client health statistic:daily: {}/{}, timestamp: {}", new Object[]{shardingIndex, shardingSize, time});
                return false;
            });
        }
    }
}

