/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.schedule;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.client.common.domain.model.shared.ExecutorCustomProperties;
import com.tplink.smb.omada.client.common.port.c.a;
import com.tplink.smb.omada.client.domain.model.client.ClientRecognitionProperties;
import com.tplink.smb.omada.client.domain.model.statistic.ClientStatisticsScheduleProperties;
import com.tplink.smb.omada.client.domain.model.statistic.task.CollectionMaintenanceTaskProperties;
import com.tplink.smb.omada.client.port.schedule.c;
import com.tplink.smb.omada.client.port.schedule.d;
import com.tplink.smb.omada.client.port.schedule.e;
import com.tplink.smb.omada.client.port.schedule.f;
import com.tplink.smb.omada.client.port.schedule.g;
import com.tplink.smb.omada.common.concurrent.thread.CommonExecutorProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CollectionMaintenanceTaskProperties.class})
public class ClientScheduleExecutorConfiguration {
    public static final String a = "client-schedule-recognition-task";
    public static final String b = "client-schedule-statistic-task";
    public static final String c = "client-schedule-statistic-clean-task";
    public static final String d = "client-statistics-dispatcher-executor";
    @Autowired
    private a e;
    @Autowired
    private ExecutorCustomProperties f;
    @Autowired
    private ClientStatisticsScheduleProperties g;
    @Autowired
    private ClientRecognitionProperties h;
    @Autowired
    private CommonExecutorProperties i;

    @Bean(value={"clientStatisticsDispatcherExecutor"})
    public ExecutorService clientStatisticsDispatcherExecutor() {
        Integer corePoolSize = Math.min(this.i.getCommCoreThreads(), 4);
        ThreadPoolExecutor executor = new ThreadPoolExecutor((int)corePoolSize, Integer.MAX_VALUE, 10L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("client-statistics-dispatcher-executor-%d").build());
        return this.e.a((ExecutorService)executor, d);
    }

    @Bean(value={"clientStatisticsScheduleExecutor"})
    @ConditionalOnMissingBean(name={"clientStatisticsScheduleExecutor"})
    public ExecutorService clientStatisticsScheduleExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4 * this.g.getPartitions(), 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("client-schedule-statistic-task-%d").build(), new c(this));
        return this.e.a((ExecutorService)executor, b);
    }

    @Bean(value={"clientStatisticsCleanScheduleExecutor"})
    @ConditionalOnMissingBean(name={"clientStatisticsCleanScheduleExecutor"})
    public ExecutorService clientStatisticsCleanScheduleExecutor() {
        ExecutorCustomProperties.ExecutorProperty executorProperty = this.f.get(c);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(executorProperty.getCoreSize(), executorProperty.getMaxSize(), executorProperty.getKeepAliveMillis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("client-schedule-statistic-clean-task-%d").build(), new d(this));
        return this.e.a((ExecutorService)executor, c);
    }

    @Bean(value={"clientOmadacIdSiteIdScheduleExecutor"})
    @ConditionalOnMissingBean(name={"clientOmadacIdSiteIdScheduleExecutor"})
    public ExecutorService clientOmadacIdSiteIdScheduleExecutor() {
        String executorName = "client-schedule-omadacId-siteId-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new e(this));
        return this.e.a((ExecutorService)executor, executorName);
    }

    @Bean(value={"clientDpiTrafficStatisticsScheduleExecutor"})
    @ConditionalOnMissingBean(name={"clientDpiTrafficStatisticsScheduleExecutor"})
    public ExecutorService clientDpiTrafficStatisticsScheduleExecutor() {
        String executorName = "client-schedule-dpi-traffic-stat-task";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4 * this.g.getPartitions(), 6L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new f(this));
        return this.e.a((ExecutorService)executor, b);
    }

    @Bean(value={"clientRecognitionScheduleExecutor"})
    @ConditionalOnMissingBean(name={"clientRecognitionScheduleExecutor"})
    public ExecutorService clientRecognitionScheduleExecutor() {
        String executorName = a;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.h.getThreadPoolCoreSize(), this.h.getThreadPoolMaxSize(), 60L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new g(this));
        return this.e.a((ExecutorService)executor, a);
    }
}

