/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.external.recognition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.api.internal.dto.BonjourServiceDTO;
import com.tplink.smb.omada.client.domain.model.client.RecognitionParamDTO;
import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class ClientParamDTO {
    @JsonProperty(value="mac")
    @a
    private String mac;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="dhcp")
    private DHCP dhcp;
    @JsonProperty(value="hua")
    private List<HttpUserAgent> hua;
    @JsonProperty(value="netBios")
    private NetBios netBios;
    @JsonProperty(value="bonjour")
    private Bonjour bonjour;
    @JsonProperty(value="mdns")
    private Mdns mdns;
    @JsonProperty(value="saveResult")
    private Boolean saveResult;

    public static ClientParamDTO fromRecognitionParam(@Nonnull RecognitionParamDTO param) {
        return new ClientParamDTO().setMac(param.getMac()).setHostname(param.getHostname()).setHua(Optional.ofNullable(HttpUserAgent.build(param.getHttpUserAgent(), null)).map(List::of).orElse(null)).setDhcp(DHCP.build(param.getDhcpParams(), param.getDhcpVendor(), param.getHostname(), param.getDhcpMud())).setNetBios(NetBios.build(param.getNetBiosDomain(), param.getNetBiosName())).setBonjour(Bonjour.build(param.getBonjourServices(), param.getBonjourName())).setMdns(Mdns.build(param.getMdnsName()));
    }

    @Generated
    public ClientParamDTO() {
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public DHCP getDhcp() {
        return this.dhcp;
    }

    @Generated
    public List<HttpUserAgent> getHua() {
        return this.hua;
    }

    @Generated
    public NetBios getNetBios() {
        return this.netBios;
    }

    @Generated
    public Bonjour getBonjour() {
        return this.bonjour;
    }

    @Generated
    public Mdns getMdns() {
        return this.mdns;
    }

    @Generated
    public Boolean getSaveResult() {
        return this.saveResult;
    }

    @JsonProperty(value="mac")
    @Generated
    public ClientParamDTO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @JsonProperty(value="hostname")
    @Generated
    public ClientParamDTO setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @JsonProperty(value="dhcp")
    @Generated
    public ClientParamDTO setDhcp(DHCP dhcp) {
        this.dhcp = dhcp;
        return this;
    }

    @JsonProperty(value="hua")
    @Generated
    public ClientParamDTO setHua(List<HttpUserAgent> hua) {
        this.hua = hua;
        return this;
    }

    @JsonProperty(value="netBios")
    @Generated
    public ClientParamDTO setNetBios(NetBios netBios) {
        this.netBios = netBios;
        return this;
    }

    @JsonProperty(value="bonjour")
    @Generated
    public ClientParamDTO setBonjour(Bonjour bonjour) {
        this.bonjour = bonjour;
        return this;
    }

    @JsonProperty(value="mdns")
    @Generated
    public ClientParamDTO setMdns(Mdns mdns) {
        this.mdns = mdns;
        return this;
    }

    @JsonProperty(value="saveResult")
    @Generated
    public ClientParamDTO setSaveResult(Boolean saveResult) {
        this.saveResult = saveResult;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ClientParamDTO)) {
            return false;
        }
        ClientParamDTO other = (ClientParamDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$saveResult = this.getSaveResult();
        Boolean other$saveResult = other.getSaveResult();
        if (this$saveResult == null ? other$saveResult != null : !((Object)this$saveResult).equals(other$saveResult)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        DHCP this$dhcp = this.getDhcp();
        DHCP other$dhcp = other.getDhcp();
        if (this$dhcp == null ? other$dhcp != null : !((Object)this$dhcp).equals(other$dhcp)) {
            return false;
        }
        List<HttpUserAgent> this$hua = this.getHua();
        List<HttpUserAgent> other$hua = other.getHua();
        if (this$hua == null ? other$hua != null : !((Object)this$hua).equals(other$hua)) {
            return false;
        }
        NetBios this$netBios = this.getNetBios();
        NetBios other$netBios = other.getNetBios();
        if (this$netBios == null ? other$netBios != null : !((Object)this$netBios).equals(other$netBios)) {
            return false;
        }
        Bonjour this$bonjour = this.getBonjour();
        Bonjour other$bonjour = other.getBonjour();
        if (this$bonjour == null ? other$bonjour != null : !((Object)this$bonjour).equals(other$bonjour)) {
            return false;
        }
        Mdns this$mdns = this.getMdns();
        Mdns other$mdns = other.getMdns();
        return !(this$mdns == null ? other$mdns != null : !((Object)this$mdns).equals(other$mdns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientParamDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $saveResult = this.getSaveResult();
        result = result * 59 + ($saveResult == null ? 43 : ((Object)$saveResult).hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        DHCP $dhcp = this.getDhcp();
        result = result * 59 + ($dhcp == null ? 43 : ((Object)$dhcp).hashCode());
        List<HttpUserAgent> $hua = this.getHua();
        result = result * 59 + ($hua == null ? 43 : ((Object)$hua).hashCode());
        NetBios $netBios = this.getNetBios();
        result = result * 59 + ($netBios == null ? 43 : ((Object)$netBios).hashCode());
        Bonjour $bonjour = this.getBonjour();
        result = result * 59 + ($bonjour == null ? 43 : ((Object)$bonjour).hashCode());
        Mdns $mdns = this.getMdns();
        result = result * 59 + ($mdns == null ? 43 : ((Object)$mdns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientParamDTO(mac=" + this.getMac() + ", hostname=" + this.getHostname() + ", dhcp=" + this.getDhcp() + ", hua=" + this.getHua() + ", netBios=" + this.getNetBios() + ", bonjour=" + this.getBonjour() + ", mdns=" + this.getMdns() + ", saveResult=" + this.getSaveResult() + ")";
    }

    public static class HttpUserAgent {
        @JsonProperty(value="userAgent")
        String userAgent;
        @JsonProperty(value="hints")
        String hints;

        public static HttpUserAgent build(String userAgent, String hints) {
            if (T.c((String)userAgent) && T.c((String)hints)) {
                return null;
            }
            return new HttpUserAgent(userAgent, hints);
        }

        @Generated
        public String getUserAgent() {
            return this.userAgent;
        }

        @Generated
        public String getHints() {
            return this.hints;
        }

        @JsonProperty(value="userAgent")
        @Generated
        public HttpUserAgent setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @JsonProperty(value="hints")
        @Generated
        public HttpUserAgent setHints(String hints) {
            this.hints = hints;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof HttpUserAgent)) {
                return false;
            }
            HttpUserAgent other = (HttpUserAgent)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
                return false;
            }
            String this$hints = this.getHints();
            String other$hints = other.getHints();
            return !(this$hints == null ? other$hints != null : !this$hints.equals(other$hints));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpUserAgent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            String $hints = this.getHints();
            result = result * 59 + ($hints == null ? 43 : $hints.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.HttpUserAgent(userAgent=" + this.getUserAgent() + ", hints=" + this.getHints() + ")";
        }

        @Generated
        public HttpUserAgent(String userAgent, String hints) {
            this.userAgent = userAgent;
            this.hints = hints;
        }
    }

    public static class DHCP {
        @JsonProperty(value="params")
        String params;
        @JsonProperty(value="vendor")
        String vendor;
        @JsonProperty(value="hostname")
        String hostname;
        @JsonProperty(value="mud")
        String mud;

        public static DHCP build(String params, String vendor, String hostname, String mud) {
            if (T.c((String)params) && T.c((String)vendor) && T.c((String)hostname) && T.c((String)mud)) {
                return null;
            }
            return new DHCP(params, vendor, hostname, mud);
        }

        @Generated
        public String getParams() {
            return this.params;
        }

        @Generated
        public String getVendor() {
            return this.vendor;
        }

        @Generated
        public String getHostname() {
            return this.hostname;
        }

        @Generated
        public String getMud() {
            return this.mud;
        }

        @JsonProperty(value="params")
        @Generated
        public DHCP setParams(String params) {
            this.params = params;
            return this;
        }

        @JsonProperty(value="vendor")
        @Generated
        public DHCP setVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        @JsonProperty(value="hostname")
        @Generated
        public DHCP setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @JsonProperty(value="mud")
        @Generated
        public DHCP setMud(String mud) {
            this.mud = mud;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof DHCP)) {
                return false;
            }
            DHCP other = (DHCP)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$params = this.getParams();
            String other$params = other.getParams();
            if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            String this$mud = this.getMud();
            String other$mud = other.getMud();
            return !(this$mud == null ? other$mud != null : !this$mud.equals(other$mud));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DHCP;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            String $mud = this.getMud();
            result = result * 59 + ($mud == null ? 43 : $mud.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.DHCP(params=" + this.getParams() + ", vendor=" + this.getVendor() + ", hostname=" + this.getHostname() + ", mud=" + this.getMud() + ")";
        }

        @Generated
        public DHCP(String params, String vendor, String hostname, String mud) {
            this.params = params;
            this.vendor = vendor;
            this.hostname = hostname;
            this.mud = mud;
        }
    }

    public static class NetBios {
        @JsonProperty(value="domain")
        String domain;
        @JsonProperty(value="name")
        String name;

        public static NetBios build(String domain, String name) {
            if (T.c((String)domain) && T.c((String)name)) {
                return null;
            }
            return new NetBios(domain, name);
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="domain")
        @Generated
        public NetBios setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public NetBios setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof NetBios)) {
                return false;
            }
            NetBios other = (NetBios)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetBios;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.NetBios(domain=" + this.getDomain() + ", name=" + this.getName() + ")";
        }

        @Generated
        public NetBios(String domain, String name) {
            this.domain = domain;
            this.name = name;
        }
    }

    public static class Bonjour {
        @JsonProperty(value="services")
        List<BonjourService> services;
        @JsonProperty(value="name")
        String name;

        public static Bonjour build(List<BonjourServiceDTO> services, String name) {
            if (CollectionUtils.isEmpty(services) && T.c((String)name)) {
                return null;
            }
            return new Bonjour(Optional.ofNullable(services).map(serviceList -> services.stream().map(item -> BonjourService.build(item.getName(), List.of(item.getTxt()))).toList()).orElse(null), name);
        }

        @Generated
        public List<BonjourService> getServices() {
            return this.services;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="services")
        @Generated
        public Bonjour setServices(List<BonjourService> services) {
            this.services = services;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public Bonjour setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Bonjour)) {
                return false;
            }
            Bonjour other = (Bonjour)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            List<BonjourService> this$services = this.getServices();
            List<BonjourService> other$services = other.getServices();
            if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bonjour;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<BonjourService> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.Bonjour(services=" + this.getServices() + ", name=" + this.getName() + ")";
        }

        @Generated
        public Bonjour(List<BonjourService> services, String name) {
            this.services = services;
            this.name = name;
        }
    }

    public static class Mdns {
        @JsonProperty(value="name")
        String name;

        public static Mdns build(String name) {
            if (T.c((String)name)) {
                return null;
            }
            return new Mdns(name);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        @Generated
        public Mdns setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Mdns)) {
                return false;
            }
            Mdns other = (Mdns)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Mdns;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.Mdns(name=" + this.getName() + ")";
        }

        @Generated
        public Mdns(String name) {
            this.name = name;
        }
    }

    public static class BonjourService {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="txt")
        List<String> txt;

        public static BonjourService build(String name, List<String> txt) {
            if (T.c((String)name) && CollectionUtils.isEmpty(txt)) {
                return null;
            }
            return new BonjourService(name, CollectionUtils.isEmpty(txt) ? null : txt);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getTxt() {
            return this.txt;
        }

        @JsonProperty(value="name")
        @Generated
        public BonjourService setName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="txt")
        @Generated
        public BonjourService setTxt(List<String> txt) {
            this.txt = txt;
            return this;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof BonjourService)) {
                return false;
            }
            BonjourService other = (BonjourService)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$txt = this.getTxt();
            List<String> other$txt = other.getTxt();
            return !(this$txt == null ? other$txt != null : !((Object)this$txt).equals(other$txt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BonjourService;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $txt = this.getTxt();
            result = result * 59 + ($txt == null ? 43 : ((Object)$txt).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientParamDTO.BonjourService(name=" + this.getName() + ", txt=" + this.getTxt() + ")";
        }

        @Generated
        public BonjourService(String name, List<String> txt) {
            this.name = name;
            this.txt = txt;
        }
    }
}

