/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.eventcenter;

import com.google.common.collect.Lists;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.client.application.a.A;
import com.tplink.smb.omada.client.application.a.B;
import com.tplink.smb.omada.client.application.a.C;
import com.tplink.smb.omada.client.application.a.f;
import com.tplink.smb.omada.client.application.a.g;
import com.tplink.smb.omada.client.application.a.h;
import com.tplink.smb.omada.client.application.a.i;
import com.tplink.smb.omada.client.application.a.j;
import com.tplink.smb.omada.client.application.a.l;
import com.tplink.smb.omada.client.application.a.m;
import com.tplink.smb.omada.client.application.a.q;
import com.tplink.smb.omada.client.application.a.s;
import com.tplink.smb.omada.client.application.a.t;
import com.tplink.smb.omada.client.application.a.y;
import com.tplink.smb.omada.client.application.n;
import com.tplink.smb.omada.client.common.domain.model.shared.k;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ApplicationBlockStatItemDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ClientTrafficStatEntryDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.InformTrafficStatAggregateDTO;
import com.tplink.smb.omada.client.port.cache.a.c;
import com.tplink.smb.omada.client.port.eventcenter.dto.ApClientInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.ApDeviceInfoSafeDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.GatewayClientInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.OswClientInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.inform.ApInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.inform.DeviceInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.inform.GatewayInformDTO;
import com.tplink.smb.omada.client.port.eventcenter.dto.inform.OswInformDTO;
import com.tplink.smb.omada.client.port.h.a;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.common.h.d;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.inform.ap.ClientConnectionStatInform;
import com.tplink.smb.omada.device.manage.message.inform.ap.ClientStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.ConnectFailStat;
import com.tplink.smb.omada.device.manage.message.inform.ap.EapSysLog;
import com.tplink.smb.omada.device.manage.message.inform.ap.WiredClientStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.BSSIDRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.RoamingRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.BssidItem;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecord;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecordStat;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecordStatEntry;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecordStatEntryItem;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.SsidItem;
import com.tplink.smb.omada.device.manage.message.inform.ap.multilink.MultiLinkItem;
import com.tplink.smb.omada.device.manage.message.inform.osg.DhcpClientInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformApplicationBlockEntry;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformApplicationTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformApplicationTrafficClientEntry;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformClientTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgClient;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgClientStats;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswClient;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswPort;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswClientStats;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPortStatus;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class b
implements EventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    private static final String b = "OMADA_DEVICE_INFORM_FROM_DEV_GW_GROUP_OMADA_CLIENT";
    private EventCenter c;
    private ExecutorService d;
    private n e;
    private com.tplink.smb.omada.client.port.h.a f;
    private com.tplink.smb.omada.client.port.cache.a.a g;
    private k h;
    private com.tplink.smb.omada.client.common.domain.model.b.a.a i;
    private com.tplink.smb.omada.client.application.k j;
    private com.tplink.smb.omada.manager.license.api.internal.a k;

    @PostConstruct
    public void a() {
        this.c.registerUnicast("omada.devicegateway.device.inform", b, (EventHandler)this, this.d);
    }

    @Trace(operationName="ClientInformFromDevGwWatcher.handleEvent")
    public void handleEvent(Event domainEvent) {
        try {
            Optional.of(domainEvent).map(this::a).filter(this::a).map(this::b).ifPresent(list -> {
                for (s cmd : list) {
                    this.e(cmd);
                    this.c(cmd);
                    this.d(cmd);
                    if (!CollectionUtils.isEmpty(cmd.z())) {
                        j cache = new j(cmd.z());
                        this.j.a(cmd.e().a(), cmd.f().a(), cache);
                    }
                    this.b(cmd);
                }
            });
        }
        catch (Exception e2) {
            if (e2 instanceof d) {
                a.info("Handle event DEVICE_INFORM failed with exception.", (Throwable)e2);
                this.f.a(a.a.c);
                return;
            }
            a.error("Handle event DEVICE_INFORM failed with exception.", (Throwable)e2);
            this.f.a(a.a.a);
        }
    }

    private boolean a(s informClientsCommand) {
        return informClientsCommand != null && (!CollectionUtils.isEmpty(informClientsCommand.b()) || informClientsCommand.c() || !CollectionUtils.isEmpty(informClientsCommand.x()) || !Objects.isNull(informClientsCommand.y()) || informClientsCommand.k() != null);
    }

    private void b(s cmd) {
        if (!this.a(cmd)) {
            a.trace("No client related information of cmd: {}", (Object)cmd);
            return;
        }
        long startMillis = System.currentTimeMillis();
        this.e.a(cmd);
        long deltaMillis = System.currentTimeMillis() - startMillis;
        a.debug("Process client inform of device<{}>, omadacId<{}>, clients<{}> consumed {}ms", new Object[]{cmd.g(), cmd.e(), cmd.b().size(), deltaMillis});
        this.f.a(deltaMillis);
    }

    private void c(s command) {
        if (command.i() == DeviceTypeEnum.a && command.p() != null) {
            a.trace("Updating ApWirelessInfo: {}, omadacId: {}, siteId: {}, apMac: {}", new Object[]{command.p(), command.e(), command.f(), command.g()});
            this.e.a(command.e(), command.f(), command.g(), command.p());
        }
    }

    private void d(s command) {
        if (command.i() == DeviceTypeEnum.b) {
            a.trace("Updating OsgInfo: omadacId: {}, siteId: {}, osgMac: {}", new Object[]{command.e(), command.f(), command.g()});
            this.e.a(command.e(), command.f(), command.g());
        }
    }

    private void e(s cmd) {
        this.i.a(cmd.e(), cmd.f());
    }

    private boolean a(DeviceInformDTO<?> deviceInform) {
        boolean shouldIgnore;
        boolean bl = shouldIgnore = deviceInform.getTimestamp() < System.currentTimeMillis() - 60000L;
        if (shouldIgnore) {
            a.warn("Ignored one deviceInformEvent of {}<{}> for too old ({}) to handle.", new Object[]{deviceInform.getDeviceType(), deviceInform.getDeviceMac(), deviceInform.getTimestamp()});
            this.f.a(a.a.b);
        }
        return !shouldIgnore;
    }

    @Nullable
    private q a(String deviceMac, OsgClientStats clientStats, long lastSeenMs) {
        if (clientStats == null) {
            a.debug("Gateway:{} informed invalid client:null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        String clientMac = clientStats.getMac();
        if (!com.tplink.smb.omada.common.util.f.c.aZ.matcher(clientMac).matches()) {
            a.info("Gateway:{} informed client:{} with invalid client mac:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, clientMac});
            return null;
        }
        Integer vid = clientStats.getVid();
        if (vid == null || vid < 1 || vid > 4096) {
            a.info("Gateway:{} informed client:{} with invalid vid:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, vid});
            return null;
        }
        return q.a().a(clientMac).b(clientStats.getHostName()).a(clientStats.getUpTime()).b(Math.max(0L, lastSeenMs - clientStats.getUpTime() * 1000L)).c(lastSeenMs).c(clientStats.getIpAddr()).a(clientStats.getIpv6List()).d(com.tplink.smb.omada.client.port.c.a.c.b(clientStats.getHostName())).a(false).d(false).d(clientStats.getTxThput()).e(clientStats.getRxByte()).f(clientStats.getTxByte()).g(clientStats.getRxPkt()).h(clientStats.getTxPkt()).k(vid).a();
    }

    @Nullable
    private InformTrafficStatAggregateDTO a(InformApplicationTraffic applicationsTraffic, Long timestamp) {
        if (Objects.isNull(applicationsTraffic)) {
            return null;
        }
        InformTrafficStatAggregateDTO trafficStatAggregateDTO = new InformTrafficStatAggregateDTO();
        List traffics = applicationsTraffic.getTraffics();
        List blocks = applicationsTraffic.getBlocks();
        List clientTrafficStatList = Optional.ofNullable(traffics).orElse(Collections.emptyList()).stream().map(this::a).collect(Collectors.toList());
        trafficStatAggregateDTO.setClientTraffics(clientTrafficStatList);
        List applicationBlockStatList = Optional.ofNullable(blocks).orElse(Collections.emptyList()).stream().map(this::a).collect(Collectors.toList());
        trafficStatAggregateDTO.setApplicationBlocks(applicationBlockStatList);
        return trafficStatAggregateDTO;
    }

    @Nullable
    private ClientTrafficStatEntryDTO a(InformApplicationTrafficClientEntry entry) {
        if (Objects.isNull(entry)) {
            return null;
        }
        ClientTrafficStatEntryDTO dto = new ClientTrafficStatEntryDTO();
        dto.setIp(entry.getIp());
        dto.setApplicationId(entry.getId());
        dto.setUp(entry.getUp());
        dto.setDown(entry.getDown());
        dto.setUpPackets(entry.getUpPackets());
        dto.setDownPackets(entry.getDownPackets());
        dto.setAge(Boolean.valueOf(Boolean.TRUE.equals(entry.getAge())));
        return dto;
    }

    private ApplicationBlockStatItemDTO a(InformApplicationBlockEntry entry) {
        if (Objects.isNull(entry)) {
            return null;
        }
        ApplicationBlockStatItemDTO dto = new ApplicationBlockStatItemDTO();
        dto.setApplicationId(entry.getId());
        dto.setBlockCount(entry.getCount());
        return dto;
    }

    @Nullable
    private q a(String deviceMac, OswClientStats clientStats, long lastSeenMs) {
        if (clientStats == null) {
            a.info("Switch:{} informed invalid client:null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        String clientMac = clientStats.getMac();
        if (!com.tplink.smb.omada.common.util.f.c.aZ.matcher(clientMac).matches()) {
            a.info("Switch:{} informed client:{} with invalid client mac:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, clientMac});
            return null;
        }
        Integer port = clientStats.getPort();
        String standardOswPort = clientStats.getStandardOswPort();
        if (port == null && T.c((String)standardOswPort) || port != null && port < 1) {
            a.info("Switch:{} informed client:{} with invalid port:{}, portIndex: {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, port, standardOswPort});
            return null;
        }
        Integer vid = clientStats.getVid();
        if (vid == null || vid < 1 || vid > 4096) {
            a.info("Switch:{} informed client:{} with invalid vid:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, vid});
            return null;
        }
        return q.a().a(clientMac).b(clientStats.getHostName()).a(clientStats.getUpTime()).b(Math.max(0L, lastSeenMs - clientStats.getUpTime() * 1000L)).c(lastSeenMs).c(clientStats.getIp()).a(clientStats.getIpv6List()).d(com.tplink.smb.omada.client.port.c.a.c.b(clientStats.getHostName())).a(false).d(false).d(clientStats.getTxThput()).e(clientStats.getRxByte()).f(clientStats.getTxByte()).g(clientStats.getRxPkt()).h(clientStats.getTxPkt()).k(vid).a(StandardOswPortIndex.resolveStandardPortIndex((Integer)port, (String)standardOswPort)).l(StandardOswPortIndex.resolveStandardPortIndex((Integer)port, (String)standardOswPort).getPort()).a((com.tplink.smb.omada.client.common.constant.g)Optional.ofNullable(clientStats.getDot1x()).map(com.tplink.smb.omada.client.common.constant.g::a).orElse(null)).k(T.a((String)clientStats.getDot1xIdentity()) ? null : clientStats.getDot1xIdentity()).n(clientStats.getDot1xVid()).a();
    }

    @Nullable
    private q a(String deviceMac, ClientStats clientStats, long lastSeenMs, boolean portalAuthed) {
        if (clientStats == null) {
            a.info("AP:{} informed invalid client:null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        String clientMac = clientStats.getMac();
        if (!com.tplink.smb.omada.common.util.f.c.aZ.matcher(clientMac).matches()) {
            a.info("AP:{} informed client:{} with invalid client mac:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, clientMac});
            return null;
        }
        List<y> multiLinkItems = Optional.ofNullable(clientStats.getMultiLinkItems()).orElse(Collections.emptyList()).stream().map(this::a).filter(Objects::nonNull).collect(Collectors.toList());
        long duration = T.k((String)clientStats.getActiveTime());
        return q.a().a(clientMac).b(clientStats.getDeviceName()).a(duration).b(Math.max(0L, lastSeenMs - duration * 1000L)).c(lastSeenMs).c(clientStats.getIp()).a(clientStats.getIpv6List()).d(Optional.ofNullable(clientStats.getType()).filter(com.tplink.smb.omada.client.port.c.a.c::a).orElseGet(() -> com.tplink.smb.omada.client.port.c.a.c.b(clientStats.getDeviceName()))).a(true).d(clientStats.getTxThput()).e(clientStats.getDown()).f(clientStats.getUp()).g(Optional.ofNullable(clientStats.getTxPacket()).orElse(multiLinkItems.stream().map(y::h).filter(Objects::nonNull).mapToLong(v2 -> v2).sum())).h(Optional.ofNullable(clientStats.getRxPacket()).orElse(multiLinkItems.stream().map(y::g).filter(Objects::nonNull).mapToLong(v2 -> v2).sum())).b(portalAuthed).e(clientStats.getSsid()).b(clientStats.getRadioId()).c(clientStats.getSnr()).d(clientStats.getCcq()).e(clientStats.getRssi()).i(Optional.ofNullable(clientStats.getRxRate()).orElse(multiLinkItems.stream().map(y::e).filter(Objects::nonNull).mapToLong(v2 -> v2).sum())).j(Optional.ofNullable(clientStats.getTxRate()).orElse(multiLinkItems.stream().map(y::f).filter(Objects::nonNull).mapToLong(v2 -> v2).sum())).f(clientStats.getPhymode()).c(Objects.equals(1, clientStats.getPs())).d(Objects.equals(1, clientStats.getGuest())).g((Integer)Optional.ofNullable(clientStats.getAssociationTime()).filter(t2 -> t2 < 1000000L).map(Math::toIntExact).orElse(null)).a(clientStats.getVid()).h(clientStats.getLatency()).g(clientStats.getRadiusUsername()).i(clientStats.getRids()).b(multiLinkItems).a();
    }

    @Nullable
    private y a(MultiLinkItem multiLinkItem) {
        if (Objects.isNull(multiLinkItem)) {
            return null;
        }
        return new y().a(multiLinkItem.getRadioId()).b(multiLinkItem.getSnr()).c(multiLinkItem.getRssi()).a(Objects.equals(1, multiLinkItem.getPs())).a(multiLinkItem.getRxRate()).b(multiLinkItem.getTxRate()).c(multiLinkItem.getRxPacket()).d(multiLinkItem.getTxPacket()).e(multiLinkItem.getTxRetryPkts()).f(multiLinkItem.getTxFailPkts()).d(multiLinkItem.getPhymode()).e(multiLinkItem.getBandWidth()).f(multiLinkItem.getLatency()).g(multiLinkItem.getDown()).h(multiLinkItem.getUp()).i(multiLinkItem.getTxThput());
    }

    @Nullable
    private q a(String deviceMac, WiredClientStats clientStats, long lastSeenMs) {
        if (clientStats == null) {
            a.info("Ap:{} informed invalid wired client:null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        String clientMac = clientStats.getMac();
        if (!com.tplink.smb.omada.common.util.f.c.aZ.matcher(clientMac).matches()) {
            a.info("Ap:{} informed wired client:{} with invalid client mac:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, clientMac});
            return null;
        }
        Integer port = clientStats.getPort();
        if (port == null || port < 1) {
            a.info("Ap:{} informed wired client:{} with invalid port:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, port});
            return null;
        }
        Integer vid = clientStats.getVid();
        if (vid == null || vid < 0 || vid > 4096) {
            a.info("Ap:{} informed client:{} with invalid vid:{}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), clientStats, vid});
            return null;
        }
        return q.a().a(clientMac).b(clientStats.getHostName()).a(clientStats.getUpTime()).b(Math.max(0L, lastSeenMs - clientStats.getUpTime() * 1000L)).c(lastSeenMs).c(clientStats.getIp()).a(clientStats.getIpv6List()).d(com.tplink.smb.omada.client.port.c.a.c.b(clientStats.getHostName())).a(false).d(false).d(clientStats.getTxThput()).e(clientStats.getTxByte()).f(clientStats.getRxByte()).g(clientStats.getTxPkt()).h(clientStats.getRxPkt()).k(vid).l(port).i(clientStats.getPortName()).a((com.tplink.smb.omada.client.common.constant.g)Optional.ofNullable(clientStats.getDot1x()).map(com.tplink.smb.omada.client.common.constant.g::a).orElse(null)).k(T.a((String)clientStats.getDot1xIdentity()) ? null : clientStats.getDot1xIdentity()).n(clientStats.getDot1xVid()).a();
    }

    private f a(s command, ClientConnectionStatInform clientConnectionStatInform) {
        if (clientConnectionStatInform == null) {
            return null;
        }
        ConnectFailStat connectFailStat = clientConnectionStatInform.getFail();
        if (connectFailStat == null) {
            return null;
        }
        f connectFailCommand = new f().a(command.g()).b(command.h());
        connectFailCommand.c(Optional.ofNullable(connectFailStat.getBlock()).orElse(0));
        connectFailCommand.a(Optional.ofNullable(connectFailStat.getTimeout()).orElse(0));
        connectFailCommand.b(Optional.ofNullable(connectFailStat.getWpa()).orElse(0));
        return connectFailCommand;
    }

    @Nullable
    private l a(EapSysLog eapSysLog, String apName) {
        List logs = Optional.ofNullable(eapSysLog).map(EapSysLog::getLogs).orElse(null);
        if (CollectionUtils.isEmpty((Collection)logs)) {
            return null;
        }
        List<m> logList = logs.stream().filter(item -> OmadaLogKeyEnumDTO.AP_C_FL.name().equals(item.getKey())).map(item -> new m(item.getKey(), item.getContent(), item.getTime())).collect(Collectors.toList());
        return new l(logList, apName);
    }

    private Optional<C> a(@Nonnull ApClientInformDTO informDTO) {
        if (informDTO.getWSettings2G() == null && informDTO.getWSettings5G() == null && informDTO.getWSettings5G2() == null && informDTO.getWSettings6G() == null) {
            return Optional.empty();
        }
        return Optional.of(C.e().a(Optional.ofNullable(informDTO.getWSettings2G()).map(WirelessInfo::getChannel).map(com.tplink.smb.omada.common.util.l::a).map(C.a::new).orElse(null)).b(Optional.ofNullable(informDTO.getWSettings5G()).map(WirelessInfo::getChannel).map(com.tplink.smb.omada.common.util.l::a).map(C.a::new).orElse(null)).c(Optional.ofNullable(informDTO.getWSettings5G2()).map(WirelessInfo::getChannel).map(com.tplink.smb.omada.common.util.l::a).map(C.a::new).orElse(null)).d(Optional.ofNullable(informDTO.getWSettings6G()).map(WirelessInfo::getChannel).map(com.tplink.smb.omada.common.util.l::a).map(C.a::new).orElse(null)).a());
    }

    private A a(RoamingRecord stat) {
        if (Objects.isNull(stat)) {
            return null;
        }
        List<B> commandList = Optional.ofNullable(stat.getItems()).orElse(Collections.emptyList()).stream().map(this::a).collect(Collectors.toList());
        return new A(stat.getMac(), stat.getSuccessCount(), stat.getFailCount(), commandList);
    }

    private B a(BSSIDRecord item) {
        if (Objects.isNull(item)) {
            return null;
        }
        return new B().a(item.getTime()).a(item.getRadioId()).a(item.getTBSSID());
    }

    private List<i> a(ConnectRecord connectRecord) {
        if (Objects.isNull(connectRecord)) {
            return Collections.emptyList();
        }
        Map ssidMap = Optional.ofNullable(connectRecord.getSsidTable()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(SsidItem::getIndex, SsidItem::getSsid, (v1, v2) -> v2, HashMap::new));
        Map bssidMap = Optional.ofNullable(connectRecord.getBssidTable()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(BssidItem::getIndex, BssidItem::getBssid, (v1, v2) -> v2, HashMap::new));
        return Optional.ofNullable(connectRecord.getConnectRecordStats()).orElse(Collections.emptyList()).stream().map(stat -> this.a((ConnectRecordStat)stat, (Map<Integer, String>)ssidMap, (Map<Integer, String>)bssidMap)).collect(Collectors.toList());
    }

    private i a(ConnectRecordStat stat, Map<Integer, String> ssidMap, Map<Integer, String> bssidMap) {
        if (Objects.isNull(stat)) {
            return null;
        }
        i command = new i().a(stat.getMac()).a(stat.getReAssociationCnt()).b(stat.getReAuthenticationCnt());
        List<g> connectRecordEntryCommands = Optional.ofNullable(stat.getItems()).orElse(Collections.emptyList()).stream().map(entry -> this.a((ConnectRecordStatEntry)entry, ssidMap, bssidMap)).filter(Objects::nonNull).collect(Collectors.toList());
        command.a(connectRecordEntryCommands);
        return command;
    }

    private g a(ConnectRecordStatEntry entry, Map<Integer, String> ssidMap, Map<Integer, String> bssidMap) {
        if (Objects.isNull(entry)) {
            return null;
        }
        g command = com.tplink.smb.omada.client.application.a.g.a().b(entry.getStep()).a(entry.getRadioId()).a(ssidMap.get(entry.getSsidIndex())).b(bssidMap.get(entry.getBssidIndex())).a(entry.getTotalDuration()).a();
        List<h> connectRecordEntryItemCommands = Optional.ofNullable(entry.getErrorItems()).orElse(Collections.emptyList()).stream().map(this::a).filter(Objects::nonNull).collect(Collectors.toList());
        command.a(connectRecordEntryItemCommands);
        return command;
    }

    private h a(ConnectRecordStatEntryItem item) {
        if (Objects.isNull(item)) {
            return null;
        }
        return new h().a(item.getTimestamp()).a(item.getDuration()).b(item.getErrorCode()).b(item.getServerDelay()).a(item.getServerIp());
    }

    private t a(String deviceMac, OswPortStatus oswPortStatus) {
        if (Objects.isNull(oswPortStatus)) {
            a.info("Switch:{} informed invalid port:null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        Integer port = oswPortStatus.getPort();
        String standardOswPort = oswPortStatus.getStandardPort();
        if (port == null && T.c((String)standardOswPort) || port != null && port < 1) {
            a.info("Switch:{} informed client:{} with invalid port:{}, portIndex: {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), oswPortStatus, port, standardOswPort});
            return null;
        }
        return new t().a(port).a(StandardOswPortIndex.resolveStandardPortIndex((Integer)port, (String)standardOswPort)).b(oswPortStatus.getStatus()).c(oswPortStatus.getSpeed()).d(oswPortStatus.getDuplex()).e(oswPortStatus.getTxErrorPkts()).j(oswPortStatus.getRxErrorPkts()).f(oswPortStatus.getMode()).a(oswPortStatus.getMembers()).f(oswPortStatus.getRx()).h(oswPortStatus.getRxBroadPkts()).i(oswPortStatus.getRxMultiPkts()).g(oswPortStatus.getRxPkts()).a(oswPortStatus.getTx()).c(oswPortStatus.getTxBroadPkts()).d(oswPortStatus.getTxMultiPkts()).b(oswPortStatus.getTxPkts()).e(oswPortStatus.getStpState());
    }

    @Nullable
    private DeviceInformDTO<?> a(Event event) {
        DeviceTypeEnum quickFilterDeviceType = this.a(event.getFilterKey());
        if (quickFilterDeviceType == null) {
            DeviceInformDTO<Object> deviceInformDTO;
            com.tplink.smb.omada.device.gateway.a.d.b.a informDTO = (com.tplink.smb.omada.device.gateway.a.d.b.a)x.a((String)((String)event.getMessage()), com.tplink.smb.omada.device.gateway.a.d.b.a.class);
            DeviceTypeEnum deviceType = DeviceTypeEnum.b((String)informDTO.d());
            switch (deviceType) {
                case a: {
                    deviceInformDTO = new ApInformDTO().setInformBody((ApClientInformDTO)x.a((Map)informDTO.i(), ApClientInformDTO.class));
                    break;
                }
                case b: {
                    deviceInformDTO = new GatewayInformDTO().setInformBody((GatewayClientInformDTO)x.a((Map)informDTO.i(), GatewayClientInformDTO.class));
                    break;
                }
                case c: {
                    deviceInformDTO = new OswInformDTO().setInformBody((OswClientInformDTO)x.a((Map)informDTO.i(), OswClientInformDTO.class));
                    break;
                }
                default: {
                    a.warn("Unknown device type: {}", (Object)deviceType);
                    return null;
                }
            }
            deviceInformDTO.setEcspVersion(informDTO.b()).setSeq(informDTO.c()).setDeviceType(informDTO.d()).setDeviceMac(informDTO.e()).setDeviceName(informDTO.f()).setOmadacId(informDTO.g()).setSiteId(informDTO.h()).setTimestamp(informDTO.j()).setAddressDTO(informDTO.m()).setWirelessRouter(informDTO.l()).setSupportAnomaly(informDTO.n());
            return deviceInformDTO;
        }
        switch (quickFilterDeviceType) {
            case a: {
                return (DeviceInformDTO)x.a((String)((String)event.getMessage()), ApInformDTO.class);
            }
            case c: {
                return (DeviceInformDTO)x.a((String)((String)event.getMessage()), OswInformDTO.class);
            }
            case b: {
                return (DeviceInformDTO)x.a((String)((String)event.getMessage()), GatewayInformDTO.class);
            }
        }
        return null;
    }

    @Nullable
    private List<s> b(DeviceInformDTO<?> deviceInformDTO) {
        if (deviceInformDTO instanceof ApInformDTO) {
            return this.c((ApInformDTO)deviceInformDTO);
        }
        if (deviceInformDTO instanceof GatewayInformDTO) {
            return this.a((GatewayInformDTO)deviceInformDTO);
        }
        if (deviceInformDTO instanceof OswInformDTO) {
            return this.a((OswInformDTO)deviceInformDTO);
        }
        a.warn("Unknown device inform type: {}", deviceInformDTO);
        return null;
    }

    @Nonnull
    private List<s> c(DeviceInformDTO<? extends ApClientInformDTO> informDTO) {
        boolean isWirelessRouter = Boolean.TRUE.equals(informDTO.getWirelessRouter());
        if (isWirelessRouter && DeviceTypeEnum.b.c(informDTO.getDeviceType())) {
            a.debug("Resolving WirelessRouter inform: {}", informDTO);
        }
        long lastSeenMs = Optional.ofNullable(informDTO.getTimestamp()).orElse(System.currentTimeMillis());
        String deviceMac = informDTO.getDeviceMac();
        String deviceName = informDTO.getDeviceName();
        r omadacId = new r(informDTO.getOmadacId());
        z siteId = new z(informDTO.getSiteId());
        Boolean supportAnomaly = informDTO.getSupportAnomaly();
        ApClientInformDTO apClientInform = informDTO.getInformBody();
        s command = s.a().a(omadacId).a(siteId).b(deviceMac).a(DeviceTypeEnum.a).c(deviceName).a(lastSeenMs).a(lastSeenMs).b(isWirelessRouter).a();
        ApDeviceInfoSafeDTO deviceInfo = apClientInform.getApDeviceInfo();
        if (deviceInfo != null) {
            this.h.a(omadacId, siteId, deviceMac, deviceName, DeviceTypeEnum.a.b(), supportAnomaly, deviceInfo.getModel(), deviceInfo.getModelVersion(), deviceInfo.getIp());
        }
        List<q> informClientCommands = Optional.ofNullable(apClientInform.getClients()).orElse(Collections.emptyList()).stream().map(clientStats -> this.a(deviceMac, (ClientStats)clientStats, lastSeenMs, false)).filter(Objects::nonNull).collect(Collectors.toList());
        informClientCommands.addAll(Optional.ofNullable(apClientInform.getPortalAuthClients()).orElse(Collections.emptyList()).stream().map(clientStats -> this.a(deviceMac, (ClientStats)clientStats, lastSeenMs, true)).filter(Objects::nonNull).collect(Collectors.toList()));
        informClientCommands.addAll(Optional.ofNullable(apClientInform.getWiredClients()).orElse(Collections.emptyList()).stream().map(wiredClientStats -> this.a(deviceMac, (WiredClientStats)wiredClientStats, lastSeenMs)).collect(Collectors.toList()));
        f connectFailCommand = this.a(command, apClientInform.getClientConnection());
        List<i> connectRecordsCommands = this.a(apClientInform.getConnectRecord());
        List<A> roamingRecordCommands = Optional.ofNullable(apClientInform.getRoamingRecordStats()).orElse(Collections.emptyList()).stream().map(this::a).filter(Objects::nonNull).collect(Collectors.toList());
        command.d(roamingRecordCommands);
        command.a(informClientCommands);
        command.a(connectFailCommand);
        command.b(connectRecordsCommands);
        if (apClientInform.getClients() != null || apClientInform.getPortalAuthClients() != null) {
            command.a(true);
        }
        Optional<C> optWInfo = this.a(apClientInform);
        command.a((C)optWInfo.orElse(null));
        Optional<c> optApInfo = this.g.b(omadacId, siteId, deviceMac);
        if (optApInfo.isPresent()) {
            c apInfo = optApInfo.get();
            command.a(apInfo.b() == null ? null : new com.tplink.smb.omada.client.common.domain.model.shared.B(apInfo.b()));
            command.a(optWInfo.flatMap(C::a).orElse(apInfo.c()));
            command.b(optWInfo.flatMap(C::b).orElse(apInfo.d()));
            command.c(optWInfo.flatMap(C::c).orElse(apInfo.e()));
            command.e(optWInfo.flatMap(C::d).orElse(apInfo.f()));
        } else {
            a.warn("Failed to get AP info from manager. {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            optWInfo.flatMap(C::a).ifPresent(command::a);
            optWInfo.flatMap(C::b).ifPresent(command::b);
            optWInfo.flatMap(C::c).ifPresent(command::c);
            optWInfo.flatMap(C::d).ifPresent(command::e);
        }
        if (!com.tplink.smb.omada.client.common.domain.a.d.a((String)omadacId.a())) {
            l eapClientLogCommand = this.a(apClientInform.getEapSysLog(), deviceName);
            command.a(eapClientLogCommand);
        }
        a.debug("Get an AP inform : {}", (Object)command);
        return Lists.newArrayList((Object[])new s[]{command});
    }

    @Nonnull
    private ArrayList<s> a(GatewayInformDTO informDTO) {
        boolean isWirelessRouter = Boolean.TRUE.equals(informDTO.getWirelessRouter());
        long lastSeenMs = Optional.ofNullable(informDTO.getTimestamp()).orElse(System.currentTimeMillis());
        String deviceMac = informDTO.getDeviceMac();
        String deviceName = informDTO.getDeviceName();
        r omadacId = new r(informDTO.getOmadacId());
        z siteId = new z(informDTO.getSiteId());
        GatewayClientInformDTO clientInform = (GatewayClientInformDTO)informDTO.getInformBody();
        s command = s.a().a(omadacId).a(siteId).b(deviceMac).a(DeviceTypeEnum.b).c(deviceName).b(isWirelessRouter).a(lastSeenMs).a();
        this.h.a(omadacId, siteId, deviceMac, deviceName, DeviceTypeEnum.b.b(), clientInform.getOsgDeviceInfo());
        if (!com.tplink.smb.omada.client.common.domain.a.d.a((String)omadacId.a())) {
            command.a(Optional.ofNullable(clientInform.getClient()).map(InformOsgClient::getClients).orElse(Collections.emptyList()).stream().map(clientStats -> this.a(deviceMac, (OsgClientStats)clientStats, lastSeenMs)).filter(Objects::nonNull).collect(Collectors.toList()));
            ArrayList<com.tplink.smb.omada.client.application.a.r> clientTrafficCommands = new ArrayList<com.tplink.smb.omada.client.application.a.r>();
            Optional.ofNullable(clientInform.getClientTraffic()).map(InformClientTraffic::getTraffic).orElse(Collections.emptyList()).forEach(entry -> clientTrafficCommands.add(com.tplink.smb.omada.client.application.a.r.a(entry)));
            command.e(clientTrafficCommands);
        }
        InformTrafficStatAggregateDTO trafficStatAggregate = this.a(clientInform.getApplicationsTraffic(), command.q());
        command.a(trafficStatAggregate);
        if (clientInform.getClient() != null) {
            command.a(true);
        }
        List dhcpClientInfoCommandList = Optional.ofNullable(clientInform.getDhcpClientInfo()).map(DhcpClientInfo::getClients).map(dhcpClientInfoEntries -> dhcpClientInfoEntries.stream().map(com.tplink.smb.omada.client.application.a.k::a).collect(Collectors.toList())).orElse(new ArrayList());
        command.f(dhcpClientInfoCommandList);
        a.debug("Get a Gateway inform : {}", (Object)command);
        ArrayList results = Lists.newArrayList((Object[])new s[]{command});
        if (Boolean.TRUE.equals(informDTO.getWirelessRouter())) {
            List<s> wirelessInformCommand = this.c(informDTO);
            results.addAll(wirelessInformCommand);
        }
        return results;
    }

    private List<s> a(OswInformDTO informDTO) {
        OswClientInformDTO oswClientInform = (OswClientInformDTO)informDTO.getInformBody();
        OswInformDeviceInfo oswInformDeviceInfo = oswClientInform.getOswInformDeviceInfo();
        if (oswInformDeviceInfo != null && !CollectionUtils.isEmpty((Collection)oswInformDeviceInfo.getStackUnits())) {
            return this.b(informDTO);
        }
        return this.c(informDTO);
    }

    private List<s> b(OswInformDTO informDTO) {
        OswClientInformDTO oswClientInform = (OswClientInformDTO)informDTO.getInformBody();
        if (oswClientInform.getClient() == null && oswClientInform.getPort() == null) {
            return null;
        }
        Map<Object, Object> unitClientStatsMap = new HashMap();
        if (oswClientInform.getClient() != null && !CollectionUtils.isEmpty((Collection)oswClientInform.getClient().getClients())) {
            unitClientStatsMap = oswClientInform.getClient().getClients().stream().collect(Collectors.groupingBy(oswClientStats -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswClientStats.getPort(), (String)oswClientStats.getStandardOswPort()).getUnit()));
        }
        Map<Object, Object> unitPortInfoMap = new HashMap();
        if (oswClientInform.getPort() != null && !CollectionUtils.isEmpty((Collection)oswClientInform.getPort().getPorts())) {
            unitPortInfoMap = oswClientInform.getPort().getPorts().stream().collect(Collectors.groupingBy(oswPortStatus -> StandardOswPortIndex.resolveStandardPortIndex((Integer)oswPortStatus.getPort(), (String)oswPortStatus.getStandardPort()).getUnit()));
        }
        this.a(informDTO.getOmadacId(), informDTO.getSiteId(), informDTO);
        List stackUnits = oswClientInform.getOswInformDeviceInfo().getStackUnits();
        ArrayList<s> result = new ArrayList<s>();
        for (OswInformDeviceInfo.OswInformDeviceInfoStackUnit memberInfo : stackUnits) {
            String deviceMac = memberInfo.getMac();
            if (!this.a(deviceMac, informDTO)) continue;
            r omadacId = new r(informDTO.getOmadacId());
            z siteId = new z(informDTO.getSiteId());
            s command = s.a().a(omadacId).a(siteId).b(deviceMac).a(DeviceTypeEnum.c).c(Optional.ofNullable(memberInfo.getName()).orElse(deviceMac)).a();
            long lastSeenMs = Optional.ofNullable(informDTO.getTimestamp()).orElse(System.currentTimeMillis());
            command.a(lastSeenMs);
            command.a(Optional.ofNullable((List)unitClientStatsMap.get(memberInfo.getUnit())).orElse(Collections.emptyList()).stream().map(clientStats -> this.a(deviceMac, (OswClientStats)clientStats, lastSeenMs)).filter(Objects::nonNull).collect(Collectors.toList()));
            command.d((Integer)Optional.ofNullable(informDTO.getOswInfo()).map(com.tplink.smb.omada.device.gateway.a.d.b.a.a::b).orElse(null));
            command.c(Optional.ofNullable((List)unitPortInfoMap.get(memberInfo.getUnit())).orElse(Collections.emptyList()).stream().map(portStatus -> this.a(deviceMac, (OswPortStatus)portStatus)).filter(Objects::nonNull).collect(Collectors.toList()));
            if (oswClientInform.getClient() != null) {
                command.a(true);
            }
            a.debug("Get a Switch inform : {}", (Object)command);
            result.add(command);
        }
        return result;
    }

    private List<s> c(OswInformDTO informDTO) {
        OswClientInformDTO oswClientInform = (OswClientInformDTO)informDTO.getInformBody();
        String deviceMac = informDTO.getDeviceMac();
        r omadacId = new r(informDTO.getOmadacId());
        z siteId = new z(informDTO.getSiteId());
        s command = s.a().a(omadacId).a(siteId).b(deviceMac).a(DeviceTypeEnum.b((String)informDTO.getDeviceType())).c(informDTO.getDeviceName()).a();
        long lastSeenMs = Optional.ofNullable(informDTO.getTimestamp()).orElse(System.currentTimeMillis());
        command.a(lastSeenMs);
        command.a(Optional.ofNullable(oswClientInform.getClient()).map(InformOswClient::getClients).orElse(Collections.emptyList()).stream().map(clientStats -> this.a(deviceMac, (OswClientStats)clientStats, lastSeenMs)).filter(Objects::nonNull).collect(Collectors.toList()));
        command.d((Integer)Optional.ofNullable(informDTO.getOswInfo()).map(com.tplink.smb.omada.device.gateway.a.d.b.a.a::b).orElse(null));
        command.c(Optional.ofNullable(oswClientInform.getPort()).map(InformOswPort::getPorts).orElse(Collections.emptyList()).stream().map(portStatus -> this.a(deviceMac, (OswPortStatus)portStatus)).filter(Objects::nonNull).collect(Collectors.toList()));
        if (oswClientInform.getClient() != null) {
            command.a(true);
        }
        a.debug("Get a Switch inform : {}", (Object)command);
        return Lists.newArrayList((Object[])new s[]{command});
    }

    @Nullable
    private DeviceTypeEnum a(String filterKey) {
        if (filterKey == null) {
            return null;
        }
        for (DeviceTypeEnum value : DeviceTypeEnum.values()) {
            if (!filterKey.startsWith(value.b())) continue;
            return value;
        }
        return null;
    }

    private void a(String omadacId, String siteId, OswInformDTO informDTO) {
        OswClientInformDTO oswClientInform = (OswClientInformDTO)informDTO.getInformBody();
        if (Objects.nonNull(oswClientInform.getOswInformDeviceInfo()) && !CollectionUtils.isEmpty((Collection)oswClientInform.getOswInformDeviceInfo().getStackUnits())) {
            Set stackMemberSet = oswClientInform.getOswInformDeviceInfo().getStackUnits().stream().map(OswInformDeviceInfo.OswInformDeviceInfoStackUnit::getMac).collect(Collectors.toSet());
            Optional.ofNullable(this.k.a(omadacId, siteId, stackMemberSet)).ifPresent(licenseActiveRespDTO -> {
                informDTO.setCheckoutLicense(licenseActiveRespDTO.getCheckoutLicense());
                informDTO.setStackMemberActiveMap(licenseActiveRespDTO.getMacActiveMap());
            });
        }
    }

    private boolean a(String mac, OswInformDTO informDTO) {
        if (!Boolean.TRUE.equals(informDTO.getCheckoutLicense())) {
            return true;
        }
        return Optional.ofNullable(informDTO.getStackMemberActiveMap()).map(map -> map.getOrDefault(mac, false)).orElse(false);
    }

    @Autowired
    public void a(EventCenter eventCenter) {
        this.c = eventCenter;
    }

    @Autowired
    public void a(n informClientApplicationService) {
        this.e = informClientApplicationService;
    }

    @Autowired
    @Qualifier(value="clientInformWorkGroup")
    public void a(ExecutorService clientInformWorkGroup) {
        this.d = clientInformWorkGroup;
    }

    @Autowired
    public void a(com.tplink.smb.omada.client.port.h.a clientMeters) {
        this.f = clientMeters;
    }

    @Autowired
    public void a(com.tplink.smb.omada.client.port.cache.a.a apInfoCache) {
        this.g = apInfoCache;
    }

    @Autowired
    public void a(k deviceObjectCache) {
        this.h = deviceObjectCache;
    }

    @Autowired
    public void a(com.tplink.smb.omada.client.common.domain.model.b.a.a activeSiteCache) {
        this.i = activeSiteCache;
    }

    @Autowired
    public void a(com.tplink.smb.omada.client.application.k dhcpClientInfoCacheService) {
        this.j = dhcpClientInfoCacheService;
    }

    @Autowired
    @Qualifier(value="ClientLicenseActiveCacheServiceImpl")
    public void a(com.tplink.smb.omada.manager.license.api.internal.a licenseActiveCacheService) {
        this.k = licenseActiveCacheService;
    }
}

