/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.client.common.domain.model.a.g.c;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.dto.LanNetworkDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.dto.QueryLanNetworkDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@com.tplink.smb.omada.common.spring.b
public class o {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(o.class);
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.a b;
    private final Cache<a, LanNetworkDTO> c;

    @Autowired
    public o(@Value(value="${omada.client.lan-cache.keep-alive-seconds:1800}") int lanCacheKeepAliveSeconds, com.tplink.smb.omada.manager.configuration.api.internal.site.wired.lannetwork.a lanNetworkInternalApiService) {
        this.b = lanNetworkInternalApiService;
        this.c = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(lanCacheKeepAliveSeconds)).build();
    }

    public void a(com.tplink.smb.omada.client.common.domain.model.a.g.b e2) {
        new HashSet(this.c.asMap().keySet()).stream().filter(key -> key.a(e2.a(), e2.b())).forEach(arg_0 -> this.c.invalidate(arg_0));
    }

    public void a(c e2) {
        Iterator iterator = e2.a().iterator();
        while (iterator.hasNext()) {
            int vid = (Integer)iterator.next();
            this.c.invalidate((Object)new a(e2.b(), e2.c(), vid));
        }
    }

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(c.class, this::a);
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.client.common.domain.model.a.g.b.class, this::a);
    }

    public Optional<LanNetworkDTO> a(r omadacId, z siteId, Integer vid) {
        if (omadacId == null || siteId == null || vid == null) {
            a.warn("Cannot find lan network, invalid params: OmadacId:{}, SiteId:{}, vid:{}", new Object[]{omadacId, siteId, vid});
            return Optional.empty();
        }
        if (vid == 0) {
            a.debug("Cannot find lan network, OmadacId:{}, SiteId:{}, vid:{}", new Object[]{omadacId, siteId, vid});
            return Optional.empty();
        }
        a key = new a(omadacId, siteId, vid);
        try {
            return Optional.of((LanNetworkDTO)this.c.get((Object)key, () -> {
                OperationResponse optRes = this.b.b(QueryLanNetworkDTO.builder().omadacId(omadacId.a()).siteId(siteId.a()).vlan(vid).siteSettingType(Integer.valueOf(x.a.a())).build());
                if (optRes.success() && optRes.getResult() != null) {
                    return (LanNetworkDTO)optRes.getResult();
                }
                if (optRes.success()) {
                    throw new b("Lan network does not exist, OmadacId: " + omadacId + ", SiteId: " + siteId + ", vid:" + vid);
                }
                throw new b("Failed to find lan network, manager service returned res: " + optRes + ", OmadacId: " + omadacId + ", SiteId: " + siteId + ", vid:" + vid);
            }));
        }
        catch (Exception e2) {
            if (e2.getCause() instanceof b) {
                a.info(e2.getMessage());
            } else {
                a.warn("Exception when finding lan network by OmadacId: {}, SiteId: {}, vid: {}.", new Object[]{omadacId, siteId, vid, e2});
            }
            return Optional.empty();
        }
    }

    private static class a {
        @Nonnull
        private final r a;
        @Nonnull
        private final z b;
        private final int c;

        public a(@Nonnull r omadacId, @Nonnull z siteId, int vid) {
            this.a = omadacId;
            this.b = siteId;
            this.c = vid;
        }

        public boolean a(@Nonnull r omadacId, @Nonnull z siteId) {
            return this.a.a(omadacId) && this.b.a(siteId);
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            if (this.c != other.c) {
                return false;
            }
            r this$omadacId = this.a;
            r other$omadacId = other.a;
            if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
                return false;
            }
            z this$siteId = this.b;
            z other$siteId = other.b;
            return !(this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId));
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.c;
            r $omadacId = this.a;
            result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
            z $siteId = this.b;
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            return result;
        }
    }

    private static class b
    extends Exception {
        public b(String message) {
            super(message);
        }
    }
}

