/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.ClientRoamRecordDTO;
import com.tplink.smb.omada.client.port.c.a.g;
import com.tplink.smb.omada.client.port.cache.roamrec.AggregateConnectDTO;
import com.tplink.smb.omada.client.port.cache.roamrec.AggregateRoamDTO;
import com.tplink.smb.omada.client.port.cache.roamrec.ExpireTimeDTO;
import com.tplink.smb.omada.client.port.cache.roamrec.a;
import com.tplink.smb.omada.client.port.cache.roamrec.b;
import com.tplink.smb.omada.client.port.cache.roamrec.c;
import com.tplink.smb.omada.common.util.W;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class k {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(k.class);
    private static final String b = "client.manager";
    private static final String c = "client.manager:roam.record";
    private static final String d = "client.manager:roam.data";
    private static final String e = "client.manager:connect.data";
    private static final int f = 10;
    private static final int g = 50;
    private static final int h = 5;
    private static final int i = 3;
    private static final int j = 20000;
    private static final int k = 60000;
    private static final Map<String, List<b>> l = new ConcurrentHashMap<String, List<b>>();
    private static final Map<String, Map<String, List<a>>> m = new ConcurrentHashMap<String, Map<String, List<a>>>();
    private static Cache<String, ExpireTimeDTO> n = CacheBuilder.newBuilder().maximumSize(20000L).expireAfterWrite(60000L, TimeUnit.MILLISECONDS).build();
    @Autowired
    private CacheService o;

    @PostConstruct
    public void a() {
        com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
            try {
                this.b();
                this.c();
            }
            catch (Exception e2) {
                a.warn("schedule cache roam pre data exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        }, (long)10L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void b() {
        HashMap<String, List<b>> tempMap = new HashMap<String, List<b>>(l);
        l.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 3) {
                a.info("Invalid key of roam preData: {}", key);
                return;
            }
            this.a(mapKey[0], mapKey[1], Long.parseLong(mapKey[2]), (List<b>)value);
        });
    }

    private void c() {
        HashMap<String, Map<String, List<a>>> tempMap = new HashMap<String, Map<String, List<a>>>(m);
        m.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 3) {
                a.info("Invalid key of connect preData: {}", key);
                return;
            }
            this.b(mapKey[0], mapKey[1], Long.parseLong(mapKey[2]), (Map<String, List<a>>)value);
        });
    }

    private void a(String omadacId, String siteId, long time, List<b> roamRecordList) {
        if (CollectionUtils.isEmpty(roamRecordList)) {
            return;
        }
        int size = roamRecordList.size();
        String cacheName = d;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(time, omadacId, siteId);
        List<List<b>> aggregateList = com.tplink.smb.omada.client.port.c.a.g.a(roamRecordList, size, 50);
        for (List<b> recordList : aggregateList) {
            AggregateRoamDTO aggregateRoamDTO = new AggregateRoamDTO(recordList);
            this.o.addSortedSetValue(cacheName, cacheKey, (Object)aggregateRoamDTO, (double)time);
        }
        String expireKey = this.b(omadacId, siteId, time);
        ExpireTimeDTO expireTimeDTO = Optional.ofNullable((ExpireTimeDTO)n.getIfPresent((Object)expireKey)).orElse(new ExpireTimeDTO());
        long cacheExpireLastSeen = expireTimeDTO.getRoamDataTime();
        if (W.a((long)cacheExpireLastSeen, (int)60000)) {
            a.debug("expire pre roam cache, cache name is {}, cache key is {}, expire time is {}", new Object[]{cacheName, cacheKey, 600000});
            this.o.expireKey(cacheName, cacheKey, 600000L, TimeUnit.MILLISECONDS);
            expireTimeDTO.setRoamDataTime(System.currentTimeMillis());
            n.put((Object)expireKey, (Object)expireTimeDTO);
        }
    }

    private void b(String omadacId, String siteId, long time, Map<String, List<a>> map) {
        String expireKey;
        ExpireTimeDTO expireTimeDTO;
        long cacheExpireLastSeen;
        if (CollectionUtils.isEmptyMap(map)) {
            return;
        }
        HashMap<String, List<a>> connectMap = new HashMap<String, List<a>>();
        String cacheName = e;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(time, omadacId, siteId);
        for (Map.Entry<String, List<a>> entry : map.entrySet()) {
            connectMap.put(entry.getKey(), entry.getValue());
            if (connectMap.size() < 50) continue;
            AggregateConnectDTO aggregateConnectDTO = new AggregateConnectDTO(connectMap);
            this.o.addSortedSetValue(cacheName, cacheKey, (Object)aggregateConnectDTO, (double)time);
            connectMap.clear();
        }
        if (CollectionUtils.isNotEmptyMap(connectMap)) {
            AggregateConnectDTO aggregateConnectDTO = new AggregateConnectDTO(connectMap);
            this.o.addSortedSetValue(cacheName, cacheKey, (Object)aggregateConnectDTO, (double)time);
        }
        if (W.a((long)(cacheExpireLastSeen = (expireTimeDTO = Optional.ofNullable((ExpireTimeDTO)n.getIfPresent((Object)(expireKey = this.b(omadacId, siteId, time)))).orElse(new ExpireTimeDTO())).getConnectDataTime()), (int)60000)) {
            a.debug("expire pre connect cache, cache name is {}, cache key is {}, expire time is {}", new Object[]{cacheName, cacheKey, 600000});
            this.o.expireKey(cacheName, cacheKey, 600000L, TimeUnit.MILLISECONDS);
            expireTimeDTO.setConnectDataTime(System.currentTimeMillis());
            n.put((Object)expireKey, (Object)expireTimeDTO);
        }
    }

    public void a(String omadacId, String siteId, long fiveMin, b roamRecord) {
        if (Objects.isNull(roamRecord)) {
            return;
        }
        List roamRecords = l.computeIfAbsent(this.b(omadacId, siteId, fiveMin), key -> Collections.synchronizedList(new ArrayList()));
        roamRecords.add(roamRecord);
    }

    public void a(String omadacId, String siteId, long fiveMin, a accessRecord) {
        if (Objects.isNull(accessRecord)) {
            return;
        }
        Map connectRecords = m.computeIfAbsent(this.b(omadacId, siteId, fiveMin), key -> new ConcurrentHashMap());
        List accessRecordList = connectRecords.computeIfAbsent(this.a(accessRecord.a(), accessRecord.f()), key -> new ArrayList());
        accessRecordList.add(accessRecord);
    }

    public List<b> a(String omadacId, String siteId, long time) {
        String cacheName = d;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(time, omadacId, siteId);
        int sortedSetSize = this.o.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        ArrayList aggregateRoamDTOList = new ArrayList();
        int pageCount = (int)Math.ceil((double)sortedSetSize * 1.0 / 50.0);
        a.debug("poll roam data, cacheName {}, cacheKey {}, page count is {}", new Object[]{cacheName, cacheKey, pageCount});
        for (int i2 = 0; i2 < pageCount; ++i2) {
            aggregateRoamDTOList.addAll(this.o.pollFirst(cacheName, cacheKey, 50, AggregateRoamDTO.class));
        }
        return aggregateRoamDTOList.stream().map(AggregateRoamDTO::getRoamRecordList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<AggregateConnectDTO> a(long time, String omadacId, String siteId) {
        String cacheName = e;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(time, omadacId, siteId);
        int sortedSetSize = this.o.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<AggregateConnectDTO> aggregateConnectDTOList = new ArrayList<AggregateConnectDTO>();
        int pageCount = (int)Math.ceil((double)sortedSetSize * 1.0 / 50.0);
        a.debug("poll connect data, cacheName {}, cacheKey {}, page count is {}", new Object[]{cacheName, cacheKey, pageCount});
        for (int i2 = 0; i2 < pageCount; ++i2) {
            aggregateConnectDTOList.addAll(this.o.pollFirst(cacheName, cacheKey, 50, AggregateConnectDTO.class));
        }
        return aggregateConnectDTOList;
    }

    public void a(String omadacId, String siteId, long time, Map<String, ClientRoamRecordDTO> map) {
        if (CollectionUtils.isEmptyMap(map)) {
            return;
        }
        long hourTime = com.tplink.smb.omada.client.port.c.a.g.a(time, 3600000L);
        String cacheKey = this.b(omadacId, siteId, hourTime);
        HashMap<String, ClientRoamRecordDTO> recordMap = new HashMap<String, ClientRoamRecordDTO>();
        long score = time - 300000L;
        for (Map.Entry<String, ClientRoamRecordDTO> entry : map.entrySet()) {
            recordMap.put(entry.getKey(), entry.getValue());
            if (recordMap.size() < 50) continue;
            c roamingDataRecord = new c(recordMap);
            this.o.addSortedSetValue(c, cacheKey, (Object)roamingDataRecord, (double)score);
            ++score;
            recordMap.clear();
        }
        if (CollectionUtils.isNotEmptyMap(recordMap)) {
            c roamingDataRecord = new c(recordMap);
            this.o.addSortedSetValue(c, cacheKey, (Object)roamingDataRecord, (double)score);
        }
        this.o.expireKey(c, cacheKey, 0x6DDD00L, TimeUnit.MILLISECONDS);
    }

    public Map<String, ClientRoamRecordDTO> a(String omadacId, String siteId, long hourTime, long startTime, long endTime) {
        String cacheKey = this.b(omadacId, siteId, hourTime);
        ArrayList recordList = new ArrayList();
        for (long start = startTime; start <= endTime; start += 300000L) {
            Collection collection;
            long score = start;
            long nextFiveMin = start + 300000L;
            long endScore = score + 5L - 1L;
            while (endScore < nextFiveMin && !CollectionUtils.isEmpty((Collection)(collection = this.o.rangeSortedByScore(c, cacheKey, (double)score, (double)endScore, c.class)))) {
                recordList.addAll(collection);
                endScore = (score += 5L) + 5L - 1L;
            }
        }
        HashMap<String, ClientRoamRecordDTO> map = new HashMap<String, ClientRoamRecordDTO>();
        for (c record : recordList) {
            Map<String, ClientRoamRecordDTO> clientRoamRecordMap = record.a();
            for (Map.Entry<String, ClientRoamRecordDTO> entry : clientRoamRecordMap.entrySet()) {
                ClientRoamRecordDTO clientRoamRecordDTO = (ClientRoamRecordDTO)map.get(entry.getKey());
                if (Objects.isNull(clientRoamRecordDTO)) {
                    clientRoamRecordDTO = entry.getValue();
                    map.put(entry.getKey(), clientRoamRecordDTO);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue().getRoamItems())) continue;
                ArrayList roamItems = new ArrayList(clientRoamRecordDTO.getRoamItems());
                roamItems.addAll(entry.getValue().getRoamItems());
                clientRoamRecordDTO.setRoamItems(roamItems);
            }
        }
        a.debug("get {} clients' roaming data between {} and {}, omadac: {}, site: {}", new Object[]{map.size(), startTime, endTime, omadacId, siteId});
        return map;
    }

    private String b(String omadacId, String siteId, long time) {
        return omadacId + ":" + siteId + ":" + time;
    }

    private String a(String s1, String s2) {
        return s1 + ":" + s2;
    }
}

