/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.common.port.c.a;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.AggregateClientConnectRecordStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.AggregateClientHealthStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientConnRecordStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientHealthStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.c;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class e {
    @Generated
    private static final Logger e = LoggerFactory.getLogger(e.class);
    static final String a = "ClientHealthStat_";
    private static final int f = 5;
    private static final int g = 20;
    private static final int h = 50;
    private static final String i = "client.health.stat.pre";
    private static final String j = "client.health.connect.pre";
    private static final String k = "client.health.stat.macs";
    private static final Map<String, List<ClientHealthStatPreDataDTO>> l = new ConcurrentHashMap<String, List<ClientHealthStatPreDataDTO>>();
    private static final Map<String, List<ClientConnRecordStatPreDataDTO>> m = new ConcurrentHashMap<String, List<ClientConnRecordStatPreDataDTO>>();
    private static final long n = 150000L;
    private static final long o = 900000L;
    static final long b = 1800000L;
    static final long c = 900000L;
    private static final int p = 2000;
    private static final int q = 10;
    private static final Cache<String, Long> r = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Cache<String, Long> s = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    static final Cache<String, Long> d = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.HOURS).build();
    private static final String t = "client-health-stat-cache-task";
    @Autowired
    private CacheService u;
    @Autowired
    private a v;
    @Autowired
    private com.tplink.smb.omada.client.port.h.a w;
    private ScheduledExecutorService x = null;

    @PostConstruct
    public void a() {
        this.x = this.v.a(com.tplink.smb.omada.common.concurrent.thread.b.b((int)1, (String)t), t);
        Runnable cachePreDataTask = () -> {
            try {
                this.c();
                this.d();
            }
            catch (Exception e2) {
                e.warn("schedule cache client health stat data exception: {}", (Object)e2.getMessage(), (Object)e2);
            }
        };
        this.x.scheduleWithFixedDelay(cachePreDataTask, 5 + new Random().nextInt(5), 5L, TimeUnit.SECONDS);
    }

    public void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull ClientHealthStatPreDataDTO clientHealthStatPreDataDTO, long timestamp) {
        String key = this.a(omadacId, siteId);
        List apClientAssocRecordList = l.computeIfAbsent(key, s2 -> Collections.synchronizedList(new ArrayList()));
        apClientAssocRecordList.add(clientHealthStatPreDataDTO);
        this.a(omadacId, siteId, clientHealthStatPreDataDTO.getClientMac(), timestamp);
    }

    public Map<String, List<ClientHealthStatPreDataDTO>> a(@Nonnull String omadacId, @Nonnull String siteId, long statTimeSecond) {
        List<AggregateClientHealthStatPreDataDTO> aggregateDate = this.d(omadacId, siteId, statTimeSecond);
        return com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(aggregateDate);
    }

    private List<AggregateClientHealthStatPreDataDTO> d(@Nonnull String omadacId, @Nonnull String siteId, long statTimeSecond) {
        String cacheName = i;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(statTimeSecond, omadacId, siteId);
        int sortedSetSize = this.u.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        int pageCount = sortedSetSize / 50 + 1;
        e.debug("poll client health stat data from {} : {} , total size : {} , page size : {} , page count : {} ", new Object[]{omadacId, siteId, sortedSetSize, 50, pageCount});
        ArrayList<AggregateClientHealthStatPreDataDTO> aggregateDataList = new ArrayList<AggregateClientHealthStatPreDataDTO>();
        for (int page = 0; page < pageCount; ++page) {
            aggregateDataList.addAll(this.u.pollFirst(cacheName, cacheKey, 50, AggregateClientHealthStatPreDataDTO.class));
        }
        return aggregateDataList;
    }

    public void a(@Nonnull String omadacId, @Nonnull String siteId, @Nonnull ClientConnRecordStatPreDataDTO clientConnRecordStatPreDataDTO, long timestamp) {
        String key = this.a(omadacId, siteId);
        List apClientAssocRecordList = m.computeIfAbsent(key, s2 -> Collections.synchronizedList(new ArrayList()));
        apClientAssocRecordList.add(clientConnRecordStatPreDataDTO);
        this.a(omadacId, siteId, clientConnRecordStatPreDataDTO.getClientMac(), timestamp);
    }

    public Map<String, List<ClientConnRecordStatPreDataDTO>> b(@Nonnull String omadacId, @Nonnull String siteId, long statTimeSecond) {
        List<AggregateClientConnectRecordStatPreDataDTO> aggregateDate = this.e(omadacId, siteId, statTimeSecond);
        return com.tplink.smb.omada.client.port.cache.clienthealthstat.c.b(aggregateDate);
    }

    private List<AggregateClientConnectRecordStatPreDataDTO> e(@Nonnull String omadacId, @Nonnull String siteId, long statTimeSecond) {
        String cacheName = j;
        String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(statTimeSecond, omadacId, siteId);
        int sortedSetSize = this.u.getSortedSetSize(cacheName, cacheKey);
        if (sortedSetSize == 0) {
            return Collections.emptyList();
        }
        int pageCount = sortedSetSize / 50 + 1;
        e.debug("poll client connect record  from {} : {} , total size : {} , page size : {} , page count : {} ", new Object[]{omadacId, siteId, sortedSetSize, 50, pageCount});
        ArrayList<AggregateClientConnectRecordStatPreDataDTO> aggregateDataList = new ArrayList<AggregateClientConnectRecordStatPreDataDTO>();
        for (int page = 0; page < pageCount; ++page) {
            aggregateDataList.addAll(this.u.pollFirst(cacheName, cacheKey, 50, AggregateClientConnectRecordStatPreDataDTO.class));
        }
        return aggregateDataList;
    }

    public Collection<String> a(String omadacId, String siteId, long statMilliSec, N timeGranularityEnum) {
        long now = System.currentTimeMillis();
        String key = this.a(omadacId, siteId);
        Collection<String> macs = Collections.emptyList();
        if (timeGranularityEnum == N.a) {
            long startTime = statMilliSec - 300000L;
            this.u.pollSortedByScore(k, key, 0.0, (double)startTime, String.class);
            macs = this.u.rangeSortedByScore(k, key, (double)startTime, Double.MAX_VALUE, String.class);
        }
        return macs;
    }

    private void a(String omadacId, String siteId, String clientMac, long timestamp) {
        long start = System.currentTimeMillis();
        if (T.c((String)clientMac)) {
            return;
        }
        String cacheKey = this.a(omadacId, siteId);
        this.u.addSortedSetValue(k, cacheKey, (Object)clientMac, (double)timestamp);
        this.a(d, k, cacheKey, cacheKey, 1800000L, 900000L);
    }

    private void c() {
        long startTime = System.currentTimeMillis();
        HashMap<String, List<ClientHealthStatPreDataDTO>> tempMap = new HashMap<String, List<ClientHealthStatPreDataDTO>>(l);
        l.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 2) {
                e.debug("Invalid key of client health stat record: {}", key);
                return;
            }
            this.a(mapKey[0], mapKey[1], (List<ClientHealthStatPreDataDTO>)value);
        });
    }

    private void d() {
        long startTime = System.currentTimeMillis();
        HashMap<String, List<ClientConnRecordStatPreDataDTO>> tempMap = new HashMap<String, List<ClientConnRecordStatPreDataDTO>>(m);
        m.clear();
        tempMap.forEach((key, value) -> {
            String[] mapKey = key.split(":");
            if (mapKey.length < 2) {
                e.debug("Invalid key of client health stat record: {}", key);
                return;
            }
            this.b(mapKey[0], mapKey[1], (List<ClientConnRecordStatPreDataDTO>)value);
        });
    }

    private void a(String omadacId, String siteId, List<ClientHealthStatPreDataDTO> preDataList) {
        if (CollectionUtils.isEmpty(preDataList)) {
            return;
        }
        HashMap<Long, List> dataListByPeriod = new HashMap<Long, List>();
        for (ClientHealthStatPreDataDTO clientHealthStatPreDataDTO : preDataList) {
            long period = this.a(clientHealthStatPreDataDTO.getTimestamp());
            List periodList = dataListByPeriod.computeIfAbsent(period, t2 -> new ArrayList());
            periodList.add(clientHealthStatPreDataDTO);
        }
        for (Map.Entry entry : dataListByPeriod.entrySet()) {
            long statTime = (Long)entry.getKey();
            String cacheName = i;
            String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(statTime, omadacId, siteId);
            List dataList = (List)entry.getValue();
            int size = dataList.size();
            List splitList = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(dataList, size, 20);
            for (List<ClientHealthStatPreDataDTO> list : splitList) {
                AggregateClientHealthStatPreDataDTO healthStatPreData = new AggregateClientHealthStatPreDataDTO(list);
                long timestamp = list.get(0).getTimestamp() / 1000L;
                this.u.addSortedSetValue(cacheName, cacheKey, (Object)healthStatPreData, (double)timestamp);
            }
            String localMapKey = this.c(omadacId, siteId, statTime);
            this.a(r, cacheName, cacheKey, localMapKey, 150000L, 900000L);
        }
    }

    private void b(String omadacId, String siteId, List<ClientConnRecordStatPreDataDTO> preDataList) {
        if (CollectionUtils.isEmpty(preDataList)) {
            return;
        }
        HashMap<Long, List> dataListByPeriod = new HashMap<Long, List>();
        for (ClientConnRecordStatPreDataDTO clientConnRecordStatPreDataDTO : preDataList) {
            long period = this.a(clientConnRecordStatPreDataDTO.getTimestamp());
            List periodList = dataListByPeriod.computeIfAbsent(period, t2 -> new ArrayList());
            periodList.add(clientConnRecordStatPreDataDTO);
        }
        for (Map.Entry entry : dataListByPeriod.entrySet()) {
            long statTime = (Long)entry.getKey();
            String cacheName = j;
            String cacheKey = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(statTime, omadacId, siteId);
            List dataList = (List)entry.getValue();
            int size = dataList.size();
            List splitList = com.tplink.smb.omada.client.port.cache.clienthealthstat.c.a(dataList, size, 20);
            for (List<ClientConnRecordStatPreDataDTO> list : splitList) {
                AggregateClientConnectRecordStatPreDataDTO connectRecordPreData = new AggregateClientConnectRecordStatPreDataDTO(list);
                long timestamp = list.get(0).getTimestamp() / 1000L;
                this.u.addSortedSetValue(cacheName, cacheKey, (Object)connectRecordPreData, (double)timestamp);
            }
            String localMapKey = this.c(omadacId, siteId, statTime);
            this.a(s, cacheName, cacheKey, localMapKey, 150000L, 900000L);
        }
    }

    private void a(Cache<String, Long> lastExpireTimeMap, String cacheName, String cacheKey, String localMapKey, long minInterval, long expireTime) {
        Long lastExpireTimeObj;
        long lastExpireTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastExpireTime = Optional.ofNullable(lastExpireTimeObj = (Long)lastExpireTimeMap.getIfPresent((Object)localMapKey)).orElse(currentTime - minInterval).longValue()) >= minInterval) {
            this.u.expireKey(cacheName, cacheKey, expireTime, TimeUnit.MILLISECONDS);
            lastExpireTimeMap.put((Object)localMapKey, (Object)currentTime);
        }
    }

    private String a(String omadacId, String siteId) {
        return omadacId + ":" + siteId;
    }

    public String c(String omadacId, String siteId, long time) {
        return omadacId + ":" + siteId + ":" + time;
    }

    private long a(long timestamp) {
        return (timestamp / 1000L / 300L + 1L) * 300L;
    }

    @PreDestroy
    public void b() {
        if (this.x != null && !this.x.isShutdown()) {
            this.x.shutdown();
            this.x = null;
        }
    }
}

