/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.domain.service;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.common.domain.a.h;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.domain.model.client.ClientRecognitionProperties;
import com.tplink.smb.omada.client.domain.model.client.J;
import com.tplink.smb.omada.client.domain.model.client.RecognitionParamDTO;
import com.tplink.smb.omada.client.domain.model.client.i;
import com.tplink.smb.omada.client.domain.model.client.w;
import com.tplink.smb.omada.client.domain.model.clientimage.d;
import com.tplink.smb.omada.client.domain.model.clientimage.g;
import com.tplink.smb.omada.client.domain.model.clientimage.j;
import com.tplink.smb.omada.client.domain.model.clientimage.k;
import com.tplink.smb.omada.client.domain.service.r;
import com.tplink.smb.omada.client.port.cache.f.a;
import com.tplink.smb.omada.client.port.cache.f.b;
import com.tplink.smb.omada.client.port.external.recognition.ClientParamDTO;
import com.tplink.smb.omada.client.port.external.recognition.ClientRecognitionResultDTO;
import com.tplink.smb.omada.client.port.external.recognition.RecognitionResponseDTO;
import com.tplink.smb.omada.client.port.external.recognition.ResultWrapperDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.global.subsystem.api.internal.c;
import com.tplink.smb.omada.judgement.a.e;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class t {
    @Generated
    private static final Logger l = LoggerFactory.getLogger(t.class);
    @Autowired
    g a;
    @Autowired
    k b;
    @Autowired
    w c;
    @Autowired
    r d;
    @Autowired
    ClientRecognitionProperties e;
    @Autowired
    a f;
    @Autowired
    h g;
    @Autowired
    e h;
    @Autowired
    com.tplink.smb.omada.client.port.cache.j i;
    @Autowired
    c j;
    @Autowired
    com.tplink.smb.omada.client.port.cache.query.a k;

    public void a(String omadacId, String siteId, Integer originRecognitionCount, RecognitionParamDTO recognitionParam) {
        this.f.a(new b(omadacId, siteId, originRecognitionCount, recognitionParam));
    }

    public void a() {
        ArrayList<i> clientSaveList = new ArrayList<i>();
        try {
            int batchSize = this.e.getClientsPerBatch();
            int batchNum = this.e.getBatchNum();
            int taskLevel = this.e.getTaskLevel();
            for (int i2 = 0; i2 < batchNum; ++i2) {
                this.a(batchSize, taskLevel, clientSaveList);
            }
            this.c.a(clientSaveList);
        }
        catch (Exception e2) {
            l.warn("Fail to handle batch recognize clients", (Throwable)e2);
        }
    }

    public void a(int batchSize, int taskLevel, List<i> clientsSaveList) {
        ResultWrapperDTO resultWrapper;
        OperationResponse<RecognitionResponseDTO> recognition;
        List<b> taskList = this.f.a(batchSize);
        if (CollectionUtils.isEmpty(taskList)) {
            l.debug("Client recognition triggered, No task to handle, skip.");
            return;
        }
        if (l.isDebugEnabled()) {
            l.debug("Client recognition task poll, queue length:{}", (Object)this.f.c());
        }
        List<ClientParamDTO> clientList = taskList.stream().map(task -> {
            ClientParamDTO paramDTO = ClientParamDTO.fromRecognitionParam(task.e());
            paramDTO.setSaveResult(this.i.a(new com.tplink.smb.omada.client.common.domain.model.shared.r(task.b()), () -> this.j.a(task.b())));
            if (T.c((String)paramDTO.getHostname())) {
                String netBiosName = Optional.ofNullable(paramDTO.getNetBios()).map(ClientParamDTO.NetBios::getName).orElse(null);
                String mdnsName = Optional.ofNullable(paramDTO.getMdns()).map(ClientParamDTO.Mdns::getName).orElse(null);
                String bonjourName = Optional.ofNullable(paramDTO.getBonjour()).map(ClientParamDTO.Bonjour::getName).orElse(null);
                if (T.a((Object)mdnsName)) {
                    paramDTO.setHostname(mdnsName);
                } else if (T.a((Object)bonjourName)) {
                    paramDTO.setHostname(bonjourName);
                } else if (T.a((Object)netBiosName)) {
                    paramDTO.setHostname(netBiosName);
                }
            }
            return paramDTO;
        }).toList();
        if (l.isDebugEnabled()) {
            l.debug("Got {} tasks from queue, Raw task: {}, Prepared client to send request to cloud: {}", new Object[]{taskList.size(), taskList, clientList});
        }
        if (!(recognition = this.d.a(clientList)).success()) {
            l.warn("fail to recognize clients: {}, response: {}", taskList.stream().map(b::a).toList(), recognition);
            return;
        }
        if (l.isDebugEnabled()) {
            l.debug("Received recognition result, response: {}", recognition.getResult());
        }
        if ((resultWrapper = ((RecognitionResponseDTO)recognition.getResult()).getResult()) == null) {
            l.warn("fail to recognize clients: {}, response: {}", taskList.stream().map(b::a).toList(), recognition);
            return;
        }
        List<ClientRecognitionResultDTO> resultList = resultWrapper.getClientList();
        Map resultMap = Optional.ofNullable(resultList).orElse(Collections.emptyList()).stream().filter(result -> result.getMac() != null).collect(Collectors.toMap(ClientRecognitionResultDTO::getMac, Function.identity()));
        for (int i2 = 0; i2 < taskList.size(); ++i2) {
            try {
                this.a(taskList.get(i2), Optional.ofNullable(taskList.get(i2).e()).map(RecognitionParamDTO::getMac).map(resultMap::get).orElse(null), clientsSaveList);
                continue;
            }
            catch (Exception e2) {
                l.warn("fail to apply client recognition result, task: {}, response: {}", new Object[]{taskList.get(i2).a(), resultList.get(i2), e2});
            }
        }
    }

    private void a(b task, @Nullable ClientRecognitionResultDTO result, List<i> clientsSaveList) {
        com.tplink.smb.omada.client.common.domain.model.shared.r omadacId = new com.tplink.smb.omada.client.common.domain.model.shared.r(task.b());
        z siteId = new z(task.c());
        String mac = task.e().getMac();
        com.tplink.smb.omada.client.domain.model.client.t.a(result);
        if (l.isDebugEnabled()) {
            l.debug("Client Recognition Result remapped, applying result, task: {}, response: {}", (Object)task.a(), (Object)result);
        }
        this.g.c(omadacId, siteId, mac, () -> {
            Optional<i> clientOpt = this.c.a(omadacId, siteId, mac);
            clientOpt.ifPresentOrElse(client -> {
                J oldRecognition = Optional.ofNullable(client.am()).orElse(new J());
                client.a(oldRecognition.b(task.e(), task.d() + 1));
                if (result != null) {
                    if (!Optional.ofNullable(client.am()).map(J::a).orElse(false).booleanValue() && !com.tplink.smb.omada.client.port.c.a.d.d(mac)) {
                        client.g(result.getClientType());
                        client.s(result.getGroup());
                    }
                    client.p(result.getSystemVersion());
                    if (!Optional.ofNullable(client.am()).map(J::b).orElse(false).booleanValue()) {
                        client.j(result.getBrand());
                    }
                    if (!Optional.ofNullable(client.am()).map(J::c).orElse(false).booleanValue()) {
                        client.m(result.getModel());
                    }
                    client.e();
                    this.k.e(omadacId.a(), siteId.a());
                }
                Optional<d> clientImageOpt = this.a.a(omadacId, siteId, mac);
                clientImageOpt.ifPresent(clientImage -> {
                    clientImage.a((i)client);
                    this.a.a((d)clientImage);
                });
                clientsSaveList.add((i)client);
            }, () -> {
                if (this.h.a(omadacId.a(), "client:offline")) {
                    Optional<d> clientImageOpt = this.a.a(omadacId, siteId, mac);
                    clientImageOpt.ifPresent(clientImage -> {
                        clientImage.a(J.a(task.e(), task.d() + 1));
                        if (result != null) {
                            clientImage.k(result.getClientType());
                            clientImage.n(result.getSystemVersion());
                            clientImage.q(result.getBrand());
                            clientImage.t(result.getModel());
                            clientImage.w(result.getGroup());
                            clientImage.ab();
                            this.k.e(omadacId.a(), siteId.a());
                        }
                        this.a.a((d)clientImage);
                    });
                    j recognitionInfo = new j();
                    recognitionInfo.a(omadacId);
                    recognitionInfo.a(siteId);
                    recognitionInfo.a(mac);
                    recognitionInfo.a(J.a(task.e(), task.d() + 1));
                    if (result != null) {
                        recognitionInfo.b(result.getClientType());
                        recognitionInfo.f(result.getSystemVersion());
                        recognitionInfo.e(result.getBrand());
                        recognitionInfo.d(result.getModel());
                        recognitionInfo.c(result.getGroup());
                    }
                    this.b.a(recognitionInfo);
                }
            });
            return null;
        }, () -> {
            l.warn("fail to update client recognition data, can not get lock, omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
            return null;
        });
    }
}

