/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.domain.service;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.c;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.AnomalyDTO;
import com.tplink.smb.omada.anomaly.api.internal.anomaly.d;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.ApsRssiDTO;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.ClientRoamRecordDTO;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.RoamInfoDTO;
import com.tplink.smb.omada.client.api.internal.dto.clientanomaly.RoamTimeDTO;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.domain.model.clientimage.g;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientHealthStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.insight.api.internal.dto.AnomalyEventSettingInternalDTO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.ClientObjectDTO;
import com.tplink.smb.omada.insight.api.web.anomaly.dto.DeviceObjectDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final int b = 10;
    private static final long c = 30000L;
    @Autowired
    private k d;
    @Autowired
    private g e;
    @Autowired
    private com.tplink.smb.omada.client.common.domain.model.shared.k f;
    @Autowired
    private com.tplink.smb.omada.client.common.domain.model.shared.a g;
    @Autowired
    private d h;

    public void a(String omadacId, String siteId, long time, Map<String, ClientRoamRecordDTO> clientRoamRecordMap, Map<String, List<ClientHealthStatPreDataDTO>> clientMap) {
        if (CollectionUtils.isNotEmptyMap(clientRoamRecordMap)) {
            Map clientImageMap = this.e.a(new r(omadacId), new z(siteId), (Collection<String>)clientRoamRecordMap.keySet()).stream().collect(Collectors.toMap(com.tplink.smb.omada.client.domain.model.clientimage.d::ad, Function.identity()));
            for (Map.Entry<String, ClientRoamRecordDTO> entry : clientRoamRecordMap.entrySet()) {
                ClientObjectDTO clientObjectDTO = this.a(entry.getKey(), (com.tplink.smb.omada.client.domain.model.clientimage.d)clientImageMap.get(entry.getKey()));
                ClientRoamRecordDTO roamRecords = entry.getValue();
                roamRecords.setClientName(clientObjectDTO.getName()).setDeviceType(clientObjectDTO.getDeviceType()).setIp(clientObjectDTO.getIp());
            }
            this.d.a(omadacId, siteId, time, clientRoamRecordMap);
        }
        this.a(omadacId, siteId, time, clientRoamRecordMap.values(), clientMap);
        if (a.isDebugEnabled()) {
            a.debug("omadac: {}, site: {}, roam records: {}", new Object[]{omadacId, siteId, x.a(clientRoamRecordMap)});
        }
    }

    private void a(String omadacId, String siteId, long time, Collection<ClientRoamRecordDTO> roamRecordCollection, Map<String, List<ClientHealthStatPreDataDTO>> clientMap) {
        c eventEnum = com.tplink.smb.omada.anomaly.api.b.c.aF;
        AnomalyEventSettingInternalDTO anomalyEventSetting = this.g.b(omadacId, siteId, eventEnum.a());
        ArrayList anomalyDTOList = new ArrayList();
        if (Boolean.TRUE.equals(anomalyEventSetting.getEnable())) {
            int pingPongThreshold = com.tplink.smb.omada.client.domain.service.a.a(anomalyEventSetting, "threshold", 4);
            for (ClientRoamRecordDTO roamRecords : roamRecordCollection) {
                List roamItems = roamRecords.getRoamItems();
                if (roamItems.size() < pingPongThreshold) {
                    return;
                }
                List<RoamInfoDTO> roamInfoList = this.a(pingPongThreshold, roamItems);
                roamInfoList.forEach(roamInfoDTO -> {
                    String clientMac = roamRecords.getClientMac();
                    HashMap<String, List> details = new HashMap<String, List>();
                    details.put("roams", roamInfoDTO.getRoamTimes());
                    this.a(clientMac, roamInfoDTO.getSourceAp(), roamInfoDTO.getTargetAp(), time, clientMap).ifPresent(apsRssiDTO -> details.put("rssiStats", (List)apsRssiDTO));
                    DeviceObjectDTO sourceAp = this.a(omadacId, siteId, roamInfoDTO.getSourceAp());
                    DeviceObjectDTO targetAp = this.a(omadacId, siteId, roamInfoDTO.getTargetAp());
                    AnomalyDTO anomalyDTO = AnomalyDTO.builder().omadacId(omadacId).siteId(siteId).mac(clientMac).createTime(time).anomalyCode(eventEnum.a()).level(anomalyEventSetting.getLevel().intValue()).titleParams(CollectionUtils.toStringMap((String[])new String[]{"clientMac", roamRecords.getClientMac()})).contentParams(CollectionUtils.toStringMap((String[])new String[]{"count", String.valueOf(pingPongThreshold), "devMac", roamInfoDTO.getSourceAp(), "devMac1", roamInfoDTO.getTargetAp(), "frequencyBand", String.valueOf(roamInfoDTO.getSourceRadioId()), "support5g2I", String.valueOf(Boolean.TRUE.equals(sourceAp.getSupport5g2())), "support5g2Freq1", String.valueOf(Boolean.TRUE.equals(sourceAp.getSupport5g2())), "frequencyBand1", String.valueOf(roamInfoDTO.getTargetRadioId()), "support5g2II", String.valueOf(Boolean.TRUE.equals(targetAp.getSupport5g2())), "support5g2Freq2", String.valueOf(Boolean.TRUE.equals(targetAp.getSupport5g2()))})).detail(details).clients(Collections.singletonMap(clientMac, ClientObjectDTO.builder().name(roamRecords.getClientName()).deviceType(roamRecords.getDeviceType()).ip(roamRecords.getIp()).build())).devices(CollectionUtils.toMap((Object[])new Object[]{roamInfoDTO.getSourceAp(), sourceAp, roamInfoDTO.getTargetAp(), targetAp})).build();
                    AnomalyDTO cause = this.a(anomalyDTO);
                    anomalyDTO.setCauses(Collections.singletonMap(cause.getAnomalyCode(), cause));
                    anomalyDTOList.add(anomalyDTO);
                });
            }
        }
        a.debug("add ping pang roam anomaly to omada-insight: {}", anomalyDTOList);
        this.h.a(omadacId, siteId, Long.valueOf(time), anomalyDTOList);
    }

    private List<RoamInfoDTO> a(int pingPongThreshold, List<ClientRoamRecordDTO.RoamItem> roamItems) {
        Map<String, List<ClientRoamRecordDTO.RoamItem>> roamItemMap = roamItems.stream().collect(Collectors.groupingBy(ClientRoamRecordDTO.RoamItem::getSourceAp));
        int halfThreshold = pingPongThreshold / 2;
        ArrayList<RoamInfoDTO> roamInfoList = new ArrayList<RoamInfoDTO>();
        HashMap<String, String> detectedApMap = new HashMap<String, String>();
        for (Map.Entry<String, List<ClientRoamRecordDTO.RoamItem>> entry : roamItemMap.entrySet()) {
            if (entry.getValue().size() < halfThreshold) continue;
            Map<String, List<ClientRoamRecordDTO.RoamItem>> targetApMap = entry.getValue().stream().collect(Collectors.groupingBy(ClientRoamRecordDTO.RoamItem::getTargetAp));
            String sourceAp = entry.getKey();
            Optional<RoamInfoDTO> optional = this.a(sourceAp, pingPongThreshold, targetApMap);
            optional.ifPresent(roamInfoList::add);
            roamInfoList.addAll(this.a(sourceAp, halfThreshold, detectedApMap, targetApMap, roamItemMap));
        }
        return roamInfoList;
    }

    private Optional<RoamInfoDTO> a(String sourceAp, int pingPongThreshold, Map<String, List<ClientRoamRecordDTO.RoamItem>> targetApMap) {
        List<ClientRoamRecordDTO.RoamItem> sameTargetApList = targetApMap.get(sourceAp);
        if (CollectionUtils.isNotEmpty(sameTargetApList) && sameTargetApList.size() >= pingPongThreshold) {
            ArrayList<RoamTimeDTO> roamTimes = new ArrayList<RoamTimeDTO>();
            sameTargetApList.forEach(roamItem -> roamTimes.add(RoamTimeDTO.builder().time(roamItem.getRoamTime()).duration(roamItem.getDuration()).build()));
            roamTimes.sort(Comparator.comparing(RoamTimeDTO::getTime));
            ClientRoamRecordDTO.RoamItem roamItem2 = sameTargetApList.get(0);
            return Optional.of(new RoamInfoDTO(roamItem2.getSourceAp(), roamItem2.getSourceRadioId(), roamItem2.getTargetAp(), roamItem2.getTargetRadioId(), roamTimes));
        }
        return Optional.empty();
    }

    private List<RoamInfoDTO> a(String sourceAp, int halfThreshold, Map<String, String> detectedApMap, Map<String, List<ClientRoamRecordDTO.RoamItem>> targetApMap, Map<String, List<ClientRoamRecordDTO.RoamItem>> roamItemMap) {
        ArrayList<RoamInfoDTO> roamInfoList = new ArrayList<RoamInfoDTO>();
        for (Map.Entry<String, List<ClientRoamRecordDTO.RoamItem>> entry : targetApMap.entrySet()) {
            Map<String, List<ClientRoamRecordDTO.RoamItem>> map;
            List<ClientRoamRecordDTO.RoamItem> list;
            String targetAp = entry.getKey();
            if (Objects.equals(detectedApMap.get(sourceAp), targetAp) || Objects.equals(detectedApMap.get(targetAp), sourceAp) || Objects.equals(sourceAp, targetAp) || entry.getValue().size() < halfThreshold || !roamItemMap.containsKey(targetAp) || !CollectionUtils.isNotEmpty(list = (map = roamItemMap.get(targetAp).stream().collect(Collectors.groupingBy(ClientRoamRecordDTO.RoamItem::getTargetAp))).get(sourceAp)) || list.size() < halfThreshold) continue;
            ArrayList<RoamTimeDTO> roamTimes = new ArrayList<RoamTimeDTO>();
            entry.getValue().forEach(roamItem -> roamTimes.add(RoamTimeDTO.builder().time(roamItem.getRoamTime()).duration(roamItem.getDuration()).build()));
            list.forEach(roamItem -> roamTimes.add(RoamTimeDTO.builder().time(roamItem.getRoamTime()).duration(roamItem.getDuration()).build()));
            roamTimes.sort(Comparator.comparing(RoamTimeDTO::getTime));
            ClientRoamRecordDTO.RoamItem roamItem2 = entry.getValue().get(0);
            roamInfoList.add(new RoamInfoDTO(roamItem2.getSourceAp(), roamItem2.getSourceRadioId(), roamItem2.getTargetAp(), roamItem2.getTargetRadioId(), roamTimes));
            detectedApMap.put(sourceAp, targetAp);
        }
        return roamInfoList;
    }

    private Optional<ApsRssiDTO> a(String clientMac, String sourceAp, String targetAp, long detectTime, Map<String, List<ClientHealthStatPreDataDTO>> clientMap) {
        List clientStatData = ((List)clientMap.getOrDefault(clientMac, new ArrayList())).stream().filter(dto -> !Boolean.TRUE.equals(dto.getLastPeriod())).collect(Collectors.toList());
        ApsRssiDTO apsRssiDTO = new ApsRssiDTO();
        if (CollectionUtils.isNotEmpty(clientStatData)) {
            Map<String, List<ClientHealthStatPreDataDTO>> clientStatByAp = clientStatData.stream().collect(Collectors.groupingBy(ClientHealthStatPreDataDTO::getDevMac));
            List<ClientHealthStatPreDataDTO> sourceApStat = clientStatByAp.get(sourceAp);
            List<ClientHealthStatPreDataDTO> targetApStat = clientStatByAp.get(targetAp);
            ArrayList<String> devMacs = new ArrayList<String>();
            TreeMap<Long, ApsRssiDTO.ApsRssi> allRssiMap = new TreeMap<Long, ApsRssiDTO.ApsRssi>();
            IntStream.range(0, 10).mapToLong(i2 -> detectTime - (long)(10 - i2) * 30000L).forEach(time -> allRssiMap.put(time, new ApsRssiDTO.ApsRssi(time)));
            if (CollectionUtils.isNotEmpty(sourceApStat)) {
                devMacs.add(sourceAp);
                this.a(detectTime, sourceAp, allRssiMap, sourceApStat);
            }
            if (!Objects.equals(sourceAp, targetAp) && CollectionUtils.isNotEmpty(targetApStat)) {
                devMacs.add(targetAp);
                this.a(detectTime, targetAp, allRssiMap, targetApStat);
            }
            apsRssiDTO.setDevMacs(devMacs);
            apsRssiDTO.setAllRssi(new ArrayList(allRssiMap.values()));
        }
        if (CollectionUtils.isEmpty((Collection)apsRssiDTO.getAllRssi())) {
            return Optional.empty();
        }
        return Optional.of(apsRssiDTO);
    }

    private void a(long detectTime, String apMac, Map<Long, ApsRssiDTO.ApsRssi> allRssiMap, List<ClientHealthStatPreDataDTO> clientStat) {
        clientStat.forEach(dataDTO -> {
            long standardTime = com.tplink.smb.omada.client.port.c.a.g.a(dataDTO.getTimestamp(), 30000L, detectTime);
            ApsRssiDTO.ApsRssi apsRssi = allRssiMap.computeIfAbsent(standardTime, key -> new ApsRssiDTO.ApsRssi(standardTime));
            List<ApsRssiDTO.SingleRssi> multiRssi = CollectionUtils.isEmpty((Collection)apsRssi.getMultiRssi()) ? new ArrayList() : apsRssi.getMultiRssi();
            multiRssi.add(new ApsRssiDTO.SingleRssi(apMac, dataDTO.getRssi()));
            apsRssi.setMultiRssi(multiRssi);
        });
    }

    private ClientObjectDTO a(String clientMac, com.tplink.smb.omada.client.domain.model.clientimage.d clientImage) {
        ClientObjectDTO clientObjectDTO = Objects.nonNull(clientImage) ? ClientObjectDTO.builder().name(clientImage.ah()).deviceType(Optional.ofNullable(clientImage.ao()).orElse(com.tplink.smb.omada.client.port.c.a.c.b(clientImage.aj()))).ip(clientImage.ak()).build() : new ClientObjectDTO(clientMac, "unknown", Boolean.valueOf(false), null);
        return clientObjectDTO;
    }

    private DeviceObjectDTO a(String omadacId, String siteId, String mac) {
        return this.f.a(omadacId, siteId, mac);
    }

    private AnomalyDTO a(AnomalyDTO anomalyDTO) {
        return AnomalyDTO.builder().mac(anomalyDTO.getMac()).createTime(anomalyDTO.getCreateTime()).anomalyCode(com.tplink.smb.omada.anomaly.api.b.c.aG.a()).build();
    }

    private static int a(AnomalyEventSettingInternalDTO anomalySetting, String thresholdKey, int defaultValue) {
        if (Objects.nonNull(anomalySetting) && !CollectionUtils.isEmptyMap((Map)anomalySetting.getParams()) && anomalySetting.getParams().containsKey(thresholdKey)) {
            return (Integer)anomalySetting.getParams().get(thresholdKey);
        }
        return defaultValue;
    }

    public static class a {
        private String a;

        @Generated
        public String a() {
            return this.a;
        }

        @Generated
        public void a(String devMac) {
            this.a = devMac;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            String this$devMac = this.a();
            String other$devMac = other.a();
            return !(this$devMac == null ? other$devMac != null : !this$devMac.equals(other$devMac));
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $devMac = this.a();
            result = result * 59 + ($devMac == null ? 43 : $devMac.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnomalyRoamingService.DeviceMac(devMac=" + this.a() + ")";
        }

        @Generated
        public a(String devMac) {
            this.a = devMac;
        }
    }
}

