/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.api.a.b;
import com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.ClientHealthStat;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientConnRecordStatPreDataDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientConnectStepRecordDTO;
import com.tplink.smb.omada.client.port.cache.clienthealthstat.ClientHealthStatPreDataDTO;
import com.tplink.smb.omada.common.constant.N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);

    public static ClientHealthStatPreDataDTO a(List<ClientHealthStatPreDataDTO> clientHealthStatPreDataList) {
        if (CollectionUtils.isEmpty(clientHealthStatPreDataList)) {
            return null;
        }
        clientHealthStatPreDataList.sort(Comparator.comparing(ClientHealthStatPreDataDTO::getTimestamp));
        ClientHealthStatPreDataDTO latestData = clientHealthStatPreDataList.get(clientHealthStatPreDataList.size() - 1);
        boolean valid = !Boolean.TRUE.equals(latestData.getLastPeriod()) && Boolean.TRUE.equals(latestData.getWireless());
        return valid ? latestData : null;
    }

    public static ClientHealthStat a(String omadacId, String siteId, String clientMac, long statSec, List<ClientHealthStatPreDataDTO> cacheData) {
        if (CollectionUtils.isEmpty(cacheData)) {
            return null;
        }
        ArrayList<ClientHealthStatPreDataDTO> clientHealthStatPreDataList = new ArrayList<ClientHealthStatPreDataDTO>();
        ClientHealthStatPreDataDTO lastPeriodData = null;
        for (ClientHealthStatPreDataDTO preDataDTO : cacheData) {
            if (!Boolean.TRUE.equals(preDataDTO.getLastPeriod())) {
                clientHealthStatPreDataList.add(preDataDTO);
                continue;
            }
            lastPeriodData = preDataDTO;
        }
        if (CollectionUtils.isEmpty(clientHealthStatPreDataList)) {
            return null;
        }
        ClientHealthStat healthStat = new ClientHealthStat(omadacId, siteId, clientMac, statSec);
        clientHealthStatPreDataList.sort(Comparator.comparing(ClientHealthStatPreDataDTO::getTimestamp));
        ClientHealthStatPreDataDTO latestPreData = com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.c(clientHealthStatPreDataList);
        boolean wireless = Boolean.TRUE.equals(latestPreData.getWireless());
        healthStat.setDeviceMac(latestPreData.getDevMac());
        healthStat.setDeviceName(latestPreData.getDevName());
        healthStat.setWireless(wireless);
        if (wireless) {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(healthStat, latestPreData, clientHealthStatPreDataList, lastPeriodData);
        } else {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(healthStat, latestPreData, clientHealthStatPreDataList);
        }
        return healthStat;
    }

    private static ClientHealthStatPreDataDTO c(List<ClientHealthStatPreDataDTO> clientHealthStatPreDataList) {
        ClientHealthStatPreDataDTO latestInfo = clientHealthStatPreDataList.get(clientHealthStatPreDataList.size() - 1);
        for (ClientHealthStatPreDataDTO preDataDTO : clientHealthStatPreDataList) {
            if (Objects.nonNull(preDataDTO.getVid())) {
                latestInfo.setVid(preDataDTO.getVid());
            }
            if (Objects.nonNull(preDataDTO.getDuplex())) {
                latestInfo.setDuplex(preDataDTO.getDuplex());
            }
            if (Objects.nonNull(preDataDTO.getPort())) {
                latestInfo.setPort(preDataDTO.getPort());
            }
            if (!Objects.nonNull(preDataDTO.getLinkSpeed())) continue;
            latestInfo.setLinkSpeed(preDataDTO.getLinkSpeed());
        }
        return latestInfo;
    }

    private static void a(ClientHealthStat healthStat, ClientHealthStatPreDataDTO latestPreData, List<ClientHealthStatPreDataDTO> clientHealthStatPreDataList, ClientHealthStatPreDataDTO lastPeriodData) {
        healthStat.setSsid(latestPreData.getSsid());
        healthStat.setChannel(latestPreData.getChannel());
        healthStat.setRadio(latestPreData.getRadio());
        healthStat.setWifiMode(latestPreData.getWifiMode());
        healthStat.setTxRate(latestPreData.getTxRate());
        healthStat.setRxRate(latestPreData.getRxRate());
        ArrayList<Integer> rssiList = new ArrayList<Integer>();
        ArrayList<Integer> snrList = new ArrayList<Integer>();
        ArrayList<Integer> latencyList = new ArrayList<Integer>();
        ArrayList<Long> downTrafficList = new ArrayList<Long>();
        ArrayList<Long> upTrafficList = new ArrayList<Long>();
        if (Objects.nonNull(lastPeriodData) && Boolean.TRUE.equals(lastPeriodData.getWireless())) {
            downTrafficList.add(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(lastPeriodData.getDownTraffic()));
            upTrafficList.add(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(lastPeriodData.getUpTraffic()));
        }
        for (ClientHealthStatPreDataDTO preData : clientHealthStatPreDataList) {
            downTrafficList.add(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(preData.getDownTraffic()));
            upTrafficList.add(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(preData.getUpTraffic()));
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(rssiList, preData.getRssi());
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(snrList, preData.getSnr());
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(latencyList, preData.getLatency());
        }
        long downTraffic = com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.e(downTrafficList);
        long upTraffic = com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.e(upTrafficList);
        healthStat.setDownTraffic(downTraffic);
        healthStat.setUpTraffic(upTraffic);
        healthStat.setDownRate(Math.round((double)downTraffic / 300.0));
        healthStat.setUpRate(Math.round((double)upTraffic / 300.0));
        healthStat.setLatency(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.d(latencyList));
        healthStat.setRssi(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.d(rssiList));
        healthStat.setSnr(com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.d(snrList));
    }

    private static void a(ClientHealthStat healthStat, ClientHealthStatPreDataDTO latestPreData, List<ClientHealthStatPreDataDTO> clientHealthStatPreDataList) {
        healthStat.setPort(latestPreData.getPort());
        healthStat.setLinkSpeed(latestPreData.getLinkSpeed());
        healthStat.setDuplex(latestPreData.getDuplex());
        healthStat.setVid(latestPreData.getVid());
        List errorPacketNumList = clientHealthStatPreDataList.stream().filter(preData -> Objects.nonNull(preData.getErrorPacketNum()) && preData.getErrorPacketNum() > 0L).map(ClientHealthStatPreDataDTO::getErrorPacketNum).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(errorPacketNumList) || errorPacketNumList.size() <= 1) {
            return;
        }
        long errorPacketNum = 0L;
        int size = errorPacketNumList.size();
        for (int i2 = 1; i2 < size; ++i2) {
            long preErrPkt;
            long curErrPkt = (Long)errorPacketNumList.get(i2);
            if (curErrPkt >= (preErrPkt = ((Long)errorPacketNumList.get(i2 - 1)).longValue())) {
                errorPacketNum += curErrPkt - preErrPkt;
                continue;
            }
            errorPacketNum += curErrPkt;
        }
        healthStat.setErrorPacketNum(errorPacketNum);
    }

    private static Long a(Long value) {
        return Objects.nonNull(value) ? value : 0L;
    }

    private static void a(List<Integer> valueList, Integer value) {
        if (Objects.nonNull(value)) {
            valueList.add(value);
        }
    }

    public static void a(ClientHealthStat target, List<ClientHealthStat> sourceList, Boolean wireless) {
        target.setWireless(wireless);
        if (Boolean.TRUE.equals(wireless)) {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(target, sourceList, N.c);
        } else {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(target, sourceList);
        }
    }

    public static void b(ClientHealthStat target, List<ClientHealthStat> sourceList, Boolean wireless) {
        target.setWireless(wireless);
        if (Boolean.TRUE.equals(wireless)) {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(target, sourceList, N.d);
        } else {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(target, sourceList);
        }
    }

    public static List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> a(String omadacId, String siteId, List<ClientConnRecordStatPreDataDTO> clientConnectRecordList) {
        if (CollectionUtils.isEmpty(clientConnectRecordList)) {
            return Collections.emptyList();
        }
        ArrayList<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList = new ArrayList<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a>();
        int connectDelayTime = 64;
        for (ClientConnRecordStatPreDataDTO connectRecord : clientConnectRecordList) {
            com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(omadacId, siteId, targetList, connectDelayTime, connectRecord);
        }
        for (com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a stat : targetList) {
            stat.d();
        }
        return targetList;
    }

    public static List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> b(List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> sourceList) {
        if (Objects.isNull(sourceList) || CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList = new ArrayList<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a>();
        for (com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a source : sourceList) {
            boolean used = false;
            for (com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a target : targetList) {
                if (!target.a(source)) continue;
                target.b(source);
                used = true;
                break;
            }
            if (used) continue;
            com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a newTarget = new com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a(source.f(), source.g(), source.h(), source.i(), source.j(), source.k(), source.l());
            newTarget.b(source);
            targetList.add(newTarget);
        }
        return targetList;
    }

    public static void a(com.tplink.smb.omada.client.domain.model.statistic.b.a.a aggregationStat, ClientHealthStat stat) {
        if (!Boolean.TRUE.equals(stat.getWireless())) {
            return;
        }
        b.a((Integer[])aggregationStat.c(), (int[])b.b.a, (Integer)stat.getRssi());
        b.a((Integer[])aggregationStat.d(), (int[])b.b.b, (Integer)stat.getSnr());
        b.a((Integer[])aggregationStat.f(), (Integer[])aggregationStat.g(), (Integer)stat.getWifiMode(), (Long)stat.getTxRate());
        List<com.tplink.smb.omada.client.domain.model.statistic.b.a.b> ssidItemStats = aggregationStat.h();
        boolean handle = false;
        if (Objects.nonNull(stat.getSsid())) {
            for (com.tplink.smb.omada.client.domain.model.statistic.b.a.b ssidItemStat : ssidItemStats) {
                if (!Objects.equals(stat.getSsid(), ssidItemStat.a())) continue;
                ssidItemStat.a(ssidItemStat.b() + 1);
                handle = true;
                break;
            }
            if (!handle) {
                ssidItemStats.add(new com.tplink.smb.omada.client.domain.model.statistic.b.a.b(stat.getSsid(), 1));
            }
        }
        if (Objects.nonNull(stat.getRadio())) {
            switch (stat.getRadio()) {
                case 0: {
                    aggregationStat.a(aggregationStat.i() + 1);
                    break;
                }
                case 1: 
                case 2: {
                    aggregationStat.b(aggregationStat.j() + 1);
                    break;
                }
                case 3: {
                    aggregationStat.c(aggregationStat.k() + 1);
                    break;
                }
            }
        }
    }

    public static void a(com.tplink.smb.omada.client.domain.model.statistic.b.a.a aggregationStat, List<com.tplink.smb.omada.client.domain.model.statistic.h.a.a> statList) {
        for (com.tplink.smb.omada.client.domain.model.statistic.h.a.a stat : statList) {
            b.a((Integer[])aggregationStat.e(), (long[])b.b.c, (Long)stat.e());
        }
    }

    public static void b(com.tplink.smb.omada.client.domain.model.statistic.b.a.a aggregationStat, List<com.tplink.smb.omada.client.domain.model.statistic.b.a.a> sourceList) {
        for (com.tplink.smb.omada.client.domain.model.statistic.b.a.a stat : sourceList) {
            Integer[] roamDistribution = stat.e();
            Integer[] destArray = aggregationStat.e();
            int length = roamDistribution.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Integer[] integerArray = destArray;
                int n2 = i2;
                Integer.valueOf(integerArray[n2] + roamDistribution[i2]);
            }
        }
    }

    public static <T> T a(T val, T defaultVal) {
        return Objects.nonNull(val) ? val : defaultVal;
    }

    private static void a(String omadacId, String siteId, List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList, int connectDelayTime, ClientConnRecordStatPreDataDTO connectRecord) {
        List stepRecordList = Optional.ofNullable(connectRecord.getStepRecordList()).orElse(Collections.emptyList());
        String apMac = connectRecord.getApMac();
        String apName = connectRecord.getApName();
        String clientMac = connectRecord.getClientMac();
        for (ClientConnectStepRecordDTO stepRecord : stepRecordList) {
            boolean duplicate = false;
            com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a operateStat = null;
            for (com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a stat1 : targetList) {
                if (!com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(apMac, stepRecord, stat1)) continue;
                operateStat = stat1;
                operateStat.d(apName);
                duplicate = true;
                break;
            }
            if (!duplicate) {
                operateStat = new com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a(omadacId, siteId, apMac, apName, clientMac, stepRecord.getSsid(), stepRecord.getRadioId());
            }
            switch (stepRecord.getStep()) {
                case 1: {
                    com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.a(operateStat, stepRecord, connectDelayTime, duplicate, targetList);
                    break;
                }
                case 2: {
                    com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.b(operateStat, stepRecord, connectDelayTime, duplicate, targetList);
                    break;
                }
                case 3: {
                    com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.c(operateStat, stepRecord, connectDelayTime, duplicate, targetList);
                    break;
                }
                case 4: {
                    com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.a.d(operateStat, stepRecord, connectDelayTime, duplicate, targetList);
                    break;
                }
            }
        }
    }

    private static void a(com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a operateStat, ClientConnectStepRecordDTO stepRecord, Integer connectDelayTime, boolean duplicate, List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList) {
        operateStat.a(Boolean.TRUE.equals(stepRecord.getSuccess()), stepRecord.getStepDelay() > (long)connectDelayTime.intValue());
        if (!duplicate) {
            targetList.add(operateStat);
        }
    }

    private static void b(com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a operateStat, ClientConnectStepRecordDTO stepRecord, Integer connectDelayTime, boolean duplicate, List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList) {
        operateStat.b(Boolean.TRUE.equals(stepRecord.getSuccess()), stepRecord.getStepDelay() > (long)connectDelayTime.intValue());
        if (!Boolean.TRUE.equals(stepRecord.getSuccess())) {
            Map<String, Integer> serverFailMap = operateStat.I();
            Map<String, Integer> typeFailMap = operateStat.G();
            String serverIp = b.e.a((String)stepRecord.getServerIp());
            String type = stepRecord.getType();
            if (Objects.nonNull(serverIp)) {
                serverFailMap.computeIfAbsent(serverIp, s2 -> 0);
                serverFailMap.put(serverIp, serverFailMap.get(serverIp) + 1);
            }
            if (Objects.nonNull(type)) {
                typeFailMap.computeIfAbsent(type, s2 -> 0);
                typeFailMap.put(type, typeFailMap.get(type) + 1);
            }
        } else if (stepRecord.getStepDelay() > (long)connectDelayTime.intValue()) {
            Map<String, Integer> serverDelayMap = operateStat.J();
            Map<String, Integer> typeDelayMap = operateStat.H();
            String serverIp = b.e.a((String)stepRecord.getServerIp());
            String type = stepRecord.getType();
            if (Objects.nonNull(serverIp)) {
                serverDelayMap.computeIfAbsent(serverIp, s2 -> 0);
                serverDelayMap.put(serverIp, serverDelayMap.get(serverIp) + 1);
            }
            if (Objects.nonNull(type)) {
                typeDelayMap.computeIfAbsent(type, s2 -> 0);
                typeDelayMap.put(type, typeDelayMap.get(type) + 1);
            }
        }
        if (!duplicate) {
            targetList.add(operateStat);
        }
    }

    private static void c(com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a operateStat, ClientConnectStepRecordDTO stepRecord, Integer connectDelayTime, boolean duplicate, List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList) {
        operateStat.c(Boolean.TRUE.equals(stepRecord.getSuccess()), stepRecord.getStepDelay() > (long)connectDelayTime.intValue());
        if (!Boolean.TRUE.equals(stepRecord.getSuccess())) {
            Map<String, Integer> reasonFailMap = operateStat.K();
            String reason = b.e.a((Integer)3, (Integer)stepRecord.getErrorCode());
            if (Objects.nonNull(reason)) {
                reasonFailMap.computeIfAbsent(reason, s2 -> 0);
                reasonFailMap.put(reason, reasonFailMap.get(reason) + 1);
            }
        }
        if (!duplicate) {
            targetList.add(operateStat);
        }
    }

    private static void d(com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a operateStat, ClientConnectStepRecordDTO stepRecord, Integer connectDelayTime, boolean duplicate, List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> targetList) {
        operateStat.d(Boolean.TRUE.equals(stepRecord.getSuccess()), stepRecord.getStepDelay() > (long)connectDelayTime.intValue());
        if (!Boolean.TRUE.equals(stepRecord.getSuccess())) {
            Map<String, Integer> serverFailMap = operateStat.O();
            Map<String, Integer> reasonFailMap = operateStat.M();
            String serverIp = b.e.a((String)stepRecord.getServerIp());
            String reason = b.e.a((Integer)4, (Integer)stepRecord.getErrorCode());
            if (Objects.nonNull(serverIp)) {
                serverFailMap.computeIfAbsent(serverIp, s2 -> 0);
                serverFailMap.put(serverIp, serverFailMap.get(serverIp) + 1);
            }
            if (Objects.nonNull(reason)) {
                reasonFailMap.computeIfAbsent(reason, s2 -> 0);
                reasonFailMap.put(reason, reasonFailMap.get(reason) + 1);
            }
        } else if (stepRecord.getStepDelay() > (long)connectDelayTime.intValue()) {
            Map<String, Integer> serverDelayMap = operateStat.P();
            String serverIp = b.e.a((String)stepRecord.getServerIp());
            if (Objects.nonNull(serverIp)) {
                serverDelayMap.computeIfAbsent(serverIp, s2 -> 0);
                serverDelayMap.put(serverIp, serverDelayMap.get(serverIp) + 1);
            }
        }
        if (!duplicate) {
            targetList.add(operateStat);
        }
    }

    private static boolean a(String apMac, ClientConnectStepRecordDTO stepRecord, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a stat) {
        return Objects.equals(apMac, stat.h()) && Objects.equals(stepRecord.getSsid(), stat.k()) && Objects.equals(stepRecord.getRadioId(), stat.l());
    }

    private static void a(ClientHealthStat target, List<ClientHealthStat> sourceList, N timeGranularityEnum) {
        if (Objects.isNull(target) || Objects.isNull(sourceList) || CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        long curTime = 0L;
        String deviceMac = null;
        String deviceName = null;
        String ssid = null;
        Integer channel = null;
        Integer radio = null;
        Integer wifiMode = null;
        long txRate = 0L;
        long rxRate = 0L;
        int totalStatNum = 0;
        long totalDownTraffic = 0L;
        long totalUpTraffic = 0L;
        long totalDelay = 0L;
        int totalRssi = 0;
        int totalSnr = 0;
        for (ClientHealthStat s2 : sourceList) {
            ++totalStatNum;
            if (s2.getTime() > curTime) {
                deviceMac = s2.getDeviceMac();
                deviceName = s2.getDeviceName();
                ssid = s2.getSsid();
                channel = s2.getChannel();
                radio = s2.getRadio();
                wifiMode = s2.getWifiMode();
                txRate = s2.getTxRate();
                rxRate = s2.getRxRate();
                curTime = s2.getTime();
            }
            totalDownTraffic += s2.getDownTraffic().longValue();
            totalUpTraffic += s2.getUpTraffic().longValue();
            totalDelay += (long)s2.getLatency().intValue();
            totalRssi += s2.getRssi().intValue();
            totalSnr += s2.getSnr().intValue();
        }
        if (totalStatNum == 0) {
            return;
        }
        target.setDeviceMac(deviceMac);
        target.setDeviceName(deviceName);
        target.setSsid(ssid);
        target.setChannel(channel);
        target.setRadio(radio);
        target.setWifiMode(wifiMode);
        target.setTxRate(txRate);
        target.setRxRate(rxRate);
        target.setDownTraffic(totalDownTraffic);
        target.setUpTraffic(totalUpTraffic);
        switch (timeGranularityEnum) {
            case c: {
                target.setDownRate(Math.round((double)totalDownTraffic / 3600.0));
                target.setUpRate(Math.round((double)totalUpTraffic / 3600.0));
                break;
            }
            case d: {
                target.setDownRate(Math.round((double)totalDownTraffic / 86400.0));
                target.setUpRate(Math.round((double)totalUpTraffic / 86400.0));
                break;
            }
        }
        target.setLatency(Math.round((float)totalDelay / (float)totalStatNum));
        target.setRssi(Math.round((float)totalRssi / (float)totalStatNum));
        target.setSnr(Math.round((float)totalSnr / (float)totalStatNum));
    }

    private static void a(ClientHealthStat target, List<ClientHealthStat> sourceList) {
        if (Objects.isNull(target) || Objects.isNull(sourceList) || CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        long curTime = 0L;
        String deviceMac = null;
        String deviceName = null;
        Integer port = null;
        Integer linkSpeed = null;
        Integer duplex = null;
        Integer vid = null;
        long errorPacketNum = 0L;
        for (ClientHealthStat s2 : sourceList) {
            if (s2.getTime() > curTime) {
                deviceMac = s2.getDeviceMac();
                deviceName = s2.getDeviceName();
                port = s2.getPort();
                linkSpeed = s2.getLinkSpeed();
                duplex = s2.getDuplex();
                vid = s2.getVid();
            }
            errorPacketNum += s2.getErrorPacketNum().longValue();
        }
        target.setDeviceMac(deviceMac);
        target.setDeviceName(deviceName);
        target.setPort(port);
        target.setLinkSpeed(linkSpeed);
        target.setDuplex(duplex);
        target.setVid(vid);
        target.setErrorPacketNum(errorPacketNum);
    }

    private static int d(List<Integer> valueList) {
        if (Objects.isNull(valueList)) {
            return 0;
        }
        long sum = 0L;
        int count = 0;
        for (Integer value : valueList) {
            if (!Objects.nonNull(value)) continue;
            sum += (long)value.intValue();
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        long averageValue = Math.round((double)sum / (double)count);
        if (averageValue > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (averageValue < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)averageValue;
    }

    private static long e(List<Long> trafficList) {
        if (CollectionUtils.isEmpty(trafficList)) {
            return 0L;
        }
        long preTraffic = trafficList.get(0);
        long totalTraffic = 0L;
        for (Long curTraffic : trafficList) {
            totalTraffic = curTraffic < preTraffic ? (totalTraffic += curTraffic.longValue()) : (totalTraffic += curTraffic - preTraffic);
            preTraffic = curTraffic;
        }
        return totalTraffic;
    }

    @Generated
    private a() {
    }
}

