/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.domain.model.client;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.api.internal.dto.BonjourServiceDTO;
import com.tplink.smb.omada.client.domain.model.c.a.d;
import com.tplink.smb.omada.client.domain.model.c.a.e;
import com.tplink.smb.omada.client.domain.model.client.J;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.proto.device.monitor.ap.WirelessClientDTO;
import com.tplink.smb.omada.proto.device.monitor.osw.OswWiredClientDTO;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecognitionParamDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecognitionParamDTO.class);
    @a
    private String mac;
    private String hostname;
    private String httpUserAgent;
    private String dhcpVendor;
    private String dhcpParams;
    private String dhcpMud;
    private String netBiosDomain;
    private String netBiosName;
    private String bonjourName;
    private List<BonjourServiceDTO> bonjourServices;
    private String mdnsName;

    public static RecognitionParamDTO fromReportedClient(d reportedClient) {
        if (reportedClient instanceof com.tplink.smb.omada.client.domain.model.c.a.a) {
            WirelessClientDTO wirelessClientDTO = (WirelessClientDTO)reportedClient.y();
            if (wirelessClientDTO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("RecognitionParam fromReportedClient, wirelessClientDTO is null, reportedClient:{}", (Object)reportedClient);
                }
                return null;
            }
            return new RecognitionParamDTO().setMac(reportedClient.x()).setHostname(wirelessClientDTO.getName()).setHttpUserAgent(wirelessClientDTO.getHua()).setDhcpMud(wirelessClientDTO.getDhcpMud()).setDhcpParams(wirelessClientDTO.getDhcpParams()).setDhcpVendor(wirelessClientDTO.getDhcpVendor()).setNetBiosDomain(wirelessClientDTO.getNetBiosDomain()).setNetBiosName(wirelessClientDTO.getNetBiosName()).setBonjourName(wirelessClientDTO.getBonjourName()).setBonjourServices(Optional.of(wirelessClientDTO.getBonjourServicesList()).map(list -> list.stream().map(item -> new BonjourServiceDTO(item.getTxt(), item.getName())).toList()).orElse(Collections.emptyList()));
        }
        if (reportedClient instanceof e) {
            OswWiredClientDTO oswWiredClientDTO = (OswWiredClientDTO)reportedClient.y();
            if (oswWiredClientDTO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("RecognitionParam fromReportedClient, not wireless, reportedClient:{}", (Object)reportedClient);
                }
                return null;
            }
            return new RecognitionParamDTO().setMac(reportedClient.x()).setHostname(oswWiredClientDTO.getName()).setHttpUserAgent(oswWiredClientDTO.getHua()).setDhcpParams(oswWiredClientDTO.getDhcpParams()).setDhcpVendor(oswWiredClientDTO.getDhcpVendor()).setNetBiosName(oswWiredClientDTO.getNetBiosName()).setMdnsName(oswWiredClientDTO.getMdnsName());
        }
        return null;
    }

    public static RecognitionParamDTO fromRecognition(String mac, String hostname, J recognition) {
        if (recognition == null) {
            return null;
        }
        return new RecognitionParamDTO().setMac(mac).setHostname(hostname).setHttpUserAgent(recognition.f()).setDhcpMud(recognition.i()).setDhcpParams(recognition.h()).setDhcpVendor(recognition.g()).setNetBiosDomain(recognition.j()).setNetBiosName(recognition.k()).setBonjourName(recognition.l()).setBonjourServices(recognition.m()).setMdnsName(recognition.n());
    }

    public boolean allowFirstRecognize() {
        return T.a((Object)this.httpUserAgent) || T.a((Object)this.hostname);
    }

    public boolean hasMoreAttrThan(RecognitionParamDTO oldParam) {
        boolean newParamHasValue;
        boolean bl = newParamHasValue = T.a((Object)this.hostname) || T.a((Object)this.httpUserAgent) || T.a((Object)this.dhcpParams) || T.a((Object)this.dhcpMud) || T.a((Object)this.dhcpVendor) || T.a((Object)this.netBiosDomain) || T.a((Object)this.netBiosName) || T.a((Object)this.bonjourName) || CollectionUtils.isNotEmpty(this.bonjourServices) || T.a((Object)this.mdnsName);
        if (oldParam == null) {
            return newParamHasValue;
        }
        return T.c((String)oldParam.hostname) && T.a((Object)this.hostname) || T.c((String)oldParam.httpUserAgent) && T.a((Object)this.httpUserAgent) || T.c((String)oldParam.dhcpParams) && T.a((Object)this.dhcpParams) || T.c((String)oldParam.dhcpMud) && T.a((Object)this.dhcpMud) || T.c((String)oldParam.dhcpVendor) && T.a((Object)this.dhcpVendor) || T.c((String)oldParam.netBiosDomain) && T.a((Object)this.netBiosDomain) || T.c((String)oldParam.netBiosName) && T.a((Object)this.netBiosName) || T.c((String)oldParam.bonjourName) && T.a((Object)this.bonjourName) || CollectionUtils.isEmpty(oldParam.getBonjourServices()) && CollectionUtils.isNotEmpty(this.bonjourServices) || T.c((String)oldParam.mdnsName) && T.a((Object)this.mdnsName);
    }

    public void fillIfNull(@Nullable RecognitionParamDTO oldParam) {
        if (oldParam == null) {
            return;
        }
        if (T.c((String)this.hostname)) {
            this.hostname = oldParam.hostname;
        }
        if (T.c((String)this.httpUserAgent)) {
            this.httpUserAgent = oldParam.httpUserAgent;
        }
        if (T.c((String)this.dhcpParams)) {
            this.dhcpParams = oldParam.dhcpParams;
        }
        if (T.c((String)this.dhcpMud)) {
            this.dhcpMud = oldParam.dhcpMud;
        }
        if (T.c((String)this.dhcpVendor)) {
            this.dhcpVendor = oldParam.dhcpVendor;
        }
        if (T.c((String)this.netBiosDomain)) {
            this.netBiosDomain = oldParam.netBiosDomain;
        }
        if (T.c((String)this.netBiosName)) {
            this.netBiosName = oldParam.netBiosName;
        }
        if (T.c((String)this.bonjourName)) {
            this.bonjourName = oldParam.bonjourName;
        }
        if (CollectionUtils.isEmpty(this.bonjourServices)) {
            this.bonjourServices = oldParam.bonjourServices;
        }
        if (T.c((String)this.mdnsName)) {
            this.mdnsName = oldParam.mdnsName;
        }
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    @Generated
    public String getDhcpVendor() {
        return this.dhcpVendor;
    }

    @Generated
    public String getDhcpParams() {
        return this.dhcpParams;
    }

    @Generated
    public String getDhcpMud() {
        return this.dhcpMud;
    }

    @Generated
    public String getNetBiosDomain() {
        return this.netBiosDomain;
    }

    @Generated
    public String getNetBiosName() {
        return this.netBiosName;
    }

    @Generated
    public String getBonjourName() {
        return this.bonjourName;
    }

    @Generated
    public List<BonjourServiceDTO> getBonjourServices() {
        return this.bonjourServices;
    }

    @Generated
    public String getMdnsName() {
        return this.mdnsName;
    }

    @Generated
    public RecognitionParamDTO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public RecognitionParamDTO setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Generated
    public RecognitionParamDTO setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
        return this;
    }

    @Generated
    public RecognitionParamDTO setDhcpVendor(String dhcpVendor) {
        this.dhcpVendor = dhcpVendor;
        return this;
    }

    @Generated
    public RecognitionParamDTO setDhcpParams(String dhcpParams) {
        this.dhcpParams = dhcpParams;
        return this;
    }

    @Generated
    public RecognitionParamDTO setDhcpMud(String dhcpMud) {
        this.dhcpMud = dhcpMud;
        return this;
    }

    @Generated
    public RecognitionParamDTO setNetBiosDomain(String netBiosDomain) {
        this.netBiosDomain = netBiosDomain;
        return this;
    }

    @Generated
    public RecognitionParamDTO setNetBiosName(String netBiosName) {
        this.netBiosName = netBiosName;
        return this;
    }

    @Generated
    public RecognitionParamDTO setBonjourName(String bonjourName) {
        this.bonjourName = bonjourName;
        return this;
    }

    @Generated
    public RecognitionParamDTO setBonjourServices(List<BonjourServiceDTO> bonjourServices) {
        this.bonjourServices = bonjourServices;
        return this;
    }

    @Generated
    public RecognitionParamDTO setMdnsName(String mdnsName) {
        this.mdnsName = mdnsName;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof RecognitionParamDTO)) {
            return false;
        }
        RecognitionParamDTO other = (RecognitionParamDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$httpUserAgent = this.getHttpUserAgent();
        String other$httpUserAgent = other.getHttpUserAgent();
        if (this$httpUserAgent == null ? other$httpUserAgent != null : !this$httpUserAgent.equals(other$httpUserAgent)) {
            return false;
        }
        String this$dhcpVendor = this.getDhcpVendor();
        String other$dhcpVendor = other.getDhcpVendor();
        if (this$dhcpVendor == null ? other$dhcpVendor != null : !this$dhcpVendor.equals(other$dhcpVendor)) {
            return false;
        }
        String this$dhcpParams = this.getDhcpParams();
        String other$dhcpParams = other.getDhcpParams();
        if (this$dhcpParams == null ? other$dhcpParams != null : !this$dhcpParams.equals(other$dhcpParams)) {
            return false;
        }
        String this$dhcpMud = this.getDhcpMud();
        String other$dhcpMud = other.getDhcpMud();
        if (this$dhcpMud == null ? other$dhcpMud != null : !this$dhcpMud.equals(other$dhcpMud)) {
            return false;
        }
        String this$netBiosDomain = this.getNetBiosDomain();
        String other$netBiosDomain = other.getNetBiosDomain();
        if (this$netBiosDomain == null ? other$netBiosDomain != null : !this$netBiosDomain.equals(other$netBiosDomain)) {
            return false;
        }
        String this$netBiosName = this.getNetBiosName();
        String other$netBiosName = other.getNetBiosName();
        if (this$netBiosName == null ? other$netBiosName != null : !this$netBiosName.equals(other$netBiosName)) {
            return false;
        }
        String this$bonjourName = this.getBonjourName();
        String other$bonjourName = other.getBonjourName();
        if (this$bonjourName == null ? other$bonjourName != null : !this$bonjourName.equals(other$bonjourName)) {
            return false;
        }
        List<BonjourServiceDTO> this$bonjourServices = this.getBonjourServices();
        List<BonjourServiceDTO> other$bonjourServices = other.getBonjourServices();
        if (this$bonjourServices == null ? other$bonjourServices != null : !((Object)this$bonjourServices).equals(other$bonjourServices)) {
            return false;
        }
        String this$mdnsName = this.getMdnsName();
        String other$mdnsName = other.getMdnsName();
        return !(this$mdnsName == null ? other$mdnsName != null : !this$mdnsName.equals(other$mdnsName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecognitionParamDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $httpUserAgent = this.getHttpUserAgent();
        result = result * 59 + ($httpUserAgent == null ? 43 : $httpUserAgent.hashCode());
        String $dhcpVendor = this.getDhcpVendor();
        result = result * 59 + ($dhcpVendor == null ? 43 : $dhcpVendor.hashCode());
        String $dhcpParams = this.getDhcpParams();
        result = result * 59 + ($dhcpParams == null ? 43 : $dhcpParams.hashCode());
        String $dhcpMud = this.getDhcpMud();
        result = result * 59 + ($dhcpMud == null ? 43 : $dhcpMud.hashCode());
        String $netBiosDomain = this.getNetBiosDomain();
        result = result * 59 + ($netBiosDomain == null ? 43 : $netBiosDomain.hashCode());
        String $netBiosName = this.getNetBiosName();
        result = result * 59 + ($netBiosName == null ? 43 : $netBiosName.hashCode());
        String $bonjourName = this.getBonjourName();
        result = result * 59 + ($bonjourName == null ? 43 : $bonjourName.hashCode());
        List<BonjourServiceDTO> $bonjourServices = this.getBonjourServices();
        result = result * 59 + ($bonjourServices == null ? 43 : ((Object)$bonjourServices).hashCode());
        String $mdnsName = this.getMdnsName();
        result = result * 59 + ($mdnsName == null ? 43 : $mdnsName.hashCode());
        return result;
    }

    @Generated
    public RecognitionParamDTO() {
    }

    @Generated
    public RecognitionParamDTO(String mac, String hostname, String httpUserAgent, String dhcpVendor, String dhcpParams, String dhcpMud, String netBiosDomain, String netBiosName, String bonjourName, List<BonjourServiceDTO> bonjourServices, String mdnsName) {
        this.mac = mac;
        this.hostname = hostname;
        this.httpUserAgent = httpUserAgent;
        this.dhcpVendor = dhcpVendor;
        this.dhcpParams = dhcpParams;
        this.dhcpMud = dhcpMud;
        this.netBiosDomain = netBiosDomain;
        this.netBiosName = netBiosName;
        this.bonjourName = bonjourName;
        this.bonjourServices = bonjourServices;
        this.mdnsName = mdnsName;
    }

    @Generated
    public String toString() {
        return "RecognitionParamDTO(mac=" + this.getMac() + ", hostname=" + this.getHostname() + ", httpUserAgent=" + this.getHttpUserAgent() + ", dhcpVendor=" + this.getDhcpVendor() + ", dhcpParams=" + this.getDhcpParams() + ", dhcpMud=" + this.getDhcpMud() + ", netBiosDomain=" + this.getNetBiosDomain() + ", netBiosName=" + this.getNetBiosName() + ", bonjourName=" + this.getBonjourName() + ", bonjourServices=" + this.getBonjourServices() + ", mdnsName=" + this.getMdnsName() + ")";
    }
}

