/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.application;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import com.tplink.smb.omada.anomaly.api.internal.health.HealthScoreByMacAndTypeQueryDTO;
import com.tplink.smb.omada.client.api.a.b;
import com.tplink.smb.omada.client.api.web.vo.ClientHealthConnectStatVO;
import com.tplink.smb.omada.client.api.web.vo.WifiHealthQueryVO;
import com.tplink.smb.omada.client.api.web.vo.clienthealth.ClientHealthRealtimeDataVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.ApInfoVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.ClientInfoVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.DeviceInfoVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.GatewayInfoVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.SwitchInfoVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.TopologyNodeVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.ConnectProblemHistoryVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.ConnectProblemItemVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.ConnectProblemVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.ConnectStepStatVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.NameCountDTO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.WifiConnectProblemVO;
import com.tplink.smb.omada.client.api.web.vo.wifihealth.WifiHealthResultVO;
import com.tplink.smb.omada.client.application.e;
import com.tplink.smb.omada.client.common.domain.model.shared.r;
import com.tplink.smb.omada.client.common.domain.model.shared.z;
import com.tplink.smb.omada.client.domain.model.c.h;
import com.tplink.smb.omada.client.domain.model.client.i;
import com.tplink.smb.omada.client.domain.model.client.w;
import com.tplink.smb.omada.client.domain.model.clientimage.d;
import com.tplink.smb.omada.client.domain.model.clientimage.g;
import com.tplink.smb.omada.client.domain.model.history.f;
import com.tplink.smb.omada.client.domain.model.history.j;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.dto.ApConnectStatDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.dto.ClientConnectStatQueryDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.dto.ClientConnectStepStatDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.dto.SsidConnectStatDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.SiteWifiHealthDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByApDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByClientDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByMapPropertyDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByRadioDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemBySsidDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.WifiConnProblemByStageDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clienthealth.dto.ClientHealthStatQueryDTO;
import com.tplink.smb.omada.client.domain.model.statistic.clienthealth.model.ClientHealthStat;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.system.c;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.ClientTopologyDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.BaseTopologyDeviceDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopoClientVO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyApDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyOsgDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyOswDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.WiredUpInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.DeviceImageOutlineDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.k;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClientHealthApplicationService {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(ClientHealthApplicationService.class);
    static final String a = "ClientHealthApp_";
    @Autowired
    private com.tplink.smb.omada.client.domain.service.i c;
    @Autowired
    @Lazy
    private j d;
    @Autowired
    private com.tplink.smb.omada.client.domain.model.statistic.h.b.b e;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.topology.a f;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.anomaly.api.internal.health.b g;
    @Autowired
    private g h;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b i;
    @Autowired
    private com.tplink.smb.omada.client.port.h.a j;
    @Autowired
    private w k;
    @Autowired
    private OmadaClusterUniversalMethodResolveClient l;

    public List<ClientHealthStat> a(String omadacId, String siteId, String mac, Long start, Long end) {
        ClientHealthStatQueryDTO queryDTO = new ClientHealthStatQueryDTO(omadacId, siteId, mac, start, end);
        return this.c.a(queryDTO);
    }

    public List<ClientHealthStat> b(String omadacId, String siteId, String mac, Long start, Long end) {
        ClientHealthStatQueryDTO queryDTO = new ClientHealthStatQueryDTO(omadacId, siteId, mac, start, end);
        return this.c.b(queryDTO);
    }

    public List<ClientHealthStat> c(String omadacId, String siteId, String mac, Long start, Long end) {
        ClientHealthStatQueryDTO queryDTO = new ClientHealthStatQueryDTO(omadacId, siteId, mac, start, end);
        return this.c.c(queryDTO);
    }

    public List<f> d(String omadacId, String siteId, String clientMac, Long start, Long end) {
        return this.d.b(new r(omadacId), new z(siteId), clientMac, start * 1000L, end * 1000L);
    }

    public List<com.tplink.smb.omada.client.domain.model.history.h> e(String omadacId, String siteId, String clientMac, Long startMs, Long endMs) {
        ArrayList<com.tplink.smb.omada.client.domain.model.history.h> results = new ArrayList<com.tplink.smb.omada.client.domain.model.history.h>();
        Optional<d> clientImageOpt = this.h.a(new r(omadacId), new z(siteId), clientMac);
        clientImageOpt.ifPresent(clientImage -> results.add(new com.tplink.smb.omada.client.domain.model.history.h().a(clientImage.aN()).b(clientImage.aA())));
        List<com.tplink.smb.omada.client.domain.model.history.h> clientHistoryBriefs = this.d.c(new r(omadacId), new z(siteId), clientMac, startMs, endMs);
        if (!CollectionUtils.isEmpty(clientHistoryBriefs)) {
            results.addAll(clientHistoryBriefs);
        }
        return results;
    }

    public List<com.tplink.smb.omada.client.domain.model.statistic.h.a.a> f(String omadacId, String siteId, String clientMac, Long start, Long end) {
        ClientHealthStatQueryDTO queryDTO = new ClientHealthStatQueryDTO(omadacId, siteId, clientMac, start, end);
        return this.e.a(queryDTO);
    }

    public OperationResponse<List<TopologyNodeVO>> a(String omadacId, String siteId, String clientMac) {
        long startTime = System.currentTimeMillis();
        Optional<d> clientImageOptional = this.h.a(new r(omadacId), new z(siteId), clientMac);
        if (clientImageOptional.isEmpty()) {
            return this.b(omadacId, siteId, clientMac);
        }
        d image = clientImageOptional.get();
        String deviceMac = image.d();
        long findClientImageTime = System.currentTimeMillis();
        b.info("find client image use {} ms", (Object)(findClientImageTime - startTime));
        if (Objects.isNull(deviceMac)) {
            return OperationResponse.success(List.of(this.a(image)));
        }
        OperationResponse response = null;
        try {
            response = this.f.a(omadacId, siteId, deviceMac, clientMac);
        }
        catch (Exception e2) {
            b.warn("Fail to get omadacId {} siteId {} client {} up topology info ", new Object[]{omadacId, siteId, clientMac});
            return OperationResponse.success(List.of(this.a(image)));
        }
        long findClientUpTopoTime = System.currentTimeMillis();
        b.info("find client up topo use {} ms", (Object)(findClientUpTopoTime - findClientImageTime));
        if (Objects.isNull(response) || !response.success() || Objects.isNull(response.getResult())) {
            return OperationResponse.success(List.of(this.a(image)));
        }
        ClientTopologyDTO clientTopologyDTO = (ClientTopologyDTO)response.getResult();
        ArrayList<TopologyNodeVO> topologyNodeList = new ArrayList<TopologyNodeVO>();
        TopologyNodeVO clientNode = Objects.isNull(clientTopologyDTO.getClient()) ? this.a(image) : this.a(clientTopologyDTO.getClient(), image);
        clientNode.getClientInfo().setDevTxRate(com.tplink.smb.omada.client.port.c.a.d.b(image.aL()));
        clientNode.getClientInfo().setDevRxRate(com.tplink.smb.omada.client.port.c.a.d.b(image.aK()));
        topologyNodeList.add(clientNode);
        this.a(clientTopologyDTO, topologyNodeList);
        long setClientUpTopoTime = System.currentTimeMillis();
        b.info("set client up topo use {} ms", (Object)(setClientUpTopoTime - findClientUpTopoTime));
        this.a(omadacId, siteId, topologyNodeList);
        long setClientUpHealthTime = System.currentTimeMillis();
        b.info("set client up health use {} ms", (Object)(setClientUpHealthTime - setClientUpTopoTime));
        return OperationResponse.success(topologyNodeList);
    }

    private OperationResponse<List<TopologyNodeVO>> b(String omadacId, String siteId, String clientMac) {
        Optional<i> clientOpt = this.k.a(new r(omadacId), new z(siteId), clientMac);
        if (clientOpt.isEmpty()) {
            return OperationResponse.success(Collections.emptyList());
        }
        i client = clientOpt.get();
        ClientInfoVO clientInfoVO = new ClientInfoVO();
        clientInfoVO.setMac(client.j());
        clientInfoVO.setName(client.m());
        clientInfoVO.setClientType(client.q());
        clientInfoVO.setWireless(Boolean.valueOf(Boolean.TRUE.equals(client.I())));
        clientInfoVO.setGuest(client.H());
        clientInfoVO.setAuthStatus(Integer.valueOf(client.c() ? 5 : 4));
        clientInfoVO.setManager(Boolean.valueOf(this.a(client.j(), client.V())));
        clientInfoVO.setModel(client.w());
        ArrayList<TopologyNodeVO> nodeVOList = new ArrayList<TopologyNodeVO>();
        nodeVOList.add(new TopologyNodeVO(clientInfoVO));
        return OperationResponse.success(nodeVOList);
    }

    public ClientHealthConnectStatVO a(String omadacId, String siteId, String clientMac, Long start, Long end, N granularityEnum) {
        ClientConnectStatQueryDTO queryDTO = new ClientConnectStatQueryDTO(omadacId, siteId, clientMac, start, end);
        List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> connectStats = this.c.a(queryDTO, granularityEnum);
        if (Objects.isNull(connectStats) || CollectionUtils.isEmpty(connectStats)) {
            return new ClientHealthConnectStatVO();
        }
        HashMap<String, ApConnectStatDTO> apConnectStatMap = new HashMap<String, ApConnectStatDTO>(4);
        HashMap<String, SsidConnectStatDTO> ssidConnectStatMap = new HashMap<String, SsidConnectStatDTO>(4);
        ClientConnectStepStatDTO connectStepStatDTO = new ClientConnectStepStatDTO();
        for (com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a stat : connectStats) {
            Integer delayConnect = stat.b();
            Integer failConnect = stat.n();
            String apMac = stat.h();
            ApConnectStatDTO apConnectStatDTO = apConnectStatMap.computeIfAbsent(apMac, ApConnectStatDTO::new);
            apConnectStatDTO.update(stat.i(), failConnect, delayConnect);
            String ssid = stat.k();
            SsidConnectStatDTO ssidConnectStatDTO = ssidConnectStatMap.computeIfAbsent(ssid, SsidConnectStatDTO::new);
            ssidConnectStatDTO.update(failConnect, delayConnect);
            connectStepStatDTO.addConnect(stat.a(), stat.m(), failConnect, delayConnect, stat.c());
            connectStepStatDTO.addFailSteps(stat.p(), stat.r(), stat.t(), stat.v());
            connectStepStatDTO.addDelaySteps(stat.y(), stat.A(), stat.C(), stat.E());
        }
        ClientHealthConnectStatVO resultVO = this.a(apConnectStatMap, ssidConnectStatMap, connectStepStatDTO);
        this.a(omadacId, resultVO);
        return resultVO;
    }

    public List<com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.a> b(String omadacId, String siteId, String clientMac, Long start, Long end, N timeGranularity) {
        ClientConnectStatQueryDTO queryDTO = new ClientConnectStatQueryDTO(omadacId, siteId, clientMac, start, end);
        return this.c.a(queryDTO, timeGranularity);
    }

    public ClientHealthRealtimeDataVO a(String omadacId, String siteId, Long time) {
        long start = time / 300L * 300L;
        long roamStart = start - 300L;
        List imageList = this.h.c(new r(omadacId), new z(siteId)).stream().filter(image -> Objects.nonNull(image) && image.a() && image instanceof com.tplink.smb.omada.client.domain.model.clientimage.a).map(com.tplink.smb.omada.client.domain.model.clientimage.a.class::cast).filter(apClientImage -> CollectionUtils.isEmpty(apClientImage.F())).collect(Collectors.toList());
        List<com.tplink.smb.omada.client.domain.model.statistic.h.a.a> recordStats = this.e.a(new ClientHealthStatQueryDTO(omadacId, siteId, roamStart, start));
        int[] rssiDistribution = new int[]{0, 0, 0, 0, 0};
        int[] snrDistribution = new int[]{0, 0, 0, 0, 0};
        int[] roamDistribution = new int[]{0, 0, 0, 0, 0};
        int[] speedDistribution0 = new int[]{0, 0, 0, 0, 0, 0};
        int[] speedDistribution1 = new int[]{0, 0, 0, 0, 0, 0};
        HashMap<String, Integer> ssidCountMap = new HashMap<String, Integer>(8);
        int channel2g = 0;
        int channel5g = 0;
        int channel6g = 0;
        recordStats = Optional.ofNullable(recordStats).orElse(Collections.emptyList());
        for (com.tplink.smb.omada.client.domain.model.clientimage.a image2 : imageList) {
            if (!Boolean.TRUE.equals(image2.a())) continue;
            com.tplink.smb.omada.client.api.a.b.a((int[])rssiDistribution, (int[])b.c.a, (Integer)image2.u());
            com.tplink.smb.omada.client.api.a.b.a((int[])snrDistribution, (int[])b.c.c, (Integer)image2.s());
            com.tplink.smb.omada.client.api.a.b.a((int[])speedDistribution0, (int[])speedDistribution1, (Integer)Optional.ofNullable(image2.x()).map(h::a).orElse(null), (Long)image2.w());
            if (Objects.nonNull(image2.p())) {
                String ssid = image2.p();
                ssidCountMap.putIfAbsent(ssid, 0);
                ssidCountMap.put(ssid, (Integer)ssidCountMap.get(ssid) + 1);
            }
            if (!Objects.nonNull(image2.r())) continue;
            switch (image2.r()) {
                case 0: {
                    ++channel2g;
                    break;
                }
                case 1: 
                case 2: {
                    ++channel5g;
                    break;
                }
                case 3: {
                    ++channel6g;
                    break;
                }
            }
        }
        for (com.tplink.smb.omada.client.domain.model.statistic.h.a.a recordStat : recordStats) {
            com.tplink.smb.omada.client.api.a.b.a((int[])roamDistribution, (long[])b.c.e, (Long)recordStat.e());
        }
        ClientHealthRealtimeDataVO vo = new ClientHealthRealtimeDataVO();
        vo.setRssiDistribution(rssiDistribution);
        vo.setSnrDistribution(snrDistribution);
        vo.setRoamDistribution(roamDistribution);
        vo.setSpeedDistribution(speedDistribution0, speedDistribution1);
        vo.setSsidDistribution(ssidCountMap);
        vo.setChannelDistribution(channel2g, channel5g, channel6g);
        return vo;
    }

    public List<com.tplink.smb.omada.client.domain.model.statistic.b.a.a> a(String omadacId, String siteId, Long start, Long end, N timeGranularityEnum) {
        ClientHealthStatQueryDTO queryDTO = new ClientHealthStatQueryDTO(omadacId, siteId, start, end);
        return this.c.a(queryDTO, timeGranularityEnum);
    }

    public WifiHealthResultVO a(ClientConnectStatQueryDTO queryDTO, N timeGranularity) {
        SiteWifiHealthDTO stat = this.c.b(queryDTO, timeGranularity);
        stat = Optional.ofNullable(stat).orElse(new SiteWifiHealthDTO(queryDTO.getSiteId()));
        long start = System.currentTimeMillis();
        WifiHealthResultVO resultVO = new WifiHealthResultVO();
        ConnectStepStatVO association = new ConnectStepStatVO();
        ConnectStepStatVO authentication = new ConnectStepStatVO();
        ConnectStepStatVO dhcp = new ConnectStepStatVO();
        ConnectStepStatVO dns = new ConnectStepStatVO();
        int success = 0;
        int total = 0;
        association.accumulateStat(stat.getSuccessAssociationNum().intValue(), stat.getFailAssociationNum().intValue(), stat.getDelayAssociationNum().intValue());
        authentication.accumulateStat(stat.getSuccessAuthenticationNum().intValue(), stat.getFailAuthenticationNum().intValue(), stat.getDelayAuthenticationNum().intValue());
        dhcp.accumulateStat(stat.getSuccessDhcpNum().intValue(), stat.getFailDhcpNum().intValue(), stat.getDelayDhcpNum().intValue());
        dns.accumulateStat(stat.getSuccessDnsNum().intValue(), stat.getFailDnsNum().intValue(), stat.getDelayDnsNum().intValue());
        resultVO.setConnectSuccessRate(total += stat.getSuccessConnectNum() + stat.getFailConnectNum(), success += stat.getSuccessConnectNum().intValue());
        association.setSuccessRate();
        authentication.setSuccessRate();
        dhcp.setSuccessRate();
        dns.setSuccessRate();
        resultVO.setStepInfo(association, authentication, dhcp, dns);
        return resultVO;
    }

    public OperationResponse<WifiConnectProblemVO> a(String omadacId, String siteId, WifiHealthQueryVO healthQueryVO) {
        long timeUnit;
        N timeGranularity;
        ClientConnectStatQueryDTO connectStatQueryDTO = new ClientConnectStatQueryDTO(omadacId, siteId, healthQueryVO.getStart(), healthQueryVO.getEnd());
        Integer granularity = healthQueryVO.getGranularity();
        if (Objects.isNull(healthQueryVO.getStart()) || Objects.isNull(healthQueryVO.getEnd()) || Objects.isNull(granularity) || Objects.isNull(healthQueryVO.getScope()) || Objects.isNull(healthQueryVO.getType())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        switch (granularity) {
            case 0: {
                timeGranularity = N.a;
                timeUnit = 300L;
                break;
            }
            case 1: {
                timeGranularity = N.c;
                timeUnit = 3600L;
                break;
            }
            case 2: {
                timeGranularity = N.d;
                timeUnit = 86400L;
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        Integer scope = healthQueryVO.getScope();
        Integer type = healthQueryVO.getType();
        switch (scope) {
            case 0: {
                return this.a(connectStatQueryDTO, timeGranularity, healthQueryVO.getStart(), (long)healthQueryVO.getEnd(), timeUnit, type);
            }
            case 1: {
                return this.b(connectStatQueryDTO, timeGranularity, healthQueryVO.getStart(), (long)healthQueryVO.getEnd(), timeUnit, type);
            }
            case 2: {
                return this.c(connectStatQueryDTO, timeGranularity, healthQueryVO.getStart(), healthQueryVO.getEnd(), timeUnit, type);
            }
            case 3: {
                return this.d(connectStatQueryDTO, timeGranularity, healthQueryVO.getStart(), healthQueryVO.getEnd(), timeUnit, type);
            }
            case 4: {
                return this.e(connectStatQueryDTO, timeGranularity, healthQueryVO.getStart(), healthQueryVO.getEnd(), timeUnit, type);
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
    }

    private OperationResponse<WifiConnectProblemVO> a(ClientConnectStatQueryDTO connectStatQueryDTO, N timeGranularity, long queryStartTime, long queryEndTime, long timeUnit, Integer type) {
        TreeMap<Long, Map<String, Integer>> timeFailureRecord = new TreeMap<Long, Map<String, Integer>>();
        TreeMap<Long, Map<String, Integer>> timeDelayRecord = new TreeMap<Long, Map<String, Integer>>();
        WifiConnectProblemVO wifiConnectProblemVO = new WifiConnectProblemVO();
        long start = System.currentTimeMillis();
        WifiConnProblemParamsDTO params = new WifiConnProblemParamsDTO(queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
        String methodName = "getAllStepConnProblem";
        switch (type) {
            case 0: {
                Map<Long, WifiConnProblemByStageDTO> timeStat = this.c.c(connectStatQueryDTO, timeGranularity);
                NameCountDTO[] nameCountDTOS = new NameCountDTO[]{null, new NameCountDTO("1"), new NameCountDTO("2"), new NameCountDTO("3"), new NameCountDTO("4")};
                for (Map.Entry<Long, WifiConnProblemByStageDTO> entry : timeStat.entrySet()) {
                    Long time = entry.getKey();
                    WifiConnProblemByStageDTO stat = entry.getValue();
                    nameCountDTOS[1].addFailAndDelay(stat.getFailAssociationNum(), stat.getDelayAssociationNum());
                    nameCountDTOS[2].addFailAndDelay(stat.getFailAuthenticationNum(), stat.getDelayAuthenticationNum());
                    nameCountDTOS[3].addFailAndDelay(stat.getFailDhcpNum(), stat.getDelayDhcpNum());
                    nameCountDTOS[4].addFailAndDelay(stat.getFailDnsNum(), stat.getDelayDnsNum());
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    failMap.put("1", stat.getFailAssociationNum());
                    failMap.put("2", stat.getFailAuthenticationNum());
                    failMap.put("3", stat.getFailDhcpNum());
                    failMap.put("4", stat.getFailDnsNum());
                    delayMap.put("1", stat.getDelayAssociationNum());
                    delayMap.put("2", stat.getDelayAuthenticationNum());
                    delayMap.put("3", stat.getDelayDhcpNum());
                    delayMap.put("4", stat.getDelayDnsNum());
                }
                ConnectProblemVO failVOByStep = new ConnectProblemVO();
                ConnectProblemVO delayVOByStep = new ConnectProblemVO();
                ArrayList<NameCountDTO> nameCountListByStep = new ArrayList<NameCountDTO>(Arrays.asList(nameCountDTOS).subList(1, 5));
                nameCountListByStep.stream().sorted(Comparator.comparing(NameCountDTO::getFailCount, Comparator.reverseOrder())).forEach(nameCountDTO -> failVOByStep.getItems().add(new ConnectProblemItemVO(nameCountDTO.getName(), nameCountDTO.getFailCount(), false)));
                nameCountListByStep.stream().sorted(Comparator.comparing(NameCountDTO::getDelayCount, Comparator.reverseOrder())).forEach(nameCountDTO -> delayVOByStep.getItems().add(new ConnectProblemItemVO(nameCountDTO.getName(), nameCountDTO.getDelayCount(), false)));
                this.a(failVOByStep, timeFailureRecord, false, queryStartTime, queryEndTime, timeUnit);
                this.a(delayVOByStep, timeDelayRecord, false, queryStartTime, queryEndTime, timeUnit);
                wifiConnectProblemVO.setFailure(failVOByStep);
                wifiConnectProblemVO.setDelay(delayVOByStep);
                break;
            }
            case 1: {
                this.b(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.a, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.e);
                break;
            }
            case 2: {
                this.a(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.i, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.n);
                break;
            }
            case 3: {
                List<WifiConnProblemByRadioDTO> byBandStatList = this.c.d(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> radioCountDTOMap = new HashMap<String, NameCountDTO>();
                radioCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemByRadioDTO stat : byBandStatList) {
                    String radioName = b.e.a((Integer)stat.getRadio());
                    if (Objects.isNull(radioName)) continue;
                    radioCountDTOMap.computeIfAbsent(radioName, mac -> new NameCountDTO(radioName));
                    ((NameCountDTO)radioCountDTOMap.get(radioName)).addFailAndDelay(stat.getFailConnectNum(), stat.getDelayConnectNum());
                    ((NameCountDTO)radioCountDTOMap.get("Total")).addFailAndDelay(stat.getFailConnectNum(), stat.getDelayConnectNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, radioName, stat.getFailConnectNum());
                    this.a(delayMap, radioName, stat.getDelayConnectNum());
                }
                this.a(radioCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            case 4: {
                List<WifiConnProblemBySsidDTO> bySsidList = this.c.f(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> ssidNameCountDTOMap = new HashMap<String, NameCountDTO>();
                ssidNameCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemBySsidDTO stat : bySsidList) {
                    String ssid = stat.getSsid();
                    ssidNameCountDTOMap.computeIfAbsent(ssid, mac -> new NameCountDTO(ssid));
                    ((NameCountDTO)ssidNameCountDTOMap.get(ssid)).addFailAndDelay(stat.getFailConnectNum(), stat.getDelayConnectNum());
                    ((NameCountDTO)ssidNameCountDTOMap.get("Total")).addFailAndDelay(stat.getFailConnectNum(), stat.getDelayConnectNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, ssid, stat.getFailConnectNum());
                    this.a(delayMap, ssid, stat.getDelayConnectNum());
                }
                this.a(ssidNameCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        return OperationResponse.success((Object)wifiConnectProblemVO);
    }

    private OperationResponse<WifiConnectProblemVO> b(ClientConnectStatQueryDTO connectStatQueryDTO, N timeGranularity, long queryStartTime, long queryEndTime, long timeUnit, Integer type) {
        TreeMap<Long, Map<String, Integer>> timeFailureRecord = new TreeMap<Long, Map<String, Integer>>();
        TreeMap<Long, Map<String, Integer>> timeDelayRecord = new TreeMap<Long, Map<String, Integer>>();
        WifiConnectProblemVO wifiConnectProblemVO = new WifiConnectProblemVO();
        WifiConnProblemParamsDTO params = new WifiConnProblemParamsDTO(queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
        long start = System.currentTimeMillis();
        String methodName = "getAssocConnProblem";
        switch (type) {
            case 1: {
                this.b(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.b, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.f);
                break;
            }
            case 2: {
                this.a(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.j, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.o);
                break;
            }
            case 3: {
                List<WifiConnProblemByRadioDTO> byBandStatList = this.c.d(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> radioCountDTOMap = new HashMap<String, NameCountDTO>();
                radioCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemByRadioDTO stat : byBandStatList) {
                    String radioName = b.e.a((Integer)stat.getRadio());
                    if (Objects.isNull(radioName)) continue;
                    radioCountDTOMap.computeIfAbsent(radioName, mac -> new NameCountDTO(radioName));
                    ((NameCountDTO)radioCountDTOMap.get(radioName)).addFailAndDelay(stat.getFailAssociationNum(), stat.getDelayAssociationNum());
                    ((NameCountDTO)radioCountDTOMap.get("Total")).addFailAndDelay(stat.getFailAssociationNum(), stat.getDelayAssociationNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, radioName, stat.getFailAssociationNum());
                    this.a(delayMap, radioName, stat.getDelayAssociationNum());
                }
                this.a(radioCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            case 4: {
                List<WifiConnProblemBySsidDTO> bySsidList = this.c.f(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> ssidNameCountDTOMap = new HashMap<String, NameCountDTO>();
                ssidNameCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemBySsidDTO stat : bySsidList) {
                    String ssid = stat.getSsid();
                    ssidNameCountDTOMap.computeIfAbsent(ssid, mac -> new NameCountDTO(ssid));
                    ((NameCountDTO)ssidNameCountDTOMap.get(ssid)).addFailAndDelay(stat.getFailAssociationNum(), stat.getDelayAssociationNum());
                    ((NameCountDTO)ssidNameCountDTOMap.get("Total")).addFailAndDelay(stat.getFailAssociationNum(), stat.getDelayAssociationNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, ssid, stat.getFailAssociationNum());
                    this.a(delayMap, ssid, stat.getDelayAssociationNum());
                }
                this.a(ssidNameCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        return OperationResponse.success((Object)wifiConnectProblemVO);
    }

    private OperationResponse<WifiConnectProblemVO> c(ClientConnectStatQueryDTO connectStatQueryDTO, N timeGranularity, long queryStartTime, long queryEndTime, long timeUnit, Integer type) {
        TreeMap<Long, Map<String, Integer>> timeFailureRecord = new TreeMap<Long, Map<String, Integer>>();
        TreeMap<Long, Map<String, Integer>> timeDelayRecord = new TreeMap<Long, Map<String, Integer>>();
        WifiConnectProblemVO wifiConnectProblemVO = new WifiConnectProblemVO();
        WifiConnProblemParamsDTO params = new WifiConnProblemParamsDTO(queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
        long start = System.currentTimeMillis();
        String methodName = "getAuthConnProblem";
        switch (type) {
            case 5: {
                List<WifiConnProblemByMapPropertyDTO> byTypeStatList = this.c.j(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> typeCountDTOMap = new HashMap<String, NameCountDTO>();
                typeCountDTOMap.put("Total", new NameCountDTO("Total"));
                this.a(byTypeStatList, typeCountDTOMap, timeFailureRecord, timeDelayRecord);
                this.a(typeCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                return OperationResponse.success((Object)wifiConnectProblemVO);
            }
            case 1: {
                this.b(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.c, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.g);
                break;
            }
            case 2: {
                this.a(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.k, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.p);
                break;
            }
            case 3: {
                List<WifiConnProblemByRadioDTO> byBandStatList = this.c.d(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> radioCountDTOMap = new HashMap<String, NameCountDTO>();
                radioCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemByRadioDTO stat : byBandStatList) {
                    String radioName = b.e.a((Integer)stat.getRadio());
                    if (Objects.isNull(radioName)) continue;
                    radioCountDTOMap.computeIfAbsent(radioName, mac -> new NameCountDTO(radioName));
                    ((NameCountDTO)radioCountDTOMap.get(radioName)).addFailAndDelay(stat.getFailAuthenticationNum(), stat.getDelayAuthenticationNum());
                    ((NameCountDTO)radioCountDTOMap.get("Total")).addFailAndDelay(stat.getFailAuthenticationNum(), stat.getDelayAuthenticationNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, radioName, stat.getFailAuthenticationNum());
                    this.a(delayMap, radioName, stat.getDelayAuthenticationNum());
                }
                this.a(radioCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            case 4: {
                List<WifiConnProblemBySsidDTO> bySsidList = this.c.f(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> ssidNameCountDTOMap = new HashMap<String, NameCountDTO>();
                ssidNameCountDTOMap.put("Total", new NameCountDTO("Total"));
                for (WifiConnProblemBySsidDTO stat : bySsidList) {
                    String ssid = stat.getSsid();
                    ssidNameCountDTOMap.computeIfAbsent(ssid, mac -> new NameCountDTO(ssid));
                    ((NameCountDTO)ssidNameCountDTOMap.get(ssid)).addFailAndDelay(stat.getFailAuthenticationNum(), stat.getDelayAuthenticationNum());
                    ((NameCountDTO)ssidNameCountDTOMap.get("Total")).addFailAndDelay(stat.getFailAuthenticationNum(), stat.getDelayAuthenticationNum());
                    Long time = stat.getTime();
                    Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
                    Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
                    this.a(failMap, ssid, stat.getFailAuthenticationNum());
                    this.a(delayMap, ssid, stat.getDelayAuthenticationNum());
                }
                this.a(ssidNameCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            case 6: {
                List<WifiConnProblemByMapPropertyDTO> byServerStatList = this.c.i(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> serverCountDTOMap = new HashMap<String, NameCountDTO>();
                serverCountDTOMap.put("Total", new NameCountDTO("Total"));
                this.a(byServerStatList, serverCountDTOMap, timeFailureRecord, timeDelayRecord);
                this.a(serverCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        return OperationResponse.success((Object)wifiConnectProblemVO);
    }

    private OperationResponse<WifiConnectProblemVO> d(ClientConnectStatQueryDTO connectStatQueryDTO, N timeGranularity, long queryStartTime, long queryEndTime, long timeUnit, Integer type) {
        TreeMap<Long, Map<String, Integer>> timeFailureRecord = new TreeMap<Long, Map<String, Integer>>();
        TreeMap<Long, Map<String, Integer>> timeDelayRecord = new TreeMap<Long, Map<String, Integer>>();
        WifiConnectProblemVO wifiConnectProblemVO = new WifiConnectProblemVO();
        WifiConnProblemParamsDTO params = new WifiConnProblemParamsDTO(queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
        long start = System.currentTimeMillis();
        String methodName = "getDhcpConnProblem";
        switch (type) {
            case 1: {
                this.b(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.d, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.h);
                break;
            }
            case 2: {
                this.a(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.l, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.q);
                break;
            }
            case 7: {
                List<WifiConnProblemByMapPropertyDTO> byReasonStatList = this.c.k(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> reasonCountDTOMap = new HashMap<String, NameCountDTO>();
                reasonCountDTOMap.put("Total", new NameCountDTO("Total"));
                this.a(byReasonStatList, reasonCountDTOMap, timeFailureRecord, timeDelayRecord);
                this.a(reasonCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        return OperationResponse.success((Object)wifiConnectProblemVO);
    }

    private OperationResponse<WifiConnectProblemVO> e(ClientConnectStatQueryDTO connectStatQueryDTO, N timeGranularity, long queryStartTime, long queryEndTime, long timeUnit, Integer type) {
        TreeMap<Long, Map<String, Integer>> timeFailureRecord = new TreeMap<Long, Map<String, Integer>>();
        TreeMap<Long, Map<String, Integer>> timeDelayRecord = new TreeMap<Long, Map<String, Integer>>();
        WifiConnectProblemVO wifiConnectProblemVO = new WifiConnectProblemVO();
        WifiConnProblemParamsDTO params = new WifiConnProblemParamsDTO(queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
        long start = System.currentTimeMillis();
        String methodName = "getDnsConnProblem";
        switch (type) {
            case 2: {
                this.a(connectStatQueryDTO, timeGranularity, timeFailureRecord, timeDelayRecord, params, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.m, com.tplink.smb.omada.client.domain.model.statistic.clientconnect.model.b.r);
                break;
            }
            case 7: {
                List<WifiConnProblemByMapPropertyDTO> byReasonStatList = this.c.l(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> reasonCountDTOMap = new HashMap<String, NameCountDTO>();
                reasonCountDTOMap.put("Total", new NameCountDTO("Total"));
                this.a(byReasonStatList, reasonCountDTOMap, timeFailureRecord, timeDelayRecord);
                this.a(reasonCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            case 6: {
                List<WifiConnProblemByMapPropertyDTO> byServerStatList = this.c.m(connectStatQueryDTO, timeGranularity);
                HashMap<String, NameCountDTO> typeCountDTOMap = new HashMap<String, NameCountDTO>();
                typeCountDTOMap.put("Total", new NameCountDTO("Total"));
                this.a(byServerStatList, typeCountDTOMap, timeFailureRecord, timeDelayRecord);
                this.a(typeCountDTOMap, timeFailureRecord, timeDelayRecord, queryStartTime, queryEndTime, timeUnit, wifiConnectProblemVO);
                break;
            }
            default: {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
        }
        return OperationResponse.success((Object)wifiConnectProblemVO);
    }

    private void a(ClientConnectStatQueryDTO queryDTO, N granularity, TreeMap<Long, Map<String, Integer>> timeFailureRecord, TreeMap<Long, Map<String, Integer>> timeDelayRecord, WifiConnProblemParamsDTO params, ToIntFunction<WifiConnProblemByApDTO> failCountGetter, ToIntFunction<WifiConnProblemByApDTO> delayCountGetter) {
        Map<String, WifiConnProblemByApDTO> byClientMap = this.c.g(queryDTO, granularity);
        HashMap<String, Long> clientLastStat = new HashMap<String, Long>();
        HashMap<String, NameCountDTO> nameCountDTOMap = new HashMap<String, NameCountDTO>();
        nameCountDTOMap.put("Total", new NameCountDTO("Total"));
        for (Map.Entry<String, WifiConnProblemByApDTO> entry : byClientMap.entrySet()) {
            WifiConnProblemByApDTO stat = entry.getValue();
            String apMac = stat.getApMac();
            nameCountDTOMap.computeIfAbsent(apMac, mac -> new NameCountDTO(apMac));
            Integer failCount = failCountGetter.applyAsInt(stat);
            Integer delayCount = delayCountGetter.applyAsInt(stat);
            ((NameCountDTO)nameCountDTOMap.get(apMac)).addFailAndDelay(failCount, delayCount);
            ((NameCountDTO)nameCountDTOMap.get("Total")).addFailAndDelay(failCount, delayCount);
            Long time = stat.getTime();
            clientLastStat.put(apMac, time);
        }
        ConnectProblemVO failVOByAny = new ConnectProblemVO();
        ConnectProblemVO delayVOByAny = new ConnectProblemVO();
        NameCountDTO totalObject = (NameCountDTO)nameCountDTOMap.remove("Total");
        Set<String> topFailMacs = this.a(nameCountDTOMap, failVOByAny, totalObject);
        Set<String> toDelayMacs = this.b(nameCountDTOMap, delayVOByAny, totalObject);
        Sets.SetView needFindMacs = Sets.union(topFailMacs, toDelayMacs);
        List<WifiConnProblemByApDTO> historyStat = this.c.a(queryDTO, granularity, (Set<String>)needFindMacs);
        for (WifiConnProblemByApDTO stat : historyStat) {
            Long time = stat.getTime();
            String apMac = stat.getApMac();
            Long lastStatTime = (Long)clientLastStat.get(apMac);
            if (Objects.isNull(time) || Objects.isNull(lastStatTime) || time > lastStatTime) continue;
            Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
            Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
            this.a(failMap, apMac, failCountGetter.applyAsInt(stat));
            this.a(delayMap, apMac, delayCountGetter.applyAsInt(stat));
        }
        long queryStartTime = params.getQueryStartTime();
        long queryEndTime = params.getQueryEndTime();
        long timeUnit = params.timeUnit;
        this.a(failVOByAny, timeFailureRecord, true, queryStartTime, queryEndTime, timeUnit);
        this.a(delayVOByAny, timeDelayRecord, true, queryStartTime, queryEndTime, timeUnit);
        WifiConnectProblemVO wifiConnectProblemVO = params.getWifiConnectProblemVO();
        wifiConnectProblemVO.setFailure(failVOByAny);
        wifiConnectProblemVO.setDelay(delayVOByAny);
    }

    private void b(ClientConnectStatQueryDTO queryDTO, N granularity, TreeMap<Long, Map<String, Integer>> timeFailureRecord, TreeMap<Long, Map<String, Integer>> timeDelayRecord, WifiConnProblemParamsDTO params, ToIntFunction<WifiConnProblemByClientDTO> failCountGetter, ToIntFunction<WifiConnProblemByClientDTO> delayCountGetter) {
        HashMap<String, NameCountDTO> nameCountDTOMap = new HashMap<String, NameCountDTO>();
        Map<String, WifiConnProblemByClientDTO> byClientMap = this.c.h(queryDTO, granularity);
        HashMap<String, Long> clientLastStat = new HashMap<String, Long>();
        nameCountDTOMap.put("Total", new NameCountDTO("Total"));
        for (Map.Entry<String, WifiConnProblemByClientDTO> entry : byClientMap.entrySet()) {
            WifiConnProblemByClientDTO stat = entry.getValue();
            String clientMac = stat.getClientMac();
            nameCountDTOMap.computeIfAbsent(clientMac, mac -> new NameCountDTO(clientMac));
            Integer failCount = failCountGetter.applyAsInt(stat);
            Integer delayCount = delayCountGetter.applyAsInt(stat);
            ((NameCountDTO)nameCountDTOMap.get(clientMac)).addFailAndDelay(failCount, delayCount);
            ((NameCountDTO)nameCountDTOMap.get("Total")).addFailAndDelay(failCount, delayCount);
            Long time = stat.getTime();
            clientLastStat.put(clientMac, time);
        }
        ConnectProblemVO failVOByAny = new ConnectProblemVO();
        ConnectProblemVO delayVOByAny = new ConnectProblemVO();
        NameCountDTO totalObject = (NameCountDTO)nameCountDTOMap.remove("Total");
        Set<String> topFailMacs = this.a(nameCountDTOMap, failVOByAny, totalObject);
        Set<String> toDelayMacs = this.b(nameCountDTOMap, delayVOByAny, totalObject);
        Sets.SetView needFindMacs = Sets.union(topFailMacs, toDelayMacs);
        List<WifiConnProblemByClientDTO> historyStat = this.c.b(queryDTO, granularity, (Set<String>)needFindMacs);
        for (WifiConnProblemByClientDTO stat : historyStat) {
            Long time = stat.getTime();
            String clientMac = stat.getClientMac();
            Long lastStatTime = (Long)clientLastStat.get(clientMac);
            if (Objects.isNull(time) || Objects.isNull(lastStatTime) || time > lastStatTime) continue;
            Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
            Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
            this.a(failMap, clientMac, failCountGetter.applyAsInt(stat));
            this.a(delayMap, clientMac, delayCountGetter.applyAsInt(stat));
        }
        long queryStartTime = params.getQueryStartTime();
        long queryEndTime = params.getQueryEndTime();
        long timeUnit = params.timeUnit;
        this.a(failVOByAny, timeFailureRecord, true, queryStartTime, queryEndTime, timeUnit);
        this.a(delayVOByAny, timeDelayRecord, true, queryStartTime, queryEndTime, timeUnit);
        WifiConnectProblemVO wifiConnectProblemVO = params.getWifiConnectProblemVO();
        wifiConnectProblemVO.setFailure(failVOByAny);
        wifiConnectProblemVO.setDelay(delayVOByAny);
    }

    private void a(List<WifiConnProblemByMapPropertyDTO> statList, Map<String, NameCountDTO> nameCountMap, TreeMap<Long, Map<String, Integer>> timeFailureRecord, TreeMap<Long, Map<String, Integer>> timeDelayRecord) {
        for (WifiConnProblemByMapPropertyDTO stat : statList) {
            if (Objects.isNull(stat.getTime())) continue;
            Long time = stat.getTime();
            Map failMap = timeFailureRecord.computeIfAbsent(time, t2 -> new HashMap());
            Map<String, Integer> serverFailMap = stat.mergerFailMapSet();
            for (Map.Entry<String, Integer> failEntry : serverFailMap.entrySet()) {
                String failServer = failEntry.getKey();
                nameCountMap.computeIfAbsent(failServer, mac -> new NameCountDTO(failServer));
                nameCountMap.get(failServer).addFailCount(failEntry.getValue());
                nameCountMap.get("Total").addFailCount(failEntry.getValue());
                Integer srcCount = failMap.getOrDefault(failServer, 0);
                failMap.put(failServer, srcCount + failEntry.getValue());
            }
            Map delayMap = timeDelayRecord.computeIfAbsent(time, t2 -> new HashMap());
            Map<String, Integer> serverDelayMap = stat.mergerDelayMapSet();
            for (Map.Entry<String, Integer> delayEntry : serverDelayMap.entrySet()) {
                String delayServer = delayEntry.getKey();
                nameCountMap.computeIfAbsent(delayServer, mac -> new NameCountDTO(delayServer));
                nameCountMap.get(delayServer).addDelayCount(delayEntry.getValue());
                nameCountMap.get("Total").addDelayCount(delayEntry.getValue());
                Integer srcCount = delayMap.getOrDefault(delayServer, 0);
                delayMap.put(delayServer, srcCount + delayEntry.getValue());
            }
        }
    }

    private void a(Map<String, NameCountDTO> anyCountDTOMap, TreeMap<Long, Map<String, Integer>> timeFailureRecord, TreeMap<Long, Map<String, Integer>> timeDelayRecord, long queryStartTime, long queryEndTime, long timeUnit, WifiConnectProblemVO wifiConnectProblemVO) {
        ConnectProblemVO failVOByAny = new ConnectProblemVO();
        ConnectProblemVO delayVOByAny = new ConnectProblemVO();
        NameCountDTO totalObject = anyCountDTOMap.remove("Total");
        this.a(anyCountDTOMap, failVOByAny, totalObject);
        this.b(anyCountDTOMap, delayVOByAny, totalObject);
        this.a(failVOByAny, timeFailureRecord, true, queryStartTime, queryEndTime, timeUnit);
        this.a(delayVOByAny, timeDelayRecord, true, queryStartTime, queryEndTime, timeUnit);
        wifiConnectProblemVO.setFailure(failVOByAny);
        wifiConnectProblemVO.setDelay(delayVOByAny);
    }

    private Set<String> a(Map<String, NameCountDTO> map, ConnectProblemVO connectProblemVO, NameCountDTO totalTypeObject) {
        HashSet<String> names = new HashSet<String>();
        int accumulateTypeFailNum = 0;
        List failTypeCountList = map.values().stream().filter(nameCountDTO -> nameCountDTO.getFailCount() > 0).sorted(Comparator.comparing(NameCountDTO::getFailCount, Comparator.reverseOrder())).limit(10L).collect(Collectors.toList());
        for (NameCountDTO nameCountDTO2 : failTypeCountList) {
            connectProblemVO.getItems().add(new ConnectProblemItemVO(nameCountDTO2.getName(), nameCountDTO2.getFailCount(), false));
            accumulateTypeFailNum += nameCountDTO2.getFailCount().intValue();
            names.add(nameCountDTO2.getName());
        }
        if (totalTypeObject.getFailCount() - accumulateTypeFailNum > 0) {
            connectProblemVO.getItems().add(new ConnectProblemItemVO("Other", Integer.valueOf(totalTypeObject.getFailCount() - accumulateTypeFailNum), true));
        }
        return names;
    }

    private Set<String> b(Map<String, NameCountDTO> map, ConnectProblemVO connectProblemVO, NameCountDTO totalTypeObject) {
        HashSet<String> names = new HashSet<String>();
        int accumulateTypeDelayNum = 0;
        List delayTypeCountList = map.values().stream().filter(nameCountDTO -> nameCountDTO.getDelayCount() > 0).sorted(Comparator.comparing(NameCountDTO::getDelayCount, Comparator.reverseOrder())).limit(10L).collect(Collectors.toList());
        for (NameCountDTO nameCountDTO2 : delayTypeCountList) {
            connectProblemVO.getItems().add(new ConnectProblemItemVO(nameCountDTO2.getName(), nameCountDTO2.getDelayCount(), false));
            accumulateTypeDelayNum += nameCountDTO2.getDelayCount().intValue();
            names.add(nameCountDTO2.getName());
        }
        if (totalTypeObject.getDelayCount() - accumulateTypeDelayNum > 0) {
            connectProblemVO.getItems().add(new ConnectProblemItemVO("Other", Integer.valueOf(totalTypeObject.getDelayCount() - accumulateTypeDelayNum), true));
        }
        return names;
    }

    private void a(ConnectProblemVO connectProblemVO, TreeMap<Long, Map<String, Integer>> map, boolean needTransfer, long queryStartTime, long queryEndTime, long timeUnit) {
        long[] startAndEnd = this.a(map, queryStartTime, queryEndTime, timeUnit);
        long start = startAndEnd[0];
        long end = startAndEnd[1];
        for (long t2 = start; t2 <= end; t2 += timeUnit) {
            Map timeMap = map.getOrDefault(t2, Collections.emptyMap());
            for (ConnectProblemItemVO itemVO : connectProblemVO.getItems()) {
                if (Objects.isNull(itemVO.getHistory())) continue;
                List history = itemVO.getHistory();
                ConnectProblemHistoryVO historyVO = new ConnectProblemHistoryVO();
                historyVO.setTime(Long.valueOf(t2));
                historyVO.setValue((Integer)timeMap.get(itemVO.getItemName()));
                history.add(historyVO);
            }
        }
        if (needTransfer) {
            for (ConnectProblemItemVO itemVO : connectProblemVO.getItems()) {
                itemVO.setItemName(b.e.b((String)itemVO.getItemName()));
            }
        }
    }

    private void a(Map<String, Integer> map, String key, Integer value) {
        Integer srcValue = map.getOrDefault(key, 0);
        if (Objects.nonNull(value)) {
            map.put(key, srcValue + value);
        }
    }

    private long[] a(Map<Long, Map<String, Integer>> map, long queryStartTime, long queryEndTime, long timeUnit) {
        long end;
        long start;
        long timeUnitNum = (queryEndTime - queryStartTime) / timeUnit;
        if (timeUnit != 86400L) {
            start = (queryStartTime / timeUnit + 1L) * timeUnit;
            end = queryEndTime / timeUnit * timeUnit;
        } else {
            if (CollectionUtils.isEmpty(map)) {
                end = queryEndTime / 3600L * 3600L;
            } else {
                long latestStatTime = queryEndTime / 3600L * 3600L - timeUnitNum * timeUnit;
                for (Map.Entry<Long, Map<String, Integer>> entry : map.entrySet()) {
                    latestStatTime = Math.max(latestStatTime, entry.getKey());
                }
                end = latestStatTime;
            }
            while (end + timeUnit < queryEndTime) {
                end += timeUnit;
            }
            start = end - timeUnit * timeUnitNum;
        }
        return new long[]{start, end};
    }

    private ClientHealthConnectStatVO a(Map<String, ApConnectStatDTO> apConnectStatMap, Map<String, SsidConnectStatDTO> ssidConnectStatMap, ClientConnectStepStatDTO connectStepStatDTO) {
        ClientHealthConnectStatVO statVO = new ClientHealthConnectStatVO();
        statVO.setTotalConnect(connectStepStatDTO.getTotalConnect());
        statVO.setSuccessConnect(connectStepStatDTO.getSuccessConnect());
        statVO.setFailConnect(connectStepStatDTO.getFailConnect());
        statVO.setMostFailStep(connectStepStatDTO.mostFailStep());
        statVO.setDelayAndNoDelay(Integer.valueOf(connectStepStatDTO.getDelayConnect() + connectStepStatDTO.getNoDelayConnect()));
        statVO.setDelayConnect(connectStepStatDTO.getDelayConnect());
        statVO.setNoDelayConnect(connectStepStatDTO.getNoDelayConnect());
        statVO.setMostDelayStep(connectStepStatDTO.mostDelayStep());
        ApConnectStatDTO mostFailAp = new ApConnectStatDTO("");
        ApConnectStatDTO mostDelayAp = new ApConnectStatDTO("");
        for (Map.Entry<String, ApConnectStatDTO> entry : apConnectStatMap.entrySet()) {
            ApConnectStatDTO value = entry.getValue();
            if (value.getFailConnect() > mostFailAp.getFailConnect()) {
                mostFailAp = value;
            }
            if (value.getDelayConnect() <= mostDelayAp.getDelayConnect()) continue;
            mostDelayAp = value;
        }
        if (!Objects.equals("", mostFailAp.getApMac())) {
            statVO.setMostFailApMac(mostFailAp.getApMac());
            statVO.setMostFailApName(mostFailAp.getApName());
        }
        if (!Objects.equals("", mostDelayAp.getApMac())) {
            statVO.setMostDelayApMac(mostDelayAp.getApMac());
            statVO.setMostDelayApName(mostDelayAp.getApName());
        }
        SsidConnectStatDTO mostFailSsid = new SsidConnectStatDTO("");
        SsidConnectStatDTO mostDelaySsid = new SsidConnectStatDTO("");
        for (Map.Entry<String, SsidConnectStatDTO> entry : ssidConnectStatMap.entrySet()) {
            SsidConnectStatDTO value = entry.getValue();
            if (value.getFailConnect() > mostFailSsid.getFailConnect()) {
                mostFailSsid = value;
            }
            if (value.getDelayConnect() <= mostDelaySsid.getDelayConnect()) continue;
            mostDelaySsid = value;
        }
        if (!Objects.equals("", mostFailSsid.getSsid())) {
            statVO.setMostFailSsid(mostFailSsid.getSsid());
        }
        if (!Objects.equals("", mostDelaySsid.getSsid())) {
            statVO.setMostDelaySsid(mostDelaySsid.getSsid());
        }
        return statVO;
    }

    private void a(String omadacId, ClientHealthConnectStatVO vo) {
        String mostDelayApMac = vo.getMostDelayApMac();
        String mostFailApMac = vo.getMostFailApMac();
        HashSet<String> macs = new HashSet<String>();
        if (Objects.nonNull(mostDelayApMac)) {
            macs.add(mostDelayApMac);
        }
        if (Objects.nonNull(mostFailApMac)) {
            macs.add(mostFailApMac);
        }
        if (CollectionUtils.isEmpty(macs)) {
            return;
        }
        com.tplink.smb.omada.manager.device.api.internal.a.a.b deviceResponses = this.i.a(com.tplink.smb.omada.manager.device.api.internal.device.request.device.k.a().a(omadacId).a(new ArrayList(macs)).a());
        if (deviceResponses.a() && !CollectionUtils.isEmpty((Collection)((Collection)deviceResponses.e()))) {
            List deviceImageOutlines = (List)deviceResponses.e();
            for (DeviceImageOutlineDTO deviceImageOutlineDTO : deviceImageOutlines) {
                if (Objects.equals(mostDelayApMac, deviceImageOutlineDTO.getMac())) {
                    vo.setMostDelayApName(deviceImageOutlineDTO.getName());
                }
                if (!Objects.equals(mostFailApMac, deviceImageOutlineDTO.getMac())) continue;
                vo.setMostFailApName(deviceImageOutlineDTO.getName());
            }
        }
    }

    private void a(ClientTopologyDTO clientTopologyDTO, List<TopologyNodeVO> topologyNodeList) {
        List upDeviceTypes = clientTopologyDTO.getUpDeviceTypes();
        LinkedList upAps = new LinkedList(Optional.ofNullable(clientTopologyDTO.getUpAps()).orElse(Collections.emptyList()));
        LinkedList upSwitches = new LinkedList(Optional.ofNullable(clientTopologyDTO.getUpSwitches()).orElse(Collections.emptyList()));
        LinkedList upGateways = new LinkedList(Optional.ofNullable(clientTopologyDTO.getUpGateways()).orElse(Collections.emptyList()));
        if (!CollectionUtils.isEmpty((Collection)upDeviceTypes)) {
            for (String type : upDeviceTypes) {
                DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)type);
                TopologyNodeVO vo = null;
                switch (deviceTypeEnum) {
                    case a: {
                        TopologyApDTO apDTO = (TopologyApDTO)upAps.poll();
                        vo = this.a((BaseTopologyDeviceDTO)apDTO);
                        break;
                    }
                    case c: {
                        TopologyOswDTO oswDTO = (TopologyOswDTO)upSwitches.poll();
                        vo = this.a((BaseTopologyDeviceDTO)oswDTO);
                        break;
                    }
                    case b: {
                        TopologyOsgDTO osgDTO = (TopologyOsgDTO)upGateways.poll();
                        vo = this.a((BaseTopologyDeviceDTO)osgDTO);
                        break;
                    }
                }
                if (!Objects.nonNull(vo)) break;
                topologyNodeList.add(vo);
            }
        }
    }

    private TopologyNodeVO a(d clientImage) {
        ClientInfoVO clientInfoVO = new ClientInfoVO();
        clientInfoVO.setMac(clientImage.ad());
        clientInfoVO.setName(clientImage.ah());
        clientInfoVO.setClientType(clientImage.ao());
        clientInfoVO.setWireless(Boolean.valueOf(clientImage.a()));
        clientInfoVO.setGuest(clientImage.aF());
        clientInfoVO.setUpDeviceType(clientImage.c());
        clientInfoVO.setAuthStatus(Optional.ofNullable(clientImage.aI()).map(com.tplink.smb.omada.client.common.domain.model.shared.e::a).orElse(com.tplink.smb.omada.client.common.domain.model.shared.e.a.a()));
        clientInfoVO.setModel(clientImage.ax());
        clientInfoVO.setManager(Boolean.valueOf(this.a(clientImage.ad(), clientImage.ak())));
        return new TopologyNodeVO(clientInfoVO);
    }

    private TopologyNodeVO a(TopoClientVO topoClientVO, d clientImage) {
        ClientInfoVO.UpApInfo clientUpApInfo;
        ClientInfoVO clientInfoVO = this.a(clientImage).getClientInfo();
        clientInfoVO.setMac(topoClientVO.getMac());
        clientInfoVO.setName(topoClientVO.getName());
        clientInfoVO.setClientType(topoClientVO.getType());
        clientInfoVO.setGuest(topoClientVO.getGuest());
        clientInfoVO.setWireless(topoClientVO.getWireless());
        clientInfoVO.setAuthStatus(topoClientVO.getAuthStatus());
        clientInfoVO.setModel(topoClientVO.getModel());
        clientInfoVO.setManager(Boolean.valueOf(this.a(topoClientVO.getMac(), topoClientVO.getIp())));
        if (Objects.nonNull(topoClientVO.getUpApInfo())) {
            com.tplink.smb.omada.client.domain.model.clientimage.a apClientImage;
            clientInfoVO.setUpDeviceType(DeviceTypeEnum.a);
            TopoClientVO.UpApInfo upApInfo = topoClientVO.getUpApInfo();
            clientUpApInfo = new ClientInfoVO.UpApInfo();
            clientUpApInfo.setSsid(upApInfo.getSsid());
            clientUpApInfo.setRadio(upApInfo.getRadio());
            clientUpApInfo.setChannel(upApInfo.getChannel());
            clientUpApInfo.setSupport5g2(upApInfo.getSupport5g2());
            clientUpApInfo.setRssi(upApInfo.getRssi());
            clientUpApInfo.setTrafficDown(upApInfo.getTrafficDown());
            clientUpApInfo.setTrafficUp(upApInfo.getTrafficUp());
            clientUpApInfo.setTxRate(upApInfo.getTxRate());
            clientUpApInfo.setRxRate(upApInfo.getRxRate());
            if (clientImage instanceof com.tplink.smb.omada.client.domain.model.clientimage.a && !(apClientImage = (com.tplink.smb.omada.client.domain.model.clientimage.a)clientImage).a()) {
                clientUpApInfo.setPort(apClientImage.I());
                clientUpApInfo.setLagId(apClientImage.K());
                clientUpApInfo.setName(apClientImage.J());
            }
            clientInfoVO.setUpApInfo(clientUpApInfo);
        } else if (Objects.nonNull(topoClientVO.getUpSwitchInfo())) {
            clientInfoVO.setUpDeviceType(DeviceTypeEnum.c);
            TopoClientVO.UpOswInfo upOswInfo = topoClientVO.getUpSwitchInfo();
            ClientInfoVO.UpOswInfo clientUpOswInfo = new ClientInfoVO.UpOswInfo();
            clientUpOswInfo.setDuplex(upOswInfo.getDuplex());
            clientUpOswInfo.setLinkSpeed(upOswInfo.getLinkSpeed());
            if (Objects.nonNull(upOswInfo.getPort())) {
                clientUpOswInfo.setPort(upOswInfo.getPort().getPort());
                clientUpOswInfo.setStandardPort(upOswInfo.getPort().getStandardPort());
                clientUpOswInfo.setLagId(upOswInfo.getPort().getLagId());
            }
            clientUpOswInfo.setTrafficDown(upOswInfo.getTrafficDown());
            clientUpOswInfo.setTrafficUp(upOswInfo.getTrafficUp());
            clientInfoVO.setUpOswInfo(clientUpOswInfo);
        } else if (Boolean.TRUE.equals(topoClientVO.getWireless())) {
            clientInfoVO.setUpDeviceType(DeviceTypeEnum.a);
        } else {
            clientInfoVO.setUpDeviceType(DeviceTypeEnum.b);
        }
        if (Objects.nonNull(topoClientVO.getUpGatewayInfo()) && Boolean.TRUE.equals(topoClientVO.getWireless())) {
            TopoClientVO.UpOsgInfo upGatewayInfo = topoClientVO.getUpGatewayInfo();
            clientUpApInfo = new ClientInfoVO.UpApInfo();
            clientUpApInfo.setSsid(upGatewayInfo.getSsid());
            clientUpApInfo.setRadio(upGatewayInfo.getRadio());
            clientUpApInfo.setChannel(upGatewayInfo.getChannel());
            clientUpApInfo.setSupport5g2(upGatewayInfo.getSupport5g2());
            clientUpApInfo.setRssi(upGatewayInfo.getRssi());
            clientUpApInfo.setTrafficDown(upGatewayInfo.getTrafficDown());
            clientUpApInfo.setTrafficUp(upGatewayInfo.getTrafficUp());
            clientUpApInfo.setTxRate(upGatewayInfo.getTxRate());
            clientUpApInfo.setRxRate(upGatewayInfo.getRxRate());
            clientInfoVO.setUpApInfo(clientUpApInfo);
        }
        return new TopologyNodeVO(clientInfoVO);
    }

    private TopologyNodeVO a(BaseTopologyDeviceDTO nodeDTO) {
        if (Objects.isNull(nodeDTO)) {
            return null;
        }
        DeviceInfoVO deviceInfoVO = new DeviceInfoVO();
        deviceInfoVO.setMac(nodeDTO.getMac());
        deviceInfoVO.setName(nodeDTO.getName());
        deviceInfoVO.setModel(nodeDTO.getModel());
        deviceInfoVO.setModelVersion(nodeDTO.getModelVersion());
        deviceInfoVO.setShowModel(nodeDTO.getShowModel());
        deviceInfoVO.setIp(nodeDTO.getIp());
        deviceInfoVO.setIpv6List((List)Optional.ofNullable(nodeDTO.getIpv6List()).map(ArrayList::new).orElse(null));
        deviceInfoVO.setStatus(nodeDTO.getStatus());
        deviceInfoVO.setStatusCategory(nodeDTO.getStatusCategory());
        deviceInfoVO.setDevRxRate(nodeDTO.getDevRxRate());
        deviceInfoVO.setDevTxRate(nodeDTO.getDevTxRate());
        if (nodeDTO instanceof TopologyApDTO) {
            deviceInfoVO.setDeviceType(DeviceTypeEnum.a);
            TopologyApDTO topologyApDTO = (TopologyApDTO)nodeDTO;
            this.a(deviceInfoVO, topologyApDTO);
            return new TopologyNodeVO(deviceInfoVO);
        }
        if (nodeDTO instanceof TopologyOswDTO) {
            deviceInfoVO.setDeviceType(DeviceTypeEnum.c);
            TopologyOswDTO topologyOswDTO = (TopologyOswDTO)nodeDTO;
            deviceInfoVO.setStackGroup(topologyOswDTO.getStackGroup());
            this.a(deviceInfoVO, topologyOswDTO);
            return new TopologyNodeVO(deviceInfoVO);
        }
        if (nodeDTO instanceof TopologyOsgDTO) {
            TopologyOsgDTO topologyOsgDTO = (TopologyOsgDTO)nodeDTO;
            deviceInfoVO.setDeviceType(DeviceTypeEnum.b);
            this.a(deviceInfoVO, topologyOsgDTO);
            return new TopologyNodeVO(deviceInfoVO);
        }
        return null;
    }

    private void a(DeviceInfoVO deviceInfoVO, TopologyApDTO topologyApDTO) {
        if (Objects.nonNull(topologyApDTO.getWirelessUpInfo())) {
            TopologyApDTO.WirelessUpInfoDTO topoWirelessUp = topologyApDTO.getWirelessUpInfo();
            Integer rssiPercent = Optional.ofNullable(topoWirelessUp.getRssiPercent()).map(Math::round).orElse(null);
            ApInfoVO.WirelessUpLink wirelessUpLink = new ApInfoVO.WirelessUpLink();
            wirelessUpLink.setTxRate(topoWirelessUp.getTxRate());
            wirelessUpLink.setRxRate(topoWirelessUp.getRxRate());
            wirelessUpLink.setRssi(topoWirelessUp.getRssi());
            wirelessUpLink.setRssiPercent(rssiPercent);
            wirelessUpLink.setRxDropPkts(topoWirelessUp.getRxDropPkts());
            wirelessUpLink.setTxDropPkts(topoWirelessUp.getTxDropPkts());
            wirelessUpLink.setRxErrPkts(topoWirelessUp.getRxErrPkts());
            wirelessUpLink.setTxErrPkts(topoWirelessUp.getTxErrPkts());
            wirelessUpLink.setSnr(topoWirelessUp.getSnr());
            ApInfoVO apUpInfo = new ApInfoVO();
            apUpInfo.setWirelessUpLink(wirelessUpLink);
            deviceInfoVO.setApInfo(apUpInfo);
        } else if (Objects.nonNull(topologyApDTO.getWiredUpInfo())) {
            WiredUpInfoDTO topoWiredUp = topologyApDTO.getWiredUpInfo();
            ApInfoVO.WiredUpLink wiredUpLink = new ApInfoVO.WiredUpLink();
            wiredUpLink.setUpPort(topoWiredUp.getPort());
            wiredUpLink.setUpLinkPort(topoWiredUp.getUpLinkPort());
            wiredUpLink.setLinkSpeed(topoWiredUp.getLinkSpeed());
            wiredUpLink.setDuplex(topoWiredUp.getDuplex());
            wiredUpLink.setRxDropPkts(topoWiredUp.getRxDropPkts());
            wiredUpLink.setTxDropPkts(topoWiredUp.getTxDropPkts());
            wiredUpLink.setRxErrPkts(topoWiredUp.getRxErrPkts());
            wiredUpLink.setTxErrPkts(topoWiredUp.getTxErrPkts());
            ApInfoVO apUpInfo = new ApInfoVO();
            apUpInfo.setWiredUpLink(wiredUpLink);
            deviceInfoVO.setApInfo(apUpInfo);
        }
    }

    private void a(DeviceInfoVO deviceInfoVO, TopologyOswDTO topologyOswDTO) {
        SwitchInfoVO switchUpInfo = new SwitchInfoVO();
        WiredUpInfoDTO wiredUpInfo = topologyOswDTO.getWiredUpInfo();
        if (wiredUpInfo != null) {
            switchUpInfo.setUpPort(wiredUpInfo.getPort());
            switchUpInfo.setUpLinkPort(wiredUpInfo.getUpLinkPort());
            switchUpInfo.setLinkSpeed(wiredUpInfo.getLinkSpeed());
            switchUpInfo.setDuplex(wiredUpInfo.getDuplex());
            switchUpInfo.setRxDropPkts(wiredUpInfo.getRxDropPkts());
            switchUpInfo.setTxDropPkts(wiredUpInfo.getTxDropPkts());
            switchUpInfo.setRxErrPkts(wiredUpInfo.getRxErrPkts());
            switchUpInfo.setTxErrPkts(wiredUpInfo.getTxErrPkts());
        }
        deviceInfoVO.setSwitchInfo(switchUpInfo);
    }

    private void a(DeviceInfoVO deviceInfoVO, TopologyOsgDTO topologyOsgDTO) {
        if (topologyOsgDTO.getWiredUpInfo() != null) {
            WiredUpInfoDTO wiredUpInfo = topologyOsgDTO.getWiredUpInfo();
            GatewayInfoVO gatewayInfoVO = new GatewayInfoVO();
            gatewayInfoVO.setUpPort(wiredUpInfo.getPort());
            gatewayInfoVO.setUpLinkPort(wiredUpInfo.getUpLinkPort());
            gatewayInfoVO.setLinkSpeed(wiredUpInfo.getLinkSpeed());
            gatewayInfoVO.setDuplex(wiredUpInfo.getDuplex());
            gatewayInfoVO.setRxDropPkts(wiredUpInfo.getRxDropPkts());
            gatewayInfoVO.setTxDropPkts(wiredUpInfo.getTxDropPkts());
            gatewayInfoVO.setRxErrPkts(wiredUpInfo.getRxErrPkts());
            gatewayInfoVO.setTxErrPkts(wiredUpInfo.getTxErrPkts());
            deviceInfoVO.setGatewayInfoVO(gatewayInfoVO);
        }
    }

    private void a(String omadacId, String siteId, List<TopologyNodeVO> topologyNodeList) {
        Map<String, Integer> macTypeMap = this.a(topologyNodeList);
        HealthScoreByMacAndTypeQueryDTO queryDTO = new HealthScoreByMacAndTypeQueryDTO();
        queryDTO.setOmadacId(omadacId);
        queryDTO.setSiteId(siteId);
        queryDTO.setMacAndTypeMap(macTypeMap);
        HashMap<String, Integer> result = this.g.a(queryDTO);
        if (CollectionUtils.isEmpty((Map)result)) {
            result = new HashMap<String, Integer>();
        }
        for (TopologyNodeVO nodeVO : topologyNodeList) {
            String mac;
            if (nodeVO.isClient()) {
                ClientInfoVO clientInfoVO = nodeVO.getClientInfo();
                if (!Objects.nonNull(clientInfoVO)) continue;
                mac = clientInfoVO.getMac();
                clientInfoVO.setHealthScore(result.computeIfAbsent(mac, s2 -> com.tplink.smb.omada.client.api.a.b.a));
                continue;
            }
            DeviceInfoVO deviceInfoVO = nodeVO.getDeviceInfo();
            if (!Objects.nonNull(deviceInfoVO)) continue;
            mac = deviceInfoVO.getMac();
            deviceInfoVO.setHealthScore(result.computeIfAbsent(mac, s2 -> com.tplink.smb.omada.client.api.a.b.a));
        }
    }

    private Map<String, Integer> a(List<TopologyNodeVO> topologyNodeList) {
        HashMap<String, Integer> macTypeMap = new HashMap<String, Integer>(4);
        for (TopologyNodeVO nodeVO : topologyNodeList) {
            if (nodeVO.isClient()) {
                if (!Objects.nonNull(nodeVO.getClientInfo())) continue;
                String mac = nodeVO.getClientInfo().getMac();
                macTypeMap.put(mac, 3);
                continue;
            }
            DeviceInfoVO deviceInfoVO = nodeVO.getDeviceInfo();
            if (!Objects.nonNull(deviceInfoVO)) continue;
            String mac = deviceInfoVO.getMac();
            macTypeMap.put(mac, deviceInfoVO.getDeviceType());
        }
        return macTypeMap;
    }

    private boolean a(String clientMac, String clientIp) {
        if (OmadacType.s()) {
            return false;
        }
        HashSet controllerMacs = new HashSet(com.tplink.smb.omada.common.util.system.b.e());
        if (com.tplink.smb.omada.common.util.system.a.b()) {
            b.debug("ClientWebApiServiceImpl get other node mac.");
            Map allNodeInfo = com.tplink.smb.omada.common.util.system.c.a();
            String currentNodeId = com.tplink.smb.omada.common.util.system.a.h();
            for (String nodeId : allNodeInfo.keySet()) {
                OmadaClusterUniversalRequestDTO requestDTO;
                com.tplink.smb.omada.dispatcher.common.access.OperationResponse macResponse;
                if (!Objects.nonNull(nodeId) || nodeId.equals(currentNodeId) || !(macResponse = this.l.resolveSpringBeanCall(nodeId, requestDTO = new OmadaClusterUniversalRequestDTO(ClientHealthApplicationService.class, (TypeReference)new e(this), "getNodeMacCluster", new Class[0], new Object[0]))).success() || !Objects.nonNull(macResponse.getResult())) continue;
                Set otherOCMacs = (Set)macResponse.getResult();
                controllerMacs.addAll(otherOCMacs);
                b.debug("nodeId: {}, add macs", (Object)nodeId);
            }
        }
        if (!CollectionUtils.isEmpty(controllerMacs) && controllerMacs.contains(clientMac)) {
            return true;
        }
        String localIp = UserIpUtils.getLocalUserIp().orElse(null);
        if (localIp == null) {
            return false;
        }
        return Objects.equals(localIp, clientIp);
    }

    @KeepMethod
    public Set<String> getNodeMacCluster() {
        b.debug("Node id: " + com.tplink.smb.omada.common.util.system.a.h() + "\u2014\u2014> getNodeMacCluster");
        HashSet<String> controllerMacs = new HashSet<String>(com.tplink.smb.omada.common.util.system.b.e());
        return controllerMacs;
    }

    static class WifiConnProblemParamsDTO {
        private long queryStartTime;
        private long queryEndTime;
        private long timeUnit;
        private WifiConnectProblemVO wifiConnectProblemVO;

        @Generated
        public long getQueryStartTime() {
            return this.queryStartTime;
        }

        @Generated
        public long getQueryEndTime() {
            return this.queryEndTime;
        }

        @Generated
        public long getTimeUnit() {
            return this.timeUnit;
        }

        @Generated
        public WifiConnectProblemVO getWifiConnectProblemVO() {
            return this.wifiConnectProblemVO;
        }

        @Generated
        public void setQueryStartTime(long queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        @Generated
        public void setQueryEndTime(long queryEndTime) {
            this.queryEndTime = queryEndTime;
        }

        @Generated
        public void setTimeUnit(long timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Generated
        public void setWifiConnectProblemVO(WifiConnectProblemVO wifiConnectProblemVO) {
            this.wifiConnectProblemVO = wifiConnectProblemVO;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WifiConnProblemParamsDTO)) {
                return false;
            }
            WifiConnProblemParamsDTO other = (WifiConnProblemParamsDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getQueryStartTime() != other.getQueryStartTime()) {
                return false;
            }
            if (this.getQueryEndTime() != other.getQueryEndTime()) {
                return false;
            }
            if (this.getTimeUnit() != other.getTimeUnit()) {
                return false;
            }
            WifiConnectProblemVO this$wifiConnectProblemVO = this.getWifiConnectProblemVO();
            WifiConnectProblemVO other$wifiConnectProblemVO = other.getWifiConnectProblemVO();
            return !(this$wifiConnectProblemVO == null ? other$wifiConnectProblemVO != null : !this$wifiConnectProblemVO.equals(other$wifiConnectProblemVO));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WifiConnProblemParamsDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $queryStartTime = this.getQueryStartTime();
            result = result * 59 + (int)($queryStartTime >>> 32 ^ $queryStartTime);
            long $queryEndTime = this.getQueryEndTime();
            result = result * 59 + (int)($queryEndTime >>> 32 ^ $queryEndTime);
            long $timeUnit = this.getTimeUnit();
            result = result * 59 + (int)($timeUnit >>> 32 ^ $timeUnit);
            WifiConnectProblemVO $wifiConnectProblemVO = this.getWifiConnectProblemVO();
            result = result * 59 + ($wifiConnectProblemVO == null ? 43 : $wifiConnectProblemVO.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientHealthApplicationService.WifiConnProblemParamsDTO(queryStartTime=" + this.getQueryStartTime() + ", queryEndTime=" + this.getQueryEndTime() + ", timeUnit=" + this.getTimeUnit() + ", wifiConnectProblemVO=" + this.getWifiConnectProblemVO() + ")";
        }

        @Generated
        public WifiConnProblemParamsDTO() {
        }

        @Generated
        public WifiConnProblemParamsDTO(long queryStartTime, long queryEndTime, long timeUnit, WifiConnectProblemVO wifiConnectProblemVO) {
            this.queryStartTime = queryStartTime;
            this.queryEndTime = queryEndTime;
            this.timeUnit = timeUnit;
            this.wifiConnectProblemVO = wifiConnectProblemVO;
        }
    }
}

