/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.extend.account;

import com.tplink.smb.omada.common.access.UserInfoBriefDTO;
import com.tplink.smb.omada.common.constant.e;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.cache.MethodInfo;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.chain.ServiceHandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractServerRequestInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;

public class ViewerPermissionRequestInterceptor
extends AbstractServerRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewerPermissionRequestInterceptor.class);

    public void postHandle(RequestEntity<String> request, OperationResponse<?> result, ApiResponseWrapper<?> response, MethodInfo method, ServiceHandlerChain chain) {
        log.debug("ViewerPermissionRequestInterceptor postHandle start");
        this.handleViewerPermission(method, request, result);
    }

    private void handleViewerPermission(MethodInfo method, RequestEntity<String> request, Object result) {
        UserInfoBriefDTO userInfoBriefDTO;
        if (Objects.isNull(method) || Objects.isNull(method.getMethod())) {
            log.warn("handleViewerPermission method is null");
            return;
        }
        if (!(request instanceof AttributeRequestEntity)) {
            log.warn("handleViewerPermission request is not instanceof AttributeRequestEntity");
            return;
        }
        Map attributes = ((AttributeRequestEntity)request).getAttributes();
        Object userInfoBriefDTOObj = attributes.get("currentUserInfoBrief");
        log.debug("handleViewerPermission currentUserInfoBrief {}", userInfoBriefDTOObj);
        if (Objects.isNull(userInfoBriefDTOObj)) {
            log.debug("handleViewerPermission userInfoBriefDTO is null");
            return;
        }
        if (userInfoBriefDTOObj instanceof UserInfoBriefDTO) {
            userInfoBriefDTO = (UserInfoBriefDTO)userInfoBriefDTOObj;
        } else if (userInfoBriefDTOObj instanceof String) {
            userInfoBriefDTO = (UserInfoBriefDTO)x.a((String)((String)userInfoBriefDTOObj), UserInfoBriefDTO.class);
        } else {
            log.warn("handleViewerPermission userInfoBriefDTO is not instanceof UserInfoBriefDTO or String, class {}", userInfoBriefDTOObj.getClass());
            return;
        }
        boolean isViewerPermission = Boolean.TRUE.equals(userInfoBriefDTO.getViewerPermission());
        log.debug("handleViewerPermission getViewerPermission {}", (Object)isViewerPermission);
        if (!isViewerPermission) {
            log.debug("handleViewerPermission getViewerPermission is false");
            return;
        }
        Set targetFieldNameList = userInfoBriefDTO.getEncryptFields();
        if (CollectionUtils.isEmpty((Collection)targetFieldNameList)) {
            log.debug("handleViewerPermission getEncryptFields is empty");
            return;
        }
        if (!(result instanceof OperationResponse)) {
            log.warn("handleViewerPermission result is not instanceof OperationResponse");
            return;
        }
        OperationResponse apiResponse = (OperationResponse)result;
        Object apiResult = apiResponse.getResult();
        for (String targetFieldName : targetFieldNameList) {
            try {
                ViewerPermissionRequestInterceptor.resetValueByFieldName(apiResult, targetFieldName, "******", 0);
            }
            catch (Exception e) {
                log.error("handleViewerPermission resetValueByFieldName err ", (Throwable)e);
            }
        }
    }

    private static void resetValueByFieldName(Object object, String targetFieldName, String targetFieldValue, int level) throws IllegalAccessException {
        log.debug("resetValueByFieldName object {} targetFieldName {} targetFieldValue {} level {}", new Object[]{object, targetFieldName, targetFieldValue, level});
        if (level > 5 || Objects.isNull(object)) {
            return;
        }
        Class<?> clazz = object.getClass();
        if (e.e.contains(clazz)) {
            return;
        }
        String clazzTypeName = clazz.getTypeName();
        log.debug("resetValueByFieldName clazzTypeName {} clazz {}", (Object)clazzTypeName, clazz);
        if (e.f.contains(clazzTypeName)) {
            return;
        }
        if (e.d.contains(clazzTypeName)) {
            List objList = (List)object;
            for (Object obj : objList) {
                ViewerPermissionRequestInterceptor.resetValueByFieldName(obj, targetFieldName, targetFieldValue, level);
            }
            return;
        }
        ++level;
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        Class<?> tmpClazz = clazz;
        for (int cnt = 0; tmpClazz != null && cnt <= 5; ++cnt, tmpClazz = tmpClazz.getSuperclass()) {
            declaredFields.addAll(Arrays.asList(tmpClazz.getDeclaredFields()));
        }
        for (Field field : declaredFields) {
            if (targetFieldName.equals(field.getName())) {
                field.setAccessible(true);
                field.set(object, targetFieldValue);
                return;
            }
            if (field.getType().isPrimitive() || e.e.contains(field.getType())) continue;
            field.setAccessible(true);
            Object childObject = field.get(object);
            if (Objects.isNull(childObject)) continue;
            ViewerPermissionRequestInterceptor.resetValueByFieldName(childObject, targetFieldName, targetFieldValue, level);
        }
    }
}

