/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.grpc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.ecsp.common.exception.TransError;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.rtty.protocol.packet.RttyMessage;

public class OperationResponse<T> {
    private Integer errorCode = 0;
    private String msg;
    private T result;

    public OperationResponse() {
    }

    public OperationResponse(T result) {
        this.result = result;
    }

    public OperationResponse(Integer errorCode, T result) {
        this.errorCode = errorCode;
        this.msg = TransError.getDefaultErrorMessage((int)errorCode);
        this.result = result;
    }

    public static <T> OperationResponse<T> ok() {
        return new OperationResponse<Object>(0, null);
    }

    public static <T> OperationResponse<T> ok(T data) {
        return new OperationResponse<T>(0, data);
    }

    public static <T> OperationResponse<T> error(Integer errorCode) {
        return new OperationResponse<Object>(errorCode, null);
    }

    public static <T> OperationResponse<T> error(Integer errorCode, String message) {
        OperationResponse<Object> operationResponse = new OperationResponse<Object>(errorCode, null);
        operationResponse.setMsg(message);
        return operationResponse;
    }

    public static <T> OperationResponse<T> error(Integer errorCode, T result) {
        return new OperationResponse<T>(errorCode, result);
    }

    @JsonIgnore
    public boolean isOk() {
        return 0 == this.errorCode;
    }

    public static <T> OperationResponse<T> toBean(String json) {
        return (OperationResponse)JacksonUtils.json2Pojo((String)json, OperationResponse.class);
    }

    public static <T> OperationResponse<T> toBean(String json, Class<T> clazz) {
        if (EcspMessage.class.equals(clazz)) {
            OperationResponse<EcspMessage> response = OperationResponse.toBean(json);
            EcspMessage ecspMessage = EcspMessage.parseEcspMessage(response.getResult());
            response.setResult(ecspMessage);
            return response;
        }
        if (RttyMessage.class.equals(clazz)) {
            return OperationResponse.toBean(json);
        }
        return (OperationResponse)JacksonUtils.json2Pojo((String)json, OperationResponse.class, clazz);
    }

    public String toJson() {
        return JacksonUtils.pojo2Json((Object)this);
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getResult() {
        return this.result;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResponse)) {
            return false;
        }
        OperationResponse other = (OperationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "OperationResponse(errorCode=" + this.getErrorCode() + ", msg=" + this.getMsg() + ", result=" + this.getResult() + ")";
    }
}

