/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.event;

import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;

public enum EcspV2TopicEnum {
    TOPIC_PROXY_V2_DISCOVERY_UNICAST(".ecsp.v2.discovery"),
    TOPIC_PROXY_V2_MANAGE_UNICAST(".ecsp.v2.manage"),
    TOPIC_PROXY_V2_INFORM_UNICAST(".ecsp.v2.inform"),
    TOPIC_PROXY_V2_NOTIFY_UNICAST(".ecsp.v2.notify"),
    TOPIC_PROXY_V2_PORTAL_UNICAST(".ecsp.v2.portal"),
    TOPIC_PROXY_V2_DEVICE_STATUS(".ecsp.v2.device.status");

    private final String topicName;

    private EcspV2TopicEnum(String topicName) {
        this.topicName = topicName;
    }

    public static EcspV2TopicEnum resolve(ServerType serverType, MessageType messageType) {
        if (ServerType.DISCOVERY.equals((Object)serverType)) {
            return TOPIC_PROXY_V2_DISCOVERY_UNICAST;
        }
        switch (messageType) {
            case INFORM_REQUEST: {
                return TOPIC_PROXY_V2_INFORM_UNICAST;
            }
            case NOTIFY_REQUEST: 
            case NOTIFY_REQUEST_V2: 
            case UPGRADE_NOTIFY_REQUEST: {
                return TOPIC_PROXY_V2_NOTIFY_UNICAST;
            }
            case EVENT_PORTAL_QUERY: {
                return TOPIC_PROXY_V2_PORTAL_UNICAST;
            }
        }
        return TOPIC_PROXY_V2_MANAGE_UNICAST;
    }

    public String getTopicName() {
        return this.topicName;
    }
}

