/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.event;

import com.tplink.smb.ecsp.protocol.ServerType;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;

public enum EcspV1TopicEnum {
    TOPIC_PROXY_V1_DISCOVERY_UNICAST(".ecsp.v1.discovery"),
    TOPIC_PROXY_V1_ADOPT_UNICAST(".ecsp.v1.adopt"),
    TOPIC_PROXY_V1_MANAGE_UNICAST(".ecsp.v1.manage"),
    TOPIC_PROXY_V1_INFORM_UNICAST(".ecsp.v1.inform"),
    TOPIC_PROXY_V1_NOTIFY_UNICAST(".ecsp.v1.notify"),
    TOPIC_PROXY_V1_PORTAL_UNICAST(".ecsp.v1.portal"),
    TOPIC_PROXY_V1_REBUILD_UNICAST(".ecsp.v1.rebuild"),
    TOPIC_PROXY_V1_UPGRADE_UNICAST(".ecsp.v1.upgrade"),
    TOPIC_PROXY_V1_DEVICE_STATUS(".ecsp.v1.device.status");

    private final String topicName;

    private EcspV1TopicEnum(String topicName) {
        this.topicName = topicName;
    }

    public static EcspV1TopicEnum resolve(ServerType serverType, MessageType messageType) {
        switch (serverType) {
            case DISCOVERY: {
                return TOPIC_PROXY_V1_DISCOVERY_UNICAST;
            }
            case ADOPT: {
                return TOPIC_PROXY_V1_ADOPT_UNICAST;
            }
            case UPGRADE: {
                return TOPIC_PROXY_V1_UPGRADE_UNICAST;
            }
        }
        switch (messageType) {
            case INFORM_REQUEST: {
                return TOPIC_PROXY_V1_INFORM_UNICAST;
            }
            case NOTIFY_REQUEST: {
                return TOPIC_PROXY_V1_NOTIFY_UNICAST;
            }
            case EVENT_PORTAL_QUERY: {
                return TOPIC_PROXY_V1_PORTAL_UNICAST;
            }
            case REBUILD_REQUEST: {
                return TOPIC_PROXY_V1_REBUILD_UNICAST;
            }
        }
        return TOPIC_PROXY_V1_MANAGE_UNICAST;
    }

    public String getTopicName() {
        return this.topicName;
    }
}

