/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.event;

import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.DeviceInfo;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;

public class DeviceEventFilter {
    private String deviceMac;
    private String version;
    private Integer messageType;
    private Integer seq;
    private AddressDTO addressDTO;

    public static DeviceEventFilter buildFromEcspMessage(EcspMessage ecspMessage, AddressDTO addressDTO) {
        return DeviceEventFilter.builder().deviceMac(ecspMessage.getMac()).version(ecspMessage.getVersion()).messageType(ecspMessage.getMessageType()).seq(ecspMessage.getSeq()).addressDTO(addressDTO).build();
    }

    public static DeviceEventFilter buildFromDeviceInfo(DeviceInfo deviceInfo) {
        return DeviceEventFilter.builder().deviceMac(deviceInfo.getMac()).build();
    }

    public static DeviceEventFilter toBean(String json) {
        return (DeviceEventFilter)JacksonUtils.json2Pojo((String)json, DeviceEventFilter.class);
    }

    public String toJson() {
        return JacksonUtils.pojo2Json((Object)this);
    }

    public static boolean isValid(DeviceEventFilter eventFilterDTO) {
        return eventFilterDTO != null;
    }

    public static DeviceEventFilterBuilder builder() {
        return new DeviceEventFilterBuilder();
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getMessageType() {
        return this.messageType;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public AddressDTO getAddressDTO() {
        return this.addressDTO;
    }

    public DeviceEventFilter() {
    }

    public DeviceEventFilter(String deviceMac, String version, Integer messageType, Integer seq, AddressDTO addressDTO) {
        this.deviceMac = deviceMac;
        this.version = version;
        this.messageType = messageType;
        this.seq = seq;
        this.addressDTO = addressDTO;
    }

    public static class DeviceEventFilterBuilder {
        private String deviceMac;
        private String version;
        private Integer messageType;
        private Integer seq;
        private AddressDTO addressDTO;

        DeviceEventFilterBuilder() {
        }

        public DeviceEventFilterBuilder deviceMac(String deviceMac) {
            this.deviceMac = deviceMac;
            return this;
        }

        public DeviceEventFilterBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DeviceEventFilterBuilder messageType(Integer messageType) {
            this.messageType = messageType;
            return this;
        }

        public DeviceEventFilterBuilder seq(Integer seq) {
            this.seq = seq;
            return this;
        }

        public DeviceEventFilterBuilder addressDTO(AddressDTO addressDTO) {
            this.addressDTO = addressDTO;
            return this;
        }

        public DeviceEventFilter build() {
            return new DeviceEventFilter(this.deviceMac, this.version, this.messageType, this.seq, this.addressDTO);
        }

        public String toString() {
            return "DeviceEventFilter.DeviceEventFilterBuilder(deviceMac=" + this.deviceMac + ", version=" + this.version + ", messageType=" + this.messageType + ", seq=" + this.seq + ", addressDTO=" + this.addressDTO + ")";
        }
    }
}

