/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.event;

import com.tplink.smb.ecsp.message.event.DeviceEventFilter;
import com.tplink.smb.ecsp.message.event.DeviceInfoEvent;
import com.tplink.smb.ecsp.message.event.DeviceMessage;
import com.tplink.smb.ecsp.message.event.DeviceMessageEvent;
import com.tplink.smb.ecsp.message.event.ServerEventDTO;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventHandler.class);

    public void handleEvent(Event event) {
        ServerEventDTO serverEventDTO = this.getEcspMessageFromEvent(event);
        if (Objects.nonNull(serverEventDTO) && this.filterEvent()) {
            this.perform(serverEventDTO);
        }
    }

    private ServerEventDTO getEcspMessageFromEvent(Event event) {
        DeviceEventFilter eventFilter = DeviceEventFilter.toBean(event.getFilterKey());
        DeviceMessageEvent deviceMessageEvent = DeviceMessageEvent.toBean((String)event.getMessage());
        if (!DeviceEventFilter.isValid(eventFilter) || !DeviceMessageEvent.isValid(deviceMessageEvent)) {
            log.info("device ecsp message Event is un valid\uff1a{}", (Object)event.getFilterKey());
            return null;
        }
        DeviceMessage deviceMessage = deviceMessageEvent.getDeviceMessage();
        EcspMessage ecspMessage = EcspMessage.parseEcspMessage((Object)deviceMessage.getEcspMessage());
        if (DeviceMessage.isValid(deviceMessage) && !EcspMessage.isNotValid((EcspMessage)ecspMessage)) {
            return new ServerEventDTO(deviceMessage.getAdoptInfo(), ecspMessage, null, event.getTimeStamp(), eventFilter.getAddressDTO());
        }
        log.info("device ecsp message Event is un valid: {}", (Object)event.getFilterKey());
        return null;
    }

    protected ServerEventDTO getDeviceInfoFromEvent(Event event) {
        DeviceEventFilter eventFilter = DeviceEventFilter.toBean(event.getFilterKey());
        DeviceInfoEvent deviceInfoEvent = DeviceInfoEvent.toBean((String)event.getMessage());
        if (DeviceEventFilter.isValid(eventFilter) && DeviceInfoEvent.isValid(deviceInfoEvent)) {
            return new ServerEventDTO(null, null, deviceInfoEvent.getDeviceInfo(), event.getTimeStamp(), eventFilter.getAddressDTO());
        }
        log.info("deviceInfo Event is un valid: {}", (Object)event.getFilterKey());
        return null;
    }

    protected boolean filterEvent() {
        return true;
    }

    protected abstract void perform(ServerEventDTO var1);

    protected void logSupportedMessage(MessageType messageType, String deviceMac, long delayTime) {
        log.trace("get {} message for {}, delay time = {}ms", new Object[]{messageType, deviceMac, delayTime});
    }

    protected void logUnsupportedMessage(MessageType messageType, String deviceMac) {
        log.debug("Unsupported message type {} for {}", (Object)messageType, (Object)deviceMac);
    }
}

