/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.cache;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.ecsp.common.monitor.CommonMonitor;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.ServerRouteDTO;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRouteCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(ServerRouteCacheUtils.class);

    private ServerRouteCacheUtils() {
    }

    public static ServerRouteDTO getServerRouteCache(String deviceMac, CacheService cacheService) {
        CommonMonitor.incServerRouteGetCounter();
        ServerRouteDTO serverRouteDTO = (ServerRouteDTO)cacheService.get("ecsp:device.server.route", ServerRouteCacheUtils.formatCacheKey(deviceMac), ServerRouteDTO.class);
        if (Objects.isNull(serverRouteDTO)) {
            CommonMonitor.incServerRouteGetFailedCounter();
        }
        log.debug("get server route cache for device {}, {}", (Object)deviceMac, (Object)serverRouteDTO);
        return serverRouteDTO;
    }

    public static void setServerRouteCache(String deviceMac, ServerRouteDTO serverRouteDTO, CacheService cacheService) {
        log.debug("set server route cache for device {}, route {}", (Object)deviceMac, (Object)serverRouteDTO);
        cacheService.set("ecsp:device.server.route", ServerRouteCacheUtils.formatCacheKey(deviceMac), (Object)serverRouteDTO);
        CommonMonitor.incServerRouteUpdateCounter();
    }

    public static void setServerRouteCache(String deviceMac, ServerRouteDTO serverRouteDTO, long expireTime, CacheService cacheService) {
        log.debug("set server route cache for device {}, route {}, expire {}", new Object[]{deviceMac, serverRouteDTO, expireTime});
        cacheService.set("ecsp:device.server.route", ServerRouteCacheUtils.formatCacheKey(deviceMac), (Object)serverRouteDTO, expireTime, TimeUnit.SECONDS);
        CommonMonitor.incServerRouteExpireCounter();
    }

    public static void doWithTryLock(LockService lockService, String deviceMac, int tryLockTime, Supplier<Void> handler) {
        lockService.doWithTryLock("device-server-route-lock", (Object)deviceMac, (long)tryLockTime, TimeUnit.SECONDS, handler, () -> null);
    }

    public static <T> T tryLock(LockService lockService, String deviceMac, int tryLockTime, @Nonnull Supplier<T> onSuccess, @Nonnull Supplier<T> onLockFailed) {
        return (T)lockService.doWithTryLock("device-server-route-lock", (Object)deviceMac, (long)tryLockTime, TimeUnit.SECONDS, onSuccess, onLockFailed);
    }

    private static String formatCacheKey(String cacheKey) {
        return StringUtils.isEmpty((String)cacheKey) ? cacheKey : cacheKey.replace(":", "-").toLowerCase(Locale.ROOT);
    }

    public static boolean isAdoptServerRouteNull(@Nullable ServerRouteDTO serverRouteDTO) {
        return Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getAdoptServerRoute());
    }

    public static boolean isManageServerRouteNull(@Nullable ServerRouteDTO serverRouteDTO) {
        return Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getManageServerRoute());
    }

    public static boolean isUpgradeServerRouteNull(@Nullable ServerRouteDTO serverRouteDTO) {
        return Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getUpgradeServerRoute());
    }

    public static boolean isTransferServerRouteNull(@Nullable ServerRouteDTO serverRouteDTO) {
        return Objects.isNull(serverRouteDTO) || Objects.isNull(serverRouteDTO.getFileTransferRoute());
    }

    public static void updateManageServerRouteExpire(String deviceMac, LockService lockService, CacheService cacheService, int tryLockTimeout, long connectedServerRouteExpire) {
        ServerRouteCacheUtils.doWithTryLock(lockService, deviceMac, tryLockTimeout, () -> {
            ServerRouteDTO serverRouteDTO = ServerRouteCacheUtils.getServerRouteCache(deviceMac, cacheService);
            if (ServerRouteCacheUtils.isManageServerRouteNull(serverRouteDTO)) {
                return null;
            }
            ServerRouteCacheUtils.setServerRouteCache(deviceMac, serverRouteDTO, connectedServerRouteExpire, cacheService);
            return null;
        });
    }
}

