/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.message.cache;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.message.cache.AdoptInfoDTO;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdoptInfoCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(AdoptInfoCacheUtils.class);

    private AdoptInfoCacheUtils() {
    }

    public static AdoptInfoDTO getDeviceAdoptInfoCache(String deviceMac, CacheService cacheService) {
        AdoptInfoDTO adoptInfoDTO = (AdoptInfoDTO)cacheService.get("ecsp:device.adopt.info", AdoptInfoCacheUtils.formatCacheKey(deviceMac), AdoptInfoDTO.class);
        if (log.isDebugEnabled()) {
            log.debug("get adopt info cache for device {}, adoptInfo {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)adoptInfoDTO);
        }
        return adoptInfoDTO;
    }

    public static void setDeviceAdoptInfoCache(String deviceMac, AdoptInfoDTO adoptInfoDTO, CacheService cacheService) {
        if (log.isDebugEnabled()) {
            log.debug("set adopt info cache for device {}, adoptInfo: {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)adoptInfoDTO);
        }
        cacheService.set("ecsp:device.adopt.info", AdoptInfoCacheUtils.formatCacheKey(deviceMac), (Object)adoptInfoDTO);
    }

    public static void setDeviceAdoptInfoCache(String deviceMac, AdoptInfoDTO adoptInfoDTO, long timeout, CacheService cacheService) {
        log.debug("set adopt info cache for device {}, route {}", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)adoptInfoDTO);
        cacheService.set("ecsp:device.adopt.info", AdoptInfoCacheUtils.formatCacheKey(deviceMac), (Object)adoptInfoDTO, timeout, TimeUnit.SECONDS);
    }

    static String formatCacheKey(String cacheKey) {
        return StringUtils.isEmpty((String)cacheKey) ? cacheKey : cacheKey.replace(":", "-").toLowerCase(Locale.ROOT);
    }
}

