/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.lock;

import com.tplink.smb.component.lock.api.ReadWriteLockService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeFileLockFactory {
    private static final Logger log = LoggerFactory.getLogger(UpgradeFileLockFactory.class);
    ReadWriteLockService readWriteLockService;
    private static final String SEPARATOR = ":";
    private static final String KEY_MODULE = "component";
    private static final String TYPE_FILE = "upgrade.file";
    private static final String TYPE_FILERECORD = "upgrade.fileRecord";
    private static final long LOCK_OUT_TIME = 15L;

    public <T> T tryLockFileRead(String fileKey, Supplier<T> onSuccess, Supplier<T> onFail) {
        String lockName = this.buildLockName(KEY_MODULE, TYPE_FILE);
        return (T)this.readWriteLockService.doWithTryLockRead(lockName, (Object)fileKey, 15L, TimeUnit.SECONDS, onSuccess, onFail);
    }

    public <T> T tryLockFileWrite(String fileKey, Supplier<T> onSuccess, Supplier<T> onFail) {
        String lockName = this.buildLockName(KEY_MODULE, TYPE_FILE);
        return (T)this.readWriteLockService.doWithTryLockWrite(lockName, (Object)fileKey, 15L, TimeUnit.SECONDS, onSuccess, onFail);
    }

    public <T> T tryLockFileRecordRead(String fileKey, Supplier<T> onSuccess, Supplier<T> onFail) {
        String lockName = this.buildLockName(KEY_MODULE, TYPE_FILERECORD);
        return (T)this.readWriteLockService.doWithTryLockRead(lockName, (Object)fileKey, 15L, TimeUnit.SECONDS, onSuccess, onFail);
    }

    public <T> T tryLockFileRecordWrite(String fileKey, Supplier<T> onSuccess, Supplier<T> onFail) {
        String lockName = this.buildLockName(KEY_MODULE, TYPE_FILERECORD);
        return (T)this.readWriteLockService.doWithTryLockWrite(lockName, (Object)fileKey, 15L, TimeUnit.SECONDS, onSuccess, onFail);
    }

    private String buildLockName(String module, String lockType) {
        Objects.requireNonNull(lockType, "Build Lock name failed, null lockType");
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_MODULE).append(SEPARATOR).append(module).append(SEPARATOR);
        sb.append(lockType);
        return sb.toString();
    }

    public void setReadWriteLockService(ReadWriteLockService readWriteLockService) {
        this.readWriteLockService = readWriteLockService;
    }
}

