/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.fileservice;

import com.tplink.smb.component.upgradefilecache.common.mongo.utils.IOUtils;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.MD5Utils;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.StringUtils;
import com.tplink.smb.component.upgradefilecache.common.util.Pair;
import com.tplink.smb.component.upgradefilecache.local.LocalConstant;
import com.tplink.smb.component.upgradefilecache.local.cache.FwDownloadUrlCache;
import com.tplink.smb.component.upgradefilecache.local.cache.UpgradeFileCache;
import com.tplink.smb.component.upgradefilecache.local.fileservice.DiskFileRepository;
import com.tplink.smb.component.upgradefilecache.local.lock.UpgradeFileLockFactory;
import com.tplink.smb.component.upgradefilecache.local.prop.UpgradeFileManageProp;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUpgradeFileRepository {
    private static final Logger log = LoggerFactory.getLogger(DiskUpgradeFileRepository.class);
    private DiskFileRepository diskFileRepositoryImpl;
    private FwDownloadUrlCache fwDownloadUrlCache;
    private UpgradeFileLockFactory upgradeFileLockFactory;
    private UpgradeFileManageProp upgradeFileManageProp;
    private UpgradeFileCache upgradeFileCache;
    private static final String BYTES_CONSTANT = "bytes=";
    private String MY_DIR = "";
    private String EAP_HOME = "eap.home";
    private static final Object fileLock = new Object();

    public boolean getFileStreamToOutputStream(String url, String urlPrefix, String range, Long memoryLimit, OutputStream outputStream) {
        String fileKey = this.getFileKeyFromUrl(url, urlPrefix);
        if (fileKey == null) {
            return false;
        }
        String filePath = this.getFilePathByFileKey(fileKey);
        Pair<Long, Long> rangeParam = this.calRangeParam(range);
        long start = (Long)rangeParam.getKey();
        long end = (Long)rangeParam.getValue();
        log.debug("getFileStreamToOutputStream file range: {} {}", (Object)start, (Object)end);
        return this.upgradeFileLockFactory.tryLockFileRead(filePath, () -> {
            File file = new File(filePath);
            long fileStartPos = start == -1L ? 0L : start;
            long fileEndPos = end == -1L ? file.length() - 1L : end;
            long contentLength = fileEndPos - fileStartPos + 1L;
            if (!file.exists()) {
                return false;
            }
            boolean needCache = memoryLimit == null || memoryLimit > contentLength;
            String fileCacheKey = fileKey + "start" + fileStartPos + "end" + fileEndPos;
            if (this.upgradeFileCache.getFile(fileCacheKey) == null) {
                Object object = fileLock;
                synchronized (object) {
                    block54: {
                        if (this.upgradeFileCache.getFile(fileCacheKey) == null) {
                            long readByteLength = 0L;
                            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                                Boolean bl;
                                OutputStream bos = needCache ? new ByteArrayOutputStream() : outputStream;
                                Throwable throwable = null;
                                try {
                                    in.skip(fileStartPos);
                                    int buf_size = 1024;
                                    byte[] buffer = new byte[buf_size];
                                    int len = 0;
                                    while (readByteLength + (long)buf_size <= contentLength && (len = in.read(buffer, 0, buf_size)) != -1) {
                                        bos.write(buffer, 0, len);
                                        readByteLength += (long)len;
                                    }
                                    if (readByteLength < contentLength) {
                                        len = in.read(buffer, 0, (int)(contentLength - readByteLength));
                                        bos.write(buffer, 0, len);
                                    }
                                    if (needCache) {
                                        this.upgradeFileCache.addFile(fileCacheKey, ((ByteArrayOutputStream)bos).toByteArray());
                                        break block54;
                                    }
                                    log.info("large file {} size {} not cache", (Object)file.getName(), (Object)file.length());
                                    bos.flush();
                                    bl = true;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                return bl;
                                finally {
                                    if (bos != null) {
                                        if (throwable != null) {
                                            try {
                                                bos.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            bos.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException e) {
                                log.warn("can't get file in local", (Throwable)e);
                                return false;
                            }
                        }
                    }
                }
            } else {
                this.upgradeFileCache.expireFile(fileCacheKey);
            }
            try (ByteArrayInputStream fileStream = new ByteArrayInputStream(this.upgradeFileCache.getFile(fileCacheKey));){
                IOUtils.copy((InputStream)fileStream, (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                log.warn("can't get file content in map", (Throwable)e);
                return false;
            }
        }, () -> {
            log.warn("get file lock failed when getFileStreamToOutputStream, filePath = {}", (Object)filePath);
            return false;
        });
    }

    public void saveUpgradeFile(String fileKey, InputStream in) {
        this.diskFileRepositoryImpl.saveFile(this.getFilePathByFileKey(fileKey), in);
    }

    public boolean deleteFile(String fileKey) {
        return this.diskFileRepositoryImpl.deleteFile(this.getFileDirByFileKey(fileKey));
    }

    public long getUpgradeFileTotalSize() {
        return this.diskFileRepositoryImpl.getTotalDirFileSize(this.getUpgradeFileDirPath());
    }

    public List<String> getAllUpgradeFileNames() {
        return this.diskFileRepositoryImpl.getAllFileKeys(this.getUpgradeFileDirPath());
    }

    public String getUpgradeFileDirPath() {
        String dirPath = this.upgradeFileManageProp.getUpgradeFileDir();
        return "".equals(dirPath) ? this.getMyDIR() + File.separatorChar + LocalConstant.DEVICE_FW_DIR : this.getMyDIR() + File.separatorChar + dirPath + File.separatorChar + LocalConstant.DEVICE_FW_DIR;
    }

    public boolean checkFileExistInDisk(String fileKey) {
        String filePath = this.getFilePathByFileKey(fileKey);
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        return MD5Utils.md5((File)file).equals(fileKey);
    }

    public byte[] getFileContent(String fileKey) {
        String fwPath = this.getFilePathByFileKey(fileKey);
        return this.diskFileRepositoryImpl.getFileContent(fwPath);
    }

    private String getFilePathByFileKey(String fileKey) {
        String fwFileDir = this.getUpgradeFileDirPath();
        return fwFileDir + File.separatorChar + fileKey + File.separatorChar + fileKey + ".bin";
    }

    private String getFileDirByFileKey(String fileKey) {
        String fwFileDir = this.getUpgradeFileDirPath();
        return fwFileDir + File.separatorChar + fileKey;
    }

    private boolean checkUrlValid(String url) {
        return this.fwDownloadUrlCache.checkDownloadUrl(url);
    }

    private String getFileKeyFromUrl(String url, String urlPrefix) {
        if (!this.checkUrlValid(url)) {
            return null;
        }
        if (!url.startsWith(urlPrefix)) {
            return null;
        }
        String[] urlParts = url.split("/");
        return urlParts[urlParts.length - 1];
    }

    public String getMyDIR() {
        if (this.MY_DIR.isEmpty()) {
            this.MY_DIR = System.getProperty(this.EAP_HOME);
        }
        if (!this.MY_DIR.isEmpty()) {
            return this.MY_DIR;
        }
        String jarFullPath = DiskUpgradeFileRepository.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        try {
            jarFullPath = URLDecoder.decode(jarFullPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Encoding is invalid.", (Throwable)e);
        }
        return new File(jarFullPath).getParentFile().getAbsolutePath() + File.separator + "..";
    }

    private Pair<Long, Long> calRangeParam(String range) {
        long rangeStart = -1L;
        long rangeEnd = -1L;
        if (range != null && range.contains(BYTES_CONSTANT)) {
            try {
                if (!range.contains("-")) {
                    rangeStart = Long.parseLong(range.trim().replaceAll(BYTES_CONSTANT, ""));
                } else {
                    String[] partArray = range.trim().replaceAll(BYTES_CONSTANT, "").split("-");
                    rangeStart = StringUtils.isNull((String)partArray[0]) ? 0L : Long.parseLong(partArray[0]);
                    rangeEnd = StringUtils.isNull((String)partArray[1]) ? -1L : Long.parseLong(partArray[1]);
                }
            }
            catch (NumberFormatException e) {
                log.warn("calRangeParam unexpect range format {}", (Object)range);
                rangeStart = -1L;
                rangeEnd = -1L;
            }
        }
        return new Pair((Object)rangeStart, (Object)rangeEnd);
    }

    public void setDiskFileRepositoryImpl(DiskFileRepository diskFileRepositoryImpl) {
        this.diskFileRepositoryImpl = diskFileRepositoryImpl;
    }

    public void setFwDownloadUrlCache(FwDownloadUrlCache fwDownloadUrlCache) {
        this.fwDownloadUrlCache = fwDownloadUrlCache;
    }

    public void setUpgradeFileLockFactory(UpgradeFileLockFactory upgradeFileLockFactory) {
        this.upgradeFileLockFactory = upgradeFileLockFactory;
    }

    public void setUpgradeFileManageProp(UpgradeFileManageProp upgradeFileManageProp) {
        this.upgradeFileManageProp = upgradeFileManageProp;
    }

    public void setUpgradeFileCache(UpgradeFileCache upgradeFileCache) {
        this.upgradeFileCache = upgradeFileCache;
    }

    public void setMY_DIR(String MY_DIR) {
        this.MY_DIR = MY_DIR;
    }

    public void setEAP_HOME(String EAP_HOME) {
        this.EAP_HOME = EAP_HOME;
    }
}

