/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.fileservice;

import com.tplink.smb.component.upgradefilecache.local.lock.UpgradeFileLockFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFileRepository {
    private static final Logger log = LoggerFactory.getLogger(DiskFileRepository.class);
    UpgradeFileLockFactory upgradeFileLockFactory;

    public void saveFile(String filePath, InputStream in) {
        File file = new File(filePath);
        if (null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            int length;
            byte[] b = new byte[1024];
            while ((length = in.read(b)) > 0) {
                fos.write(b, 0, length);
            }
            in.close();
        }
        catch (IOException e) {
            log.warn("saveFile filePath:{} ", (Object)filePath, (Object)e);
        }
    }

    public boolean deleteFile(String filePath) {
        return this.upgradeFileLockFactory.tryLockFileWrite(filePath, () -> {
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            if (file.isFile() || file.list() == null) {
                return file.delete();
            }
            for (File f : file.listFiles()) {
                this.deleteFile(f.getAbsolutePath());
            }
            return file.delete();
        }, () -> {
            log.warn("get file lock failed when delete file = {}", (Object)filePath);
            return false;
        });
    }

    public List<String> getAllFileKeys(String filePath) {
        File file = new File(filePath);
        if (!file.isDirectory()) {
            return new ArrayList<String>();
        }
        if (file.list() == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(file.list());
    }

    public long getTotalDirFileSize(String dirPath) {
        File file = new File(dirPath);
        if (!file.exists()) {
            return 0L;
        }
        Path path = file.toPath();
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    log.warn("skipped: {} ({})", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        log.debug("had trouble traversing: {} ({})", (Object)dir, (Object)exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.warn("getTotalDirFileSize dirPath:{} ", (Object)dirPath, (Object)e);
            throw new AssertionError((Object)"walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return size.get();
    }

    public boolean checkFileExistAndIntegrity(String fwFilePath, String MD5) {
        boolean fileExist = DiskFileRepository.checkFileExist(fwFilePath);
        String md5 = null;
        try {
            if (fileExist) {
                FileInputStream in = new FileInputStream(fwFilePath);
                md5 = DigestUtils.md5Hex((InputStream)in);
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            log.warn("checkFileExistAndIntegrity fwFilePath:{}.", (Object)fwFilePath, (Object)e);
        }
        boolean fileIntegrity = DiskFileRepository.checkMd5Equals(MD5, md5);
        return fileExist && fileIntegrity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileContent(String fwPath) {
        File file = new File(fwPath);
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            return null;
        }
        try (FileInputStream fi = new FileInputStream(file);){
            int offset;
            byte[] buffer = new byte[(int)fileSize];
            int numRead = 0;
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                byte[] byArray2 = null;
                return byArray2;
            }
            fi.close();
            byte[] byArray = buffer;
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.warn("file {} not found in local", (Object)fwPath, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.warn("Exception when get file {} content", (Object)fwPath, (Object)e);
            return null;
        }
    }

    private static boolean checkMd5Equals(String md51, String md52) {
        if (null == md51 || null == md52) {
            return false;
        }
        return md51.equals(md52) || md51.equalsIgnoreCase(md52);
    }

    private static boolean checkFileExist(String filePath) {
        if (filePath == null) {
            log.warn("'fileName' is null.");
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public void setUpgradeFileLockFactory(UpgradeFileLockFactory upgradeFileLockFactory) {
        this.upgradeFileLockFactory = upgradeFileLockFactory;
    }
}

