/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.download;

import com.tplink.smb.component.upgradefilecache.api.DownloadCallback;
import com.tplink.smb.component.upgradefilecache.api.DownloadResponse;
import com.tplink.smb.component.upgradefilecache.common.mongo.UpgradeFileInfoRepository;
import com.tplink.smb.component.upgradefilecache.common.mongo.po.UpgradeFileInfoPO;
import com.tplink.smb.component.upgradefilecache.local.LocalUpgradeFileCache;
import com.tplink.smb.component.upgradefilecache.local.cache.FwDownloadStatusCache;
import com.tplink.smb.component.upgradefilecache.local.download.FwDownLoadTask;
import com.tplink.smb.component.upgradefilecache.local.fileservice.DiskFileRepository;
import com.tplink.smb.component.upgradefilecache.local.prop.UpgradeFileManageProp;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwDownloadService {
    private static final Logger log = LoggerFactory.getLogger(FwDownloadService.class);
    private DiskFileRepository diskFileRepository;
    private UpgradeFileManageProp upgradeFileManageProp;
    private UpgradeFileInfoRepository upgradeFileInfoRepository;
    private LocalUpgradeFileCache localUpgradeFileCache;

    public DownloadResponse downloadFw(String url, String fileParentPath, String fileName, List<String> caFiles, DownloadCallback downloadCallback) {
        String filePath = fileParentPath + File.separator + fileName;
        String fileMd5 = fileName.split("\\.")[0];
        if (!FwDownloadStatusCache.firmwareIsDownloading(fileMd5)) {
            log.warn("Firmware ({}) is downloading, please retry later.", (Object)fileMd5);
            return DownloadResponse.WAITING;
        }
        if (this.diskFileRepository.checkFileExistAndIntegrity(filePath, fileMd5)) {
            log.info("Firmware file of model({}) has already existed, so needn't be downloaded.", (Object)fileMd5);
            FwDownloadStatusCache.updateModelDownloadInfo(fileMd5, new FwDownloadStatusCache.OnlineDownloadInfo(null, new AtomicInteger(100)));
            long fizeSize = this.diskFileRepository.getTotalDirFileSize(fileParentPath);
            this.upgradeFileInfoRepository.save(new UpgradeFileInfoPO(fileMd5, fileMd5, fileName, fizeSize, System.currentTimeMillis(), Boolean.valueOf(true)));
            downloadCallback.success(fileMd5, fizeSize, null);
            return DownloadResponse.FINISHED;
        }
        this.diskFileRepository.deleteFile(fileParentPath);
        FwDownloadStatusCache.OnlineDownloadInfo downInfo = FwDownloadStatusCache.getModelDownloadInfo(fileMd5);
        if (downInfo != null) {
            AtomicInteger downProgress = downInfo.getDownProgress();
            downProgress.set(0);
            downInfo.setDownFuture(null);
        } else {
            downInfo = new FwDownloadStatusCache.OnlineDownloadInfo();
            AtomicInteger downProgress = new AtomicInteger();
            downInfo.setDownProgress(downProgress);
        }
        FwDownloadStatusCache.updateModelDownloadInfo(fileMd5, downInfo);
        DownloadCallback downCb = this.handleAttachedDownCb(url, fileParentPath, downloadCallback);
        FwDownLoadTask downTask = new FwDownLoadTask(url, filePath, downCb, caFiles, this.upgradeFileManageProp);
        FwDownloadService.getExecutor().submit(downTask);
        return DownloadResponse.DOWNLOADING;
    }

    private DownloadCallback handleAttachedDownCb(final String url, final String fwFilePath, final DownloadCallback attachedDownCb) {
        return new DownloadCallback(){

            public void ready() {
                if (attachedDownCb != null) {
                    attachedDownCb.ready();
                } else {
                    log.warn("ready start to download file but callback object is null.");
                }
            }

            public void success(String md5, long fileSize, byte[] content) {
                log.info("Succeeded to download fw md5=({})'s firmware from{} .", (Object)md5, (Object)url);
                UpgradeFileInfoPO upgradeFileInfo = new UpgradeFileInfoPO(md5, md5, md5 + ".bin", fileSize, System.currentTimeMillis(), Boolean.valueOf(true));
                FwDownloadService.this.upgradeFileInfoRepository.save(upgradeFileInfo);
                FwDownloadService.this.localUpgradeFileCache.deleteFileByTotalSize(0L);
                if (attachedDownCb != null) {
                    attachedDownCb.success(md5, fileSize, content);
                } else {
                    log.warn("Succeeded to download fw md5=({})'s firmware but callback object is null.", (Object)md5);
                }
            }

            public void failed(String md5) {
                log.warn("Failed to download fw md5={} from {}.", (Object)md5, (Object)url);
                FwDownloadService.this.diskFileRepository.deleteFile(fwFilePath);
                FwDownloadService.this.upgradeFileInfoRepository.delete(md5);
                if (attachedDownCb != null) {
                    attachedDownCb.failed(md5);
                } else {
                    log.warn("Failed to download fw firmware and callback object is null.");
                }
            }

            public void progress(int percentage) {
                if (attachedDownCb != null) {
                    attachedDownCb.progress(percentage);
                }
            }
        };
    }

    private static ExecutorService getExecutor() {
        return LazyHolder.EXECUTOR;
    }

    public void setDiskFileRepository(DiskFileRepository diskFileRepository) {
        this.diskFileRepository = diskFileRepository;
    }

    public void setUpgradeFileManageProp(UpgradeFileManageProp upgradeFileManageProp) {
        this.upgradeFileManageProp = upgradeFileManageProp;
    }

    public void setUpgradeFileInfoRepository(UpgradeFileInfoRepository upgradeFileInfoRepository) {
        this.upgradeFileInfoRepository = upgradeFileInfoRepository;
    }

    public void setLocalUpgradeFileCache(LocalUpgradeFileCache localUpgradeFileCache) {
        this.localUpgradeFileCache = localUpgradeFileCache;
    }

    private static class LazyHolder {
        private static ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger integer = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "firmware-download-thread: " + this.integer.getAndIncrement());
            }
        };
        private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4), factory);

        private LazyHolder() {
        }
    }
}

