/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.download;

import com.tplink.smb.component.upgradefilecache.api.DownloadCallback;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.StringUtils;
import com.tplink.smb.component.upgradefilecache.common.util.CommonConst;
import com.tplink.smb.component.upgradefilecache.local.prop.UpgradeFileManageProp;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FwDownLoadTask
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(FwDownLoadTask.class);
    private static final int CONNECT_TIMEOUT = 35000;
    private static final int CONNECT_REQUEST_TIMEOUT = 40000;
    private static final int WAIT_TIMEOUT_FROM_LAST_READ = 15000;
    private static final String CDN_CERTIFICATE_ALIAS = "cdn-certificate";
    private String urlPath;
    private String filePath;
    private AtomicInteger downProgress;
    private long downSize;
    private DownloadCallback downCb;
    private MessageDigest md5;
    private long startTime;
    private int overallProgress;
    private long timeOut;
    private int retryTime;
    private boolean needHandleRes;
    private List<String> caCertifications;

    public FwDownLoadTask(String urlPath, String filePath, DownloadCallback downCb, UpgradeFileManageProp upgradeFileManageProp) {
        this.urlPath = urlPath;
        this.filePath = filePath;
        this.downProgress = new AtomicInteger(0);
        this.retryTime = 3;
        this.startTime = System.currentTimeMillis();
        this.needHandleRes = true;
        this.timeOut = TimeUnit.SECONDS.toMillis(upgradeFileManageProp.getDownloadTimeOut());
        this.downProgress.set(0);
        this.downCb = downCb == null ? new DownloadCallback(){

            public void ready() {
                log.info("failed: Default implementation in DownloadCallback ready without CA.");
            }

            public void success(String md5, long fileSize, byte[] content) {
                log.info("success: Default implementation in DownloadCallback success without CA.");
            }

            public void failed(String md5) {
                log.info("failed: Default implementation. in DownloadCallback failed without CA.");
            }

            public void progress(int percentage) {
                log.debug("without CA firmware download progress: {}%", (Object)percentage);
            }
        } : downCb;
    }

    public FwDownLoadTask(String urlPath, String filePath, DownloadCallback downCb, List<String> caCertifications, UpgradeFileManageProp upgradeFileManageProp) {
        this.urlPath = urlPath;
        this.filePath = filePath;
        this.downProgress = new AtomicInteger(0);
        this.retryTime = 3;
        this.startTime = System.currentTimeMillis();
        this.needHandleRes = true;
        this.timeOut = TimeUnit.SECONDS.toMillis(upgradeFileManageProp.getDownloadTimeOut());
        this.caCertifications = caCertifications;
        this.downProgress.set(0);
        this.downCb = downCb == null ? new DownloadCallback(){

            public void ready() {
                log.info("failed: Default implementation in DownloadCallback ready.");
            }

            public void success(String md5, long fileSize, byte[] content) {
                log.info("success: Default implementation in DownloadCallback success.");
            }

            public void failed(String md5) {
                log.info("failed: Default implementation. in DownloadCallback failed.");
            }

            public void progress(int percentage) {
                log.debug("firmware download progress: {}%", (Object)percentage);
            }
        } : downCb;
    }

    private RequestConfig generateConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(40000).setConnectTimeout(35000).setSocketTimeout(15000).build();
    }

    @Override
    public Boolean call() {
        this.downCb.ready();
        long fileLength = 0L;
        File file = new File(this.filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            fileLength = file.length();
        }
        return this.downloadProcess(file, fileLength);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadProcess(File file, long fileLength) {
        Throwable throwable;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("MessageDigest.getInstance(\"MD5\") failed");
        }
        if (file.exists()) {
            try {
                throwable = null;
                try (FileInputStream in = new FileInputStream(this.filePath);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer, 0, 1024)) != -1) {
                        this.md5.update(buffer, 0, len);
                    }
                    String existFileMd5 = StringUtils.bytesToHexString((byte[])this.md5.digest());
                    if (existFileMd5 != null && file.getName().contains(existFileMd5)) {
                        log.info("The file {} has already been downloaded", (Object)file.getName());
                        this.downCb.success(existFileMd5, file.length(), null);
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(file, true);){
                boolean bl = this.startHttpDownloadTask(file, out, fileLength);
                return bl;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
        catch (IOException e) {
            log.warn("FileOutputStream IOException when download file", (Throwable)e);
            return false;
        }
        catch (CertificateException e) {
            log.warn("load keystore exception when download file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn("Some exception when download file", (Throwable)e);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean startHttpDownloadTask(File file, FileOutputStream out, long fileLength) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SchemeIOSessionStrategy generateSSLStrategyConfig(SSLContext sslContext) {
        return new SSLIOSessionStrategy(sslContext, CommonConst.supportedProtocols, CommonConst.supportedCipherSuites, (hostname, session) -> true);
    }

    private void loadCaCertificate(List<String> caCertifications, SSLContextBuilder sslContextBuilder) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        ArrayList<? extends Certificate> certificates = new ArrayList<Certificate>();
        for (String keyStore : caCertifications) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(keyStore.getBytes());
            Collection<? extends Certificate> certificateCollection = CertificateFactory.getInstance("X509").generateCertificates(inputStream);
            certificates.addAll(new ArrayList<Certificate>(certificateCollection));
        }
        if (!CollectionUtils.isEmpty(certificates)) {
            X509Certificate[] x509Certificates = new X509Certificate[certificates.size()];
            x509Certificates = certificates.toArray(x509Certificates);
            trustStore.setCertificateEntry(CDN_CERTIFICATE_ALIAS, x509Certificates[0]);
            sslContextBuilder.loadTrustMaterial(trustStore, null);
        } else {
            log.warn("HttpDownloadTask loadCaCertificate caCertifications is empty");
            sslContextBuilder.loadTrustMaterial((chain, authType) -> true);
        }
    }

    private void handleFinal(Future future, File file, boolean deleteIfFail) {
        if (this.needHandleRes) {
            log.info("Thread of download firmware is ended.");
            if (future != null && !future.isDone()) {
                log.warn("cancel downloadFuture forcibly.");
                future.cancel(true);
            }
            this.dealWithTheDownloadRes(file, deleteIfFail);
        }
    }

    private void dealWithTheDownloadRes(File file, boolean deleteIfFail) {
        this.needHandleRes = false;
        String hexMd5 = StringUtils.bytesToHexString((byte[])this.md5.digest());
        if (this.downProgress.get() < 100 || !file.getName().contains(hexMd5) || deleteIfFail) {
            this.downCb.failed(file.getName().split("\\.")[0]);
        } else {
            log.info("Md5 in hex of download firmware is {}. surplus retryTimes {}", (Object)hexMd5, (Object)this.retryTime);
            file.renameTo(new File(file.getParentFile().getAbsolutePath() + File.separator + hexMd5 + ".bin"));
            File parentFile = file.getParentFile();
            String parentFilename = parentFile.getAbsolutePath();
            parentFile.renameTo(new File(parentFilename.substring(0, parentFilename.lastIndexOf(File.separator)) + File.separator + hexMd5));
            this.downCb.success(hexMd5, this.downSize, null);
        }
    }

    private static /* synthetic */ boolean lambda$startHttpDownloadTask$1(String hostname, SSLSession session) {
        return true;
    }

    private static /* synthetic */ boolean lambda$startHttpDownloadTask$0(X509Certificate[] chain, String authType) throws CertificateException {
        return true;
    }

    class DownloadResponseException
    extends HttpException {
        private static final long serialVersionUID = 8108501309853633171L;

        public DownloadResponseException() {
        }

        public DownloadResponseException(String message) {
            super(message);
        }

        public DownloadResponseException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }
    }

    class MyResponseConsumer
    extends AsyncByteConsumer<Boolean> {
        private long fileWriteLen;
        private long fileTotalLen;
        FileChannel writeChannel;

        MyResponseConsumer(FileOutputStream out, long fileWriteLen) {
            this.fileWriteLen = fileWriteLen;
            this.fileTotalLen = fileWriteLen;
            this.writeChannel = out.getChannel();
            try {
                this.writeChannel.position(fileWriteLen);
                log.info("writeChannel position is {}.", (Object)this.writeChannel.position());
            }
            catch (IOException e) {
                log.info("MyResponseConsumer:", (Throwable)e);
            }
        }

        protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
            long currentTime = System.currentTimeMillis();
            if (System.currentTimeMillis() - FwDownLoadTask.this.startTime > FwDownLoadTask.this.timeOut) {
                throw new IOException("time out when download from cloud, current time " + currentTime);
            }
            if (buf != null) {
                buf.mark();
                this.fileWriteLen += (long)buf.remaining();
                this.writeChannel.write(buf);
                int currentProgress = (int)(this.fileWriteLen * 100L / this.fileTotalLen);
                FwDownLoadTask.this.downProgress.set(currentProgress);
                if (currentProgress - FwDownLoadTask.this.overallProgress >= 1) {
                    log.debug("Download progress is: {}", (Object)currentProgress);
                    FwDownLoadTask.this.downCb.progress(currentProgress);
                    FwDownLoadTask.this.overallProgress = currentProgress;
                }
                buf.reset();
                FwDownLoadTask.this.md5.update(buf);
            }
        }

        protected void onResponseReceived(HttpResponse httpResponse) throws HttpException, IOException {
            log.debug("Response received");
            HttpEntity entity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 206) {
                throw new DownloadResponseException("Unexpected status code:" + statusCode);
            }
            if (entity != null && entity.getContentLength() > 0L) {
                this.fileTotalLen += entity.getContentLength();
                FwDownLoadTask.this.downSize = this.fileTotalLen;
                log.info("fileTotalLen is {}.", (Object)this.fileTotalLen);
            }
        }

        protected Boolean buildResult(HttpContext httpContext) {
            log.debug("buildResult received, fileWriteLen is {}, fileTotalLen is {}.", (Object)this.fileWriteLen, (Object)this.fileTotalLen);
            if (this.fileWriteLen == this.fileTotalLen && this.fileWriteLen > 0L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

