/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.cleaner;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.upgradefilecache.local.cleaner.LocalUpgradeFileCleanTask;
import com.tplink.smb.component.upgradefilecache.local.prop.UpgradeFileManageProp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;

public class LocalUpgradeFileCleanScheduleCenter {
    private ScheduleCenter scheduleCenter;
    private UpgradeFileManageProp upgradeFileManageProp;

    @PostConstruct
    public void init() {
        this.scheduleCenter.registerSimpleConcurrentHandler("manager_local_upgrade_file_clean_task", scheduledEvent -> {
            Map data = scheduledEvent.getTaskDataMap();
            LocalUpgradeFileCleanTask task = new LocalUpgradeFileCleanTask((Long)data.get("expireTime"));
            task.run();
        }, 1);
    }

    public void saveLocalUpgradeFileCleanTask(LocalUpgradeFileCleanTask controlTask) {
        String identity = "system.user.upgrade.file.clean";
        HashMap<String, Long> data = new HashMap<String, Long>(1);
        data.put("expireTime", controlTask.getExpireTime());
        ScheduleTask scheduleTask = ScheduleTask.builder().withIdentity("manager_local_upgrade_file_clean_task", identity).withFixedRateTrigger(Integer.valueOf((int)this.upgradeFileManageProp.getCleanScheduleTime())).withDataMap(data).build();
        this.scheduleCenter.saveTask(scheduleTask);
    }

    public void deleteLocalUpgradeFileCleanTask() {
        this.scheduleCenter.deleteTask(TaskKey.of((String)"manager_local_upgrade_file_clean_task", (String)"system.user.upgrade.file.clean"));
    }

    public void setScheduleCenter(ScheduleCenter scheduleCenter) {
        this.scheduleCenter = scheduleCenter;
    }

    public void setUpgradeFileManageProp(UpgradeFileManageProp upgradeFileManageProp) {
        this.upgradeFileManageProp = upgradeFileManageProp;
    }
}

