/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local.cache;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.StringUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeFileCache {
    private static final Logger log = LoggerFactory.getLogger(UpgradeFileCache.class);
    private CacheService cacheService;
    private static String fileCacheName = "manager.upgrade:upgrade.file";
    public static final String UPGRADE_FILE = "upgrade.file";
    private static final int EXPIRE_S = 300;

    public byte[] getFile(String key) {
        return (byte[])this.cacheService.get(fileCacheName, this.buildKey(UPGRADE_FILE, key), byte[].class);
    }

    public void addFile(String key, byte[] content) {
        this.cacheService.set(fileCacheName, this.buildKey(UPGRADE_FILE, key), (Object)content, 300L, TimeUnit.SECONDS);
    }

    public void expireFile(String key) {
        this.cacheService.expireKey(fileCacheName, this.buildKey(UPGRADE_FILE, key), 300L, TimeUnit.SECONDS);
    }

    private String buildKey(String ... fieldNameValuePairs) {
        StringBuilder sb = new StringBuilder();
        if (fieldNameValuePairs != null && fieldNameValuePairs.length > 0) {
            if (fieldNameValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("fieldName and fieldValue must be pair");
            }
            for (int i = 0; i < fieldNameValuePairs.length; ++i) {
                String str = fieldNameValuePairs[i];
                if (StringUtils.isNull((String)str)) {
                    throw new IllegalArgumentException("some fieldName or fieldValue is null");
                }
                sb.append(str);
                if (i >= fieldNameValuePairs.length - 1) continue;
                sb.append(":");
            }
        }
        return sb.toString();
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

