/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.upgradefilecache.local;

import com.tplink.smb.component.upgradefilecache.api.DownloadCallback;
import com.tplink.smb.component.upgradefilecache.api.DownloadResponse;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileCacheCommonService;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileCacheLocalExtendedService;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileInfo;
import com.tplink.smb.component.upgradefilecache.common.mongo.UpgradeFileInfoRepository;
import com.tplink.smb.component.upgradefilecache.common.mongo.po.UpgradeFileInfoPO;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.MD5Utils;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.StringUtils;
import com.tplink.smb.component.upgradefilecache.common.mongo.utils.UpgradeFileInfoMapper;
import com.tplink.smb.component.upgradefilecache.local.cache.FwDownloadUrlCache;
import com.tplink.smb.component.upgradefilecache.local.cleaner.LocalUpgradeFileCleanScheduleCenter;
import com.tplink.smb.component.upgradefilecache.local.cleaner.LocalUpgradeFileCleanTask;
import com.tplink.smb.component.upgradefilecache.local.download.FwDownloadService;
import com.tplink.smb.component.upgradefilecache.local.fileservice.DiskUpgradeFileRepository;
import com.tplink.smb.component.upgradefilecache.local.prop.UpgradeFileManageProp;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LocalUpgradeFileCache
implements UpgradeFileCacheCommonService,
UpgradeFileCacheLocalExtendedService {
    private static final Logger log = LoggerFactory.getLogger(LocalUpgradeFileCache.class);
    private UpgradeFileInfoRepository upgradeFileInfoRepository;
    private DiskUpgradeFileRepository diskUpgradeFileImpl;
    private FwDownloadService fwDownloadService;
    private LocalUpgradeFileCleanScheduleCenter scheduleCenter;
    private UpgradeFileManageProp upgradeFileManageProp;
    private FwDownloadUrlCache fwDownloadUrlCache;
    private final Object firmwareAddLock = new Object();

    public boolean checkUpgradeFileExisted(String fileKey) {
        UpgradeFileInfoPO res = this.upgradeFileInfoRepository.findAndUpdateLastUseTime(fileKey, System.currentTimeMillis());
        if (res != null) {
            if (!this.diskUpgradeFileImpl.checkFileExistInDisk(fileKey)) {
                log.warn("upgrade file {} is not existed or broken, need upload again", (Object)fileKey);
                this.deleteUpgradeFile(fileKey);
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<UpgradeFileInfo> getUpgradeFileInfo(String fileKey) {
        UpgradeFileInfoPO res = this.upgradeFileInfoRepository.findAndUpdateLastUseTime(fileKey, System.currentTimeMillis());
        if (res == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(UpgradeFileInfoMapper.fromPO((UpgradeFileInfoPO)res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveUpgradeFile(String fileKey, byte[] upgradeFile) {
        Object object = this.firmwareAddLock;
        synchronized (object) {
            if (!this.checkFileValid(upgradeFile)) {
                return false;
            }
            if (this.checkUpgradeFileExisted(MD5Utils.md5((byte[])upgradeFile))) {
                return true;
            }
            long fileSize = upgradeFile.length;
            this.deleteFileByTotalSize(fileSize);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(upgradeFile);){
                this.diskUpgradeFileImpl.saveUpgradeFile(fileKey, inputStream);
                UpgradeFileInfoPO upgradeFileInfo = new UpgradeFileInfoPO(fileKey, fileKey, fileKey + ".bin", fileSize, System.currentTimeMillis(), Boolean.valueOf(true));
                this.upgradeFileInfoRepository.save(upgradeFileInfo);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.warn("Exception occurs when saveUpgradeFile", (Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveUpgradeFile(String fileKey, InputStream upgradeFile, long fileSize) {
        Object object = this.firmwareAddLock;
        synchronized (object) {
            if (!this.checkFileValid(upgradeFile, fileSize)) {
                return false;
            }
            if (this.checkUpgradeFileExisted(fileKey)) {
                return true;
            }
            this.deleteFileByTotalSize(fileSize);
            this.diskUpgradeFileImpl.saveUpgradeFile(fileKey, upgradeFile);
            UpgradeFileInfoPO upgradeFileInfo = new UpgradeFileInfoPO(fileKey, fileKey, fileKey + ".bin", fileSize, System.currentTimeMillis(), Boolean.valueOf(true));
            this.upgradeFileInfoRepository.save(upgradeFileInfo);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveUpgradeFile(String fileKey, InputStream upgradeFile, long fileSize, Boolean autoDelete) {
        Object object = this.firmwareAddLock;
        synchronized (object) {
            if (!this.checkFileValid(upgradeFile, fileSize)) {
                return false;
            }
            if (this.checkUpgradeFileExisted(fileKey)) {
                return true;
            }
            this.deleteFileByTotalSize(fileSize);
            this.diskUpgradeFileImpl.saveUpgradeFile(fileKey, upgradeFile);
            UpgradeFileInfoPO upgradeFileInfo = new UpgradeFileInfoPO(fileKey, fileKey, fileKey + ".bin", fileSize, System.currentTimeMillis(), autoDelete);
            this.upgradeFileInfoRepository.save(upgradeFileInfo);
            return true;
        }
    }

    public void changeFileAutoDeleteProperty(String fileKey, boolean autoDelete) {
        this.upgradeFileInfoRepository.findByFileKey(fileKey).ifPresent(upgradeFileInfoPO -> {
            boolean current = Optional.ofNullable(upgradeFileInfoPO.getAutoDelete()).orElse(false);
            if (current == autoDelete) {
                return;
            }
            upgradeFileInfoPO.setAutoDelete(Boolean.valueOf(autoDelete));
            this.upgradeFileInfoRepository.save(upgradeFileInfoPO);
        });
    }

    public boolean deleteUpgradeFile(String fileKey) {
        this.upgradeFileInfoRepository.delete(fileKey);
        return this.diskUpgradeFileImpl.deleteFile(fileKey);
    }

    public String getDownloadLink(String fileKey, String urlPrefix) {
        if (!this.diskUpgradeFileImpl.checkFileExistInDisk(fileKey)) {
            log.warn("upgrade file {} getDownloadLink is not existed or broken, need upload again", (Object)fileKey);
            this.deleteUpgradeFile(fileKey);
            return null;
        }
        String downloadLink = urlPrefix + "/" + StringUtils.generateUUID() + "/" + fileKey;
        this.fwDownloadUrlCache.addDownloadUrl(downloadLink);
        return downloadLink;
    }

    public boolean deleteFileByExpireTime(long expireTime) {
        List upgradeFileInfoList = this.upgradeFileInfoRepository.deleteByLastUseTime(System.currentTimeMillis() - expireTime);
        for (UpgradeFileInfoPO upgradeFileInfoPO : upgradeFileInfoList) {
            if (Boolean.FALSE.equals(upgradeFileInfoPO.getAutoDelete())) continue;
            this.diskUpgradeFileImpl.deleteFile(upgradeFileInfoPO.getFileKey());
        }
        log.info("delete expired upgrade file, number = {}", (Object)upgradeFileInfoList.size());
        return true;
    }

    public void deleteNoRecordFile() {
        List<String> allFileNameList = this.diskUpgradeFileImpl.getAllUpgradeFileNames();
        if (allFileNameList == null || allFileNameList.size() < 1) {
            return;
        }
        for (String fileName : allFileNameList) {
            if (this.upgradeFileInfoRepository.findByFileKey(fileName).isPresent()) continue;
            this.deleteUpgradeFile(fileName);
        }
    }

    public void registerDailyUpgradeFileCleanTask() {
        LocalUpgradeFileCleanTask cleanTask = new LocalUpgradeFileCleanTask(this.upgradeFileManageProp.getFwExpireTime());
        this.scheduleCenter.saveLocalUpgradeFileCleanTask(cleanTask);
    }

    public void deleteDailyUpgradeFileCleanTask() {
        this.scheduleCenter.deleteLocalUpgradeFileCleanTask();
    }

    public byte[] getFile(String fileKey) {
        if (fileKey == null) {
            return null;
        }
        if (this.checkUpgradeFileExisted(fileKey)) {
            byte[] res = this.diskUpgradeFileImpl.getFileContent(fileKey);
            if (res == null || !fileKey.equals(MD5Utils.md5((byte[])res))) {
                log.warn("file {} has been deleted or modified, delete file", (Object)fileKey);
                this.deleteUpgradeFile(fileKey);
                return null;
            }
            return res;
        }
        return null;
    }

    public boolean responseDownloadReq(String url, String urlPrefix, String range, OutputStream outputStream) {
        return this.diskUpgradeFileImpl.getFileStreamToOutputStream(url, urlPrefix, range, null, outputStream);
    }

    public boolean responseDownloadReq(String url, String urlPrefix, String range, Long memoryLimit, OutputStream outputStream) {
        return this.diskUpgradeFileImpl.getFileStreamToOutputStream(url, urlPrefix, range, memoryLimit, outputStream);
    }

    public boolean responseDownloadReq(String url, String urlPrefix, OutputStream outputStream) {
        return this.diskUpgradeFileImpl.getFileStreamToOutputStream(url, urlPrefix, null, null, outputStream);
    }

    public DownloadResponse downloadFromUrl(String url, String fileName, DownloadCallback downloadCallback) {
        return this.downloadFromUrl(url, fileName, new ArrayList<String>(), downloadCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResponse downloadFromUrl(String url, String fileName, List<String> caCertificates, final DownloadCallback downloadCallback) {
        if (fileName == null || fileName.split("\\.").length < 1) {
            return null;
        }
        Object object = this.firmwareAddLock;
        synchronized (object) {
            DownloadCallback callback = new DownloadCallback(){

                public void ready() {
                    downloadCallback.ready();
                }

                public void success(String md5, long fileSize, byte[] content) {
                    downloadCallback.success(md5, fileSize, content);
                    LocalUpgradeFileCache.this.deleteFileByTotalSize(0L);
                }

                public void failed(String md5) {
                    downloadCallback.failed(md5);
                    LocalUpgradeFileCache.this.deleteFileByTotalSize(0L);
                }

                public void progress(int percentage) {
                    downloadCallback.progress(percentage);
                }
            };
            ArrayList<String> caFiles = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(caCertificates)) {
                caFiles.addAll(caCertificates);
            }
            return this.fwDownloadService.downloadFw(url, this.diskUpgradeFileImpl.getUpgradeFileDirPath() + File.separatorChar + fileName.split("\\.")[0], fileName + ".bin", caFiles, callback);
        }
    }

    public long getFileSize(String fileKey) {
        return this.upgradeFileInfoRepository.findByFileKey(fileKey).map(UpgradeFileInfoPO::getFileSize).orElse(0L);
    }

    public void deleteFileByTotalSize(long redundantSize) {
        long currentTotalSize = this.upgradeFileInfoRepository.getRecordFileTotalSize();
        if (currentTotalSize + redundantSize < this.upgradeFileManageProp.getTotalSizeLimit()) {
            return;
        }
        List upgradeFileInfoList = this.upgradeFileInfoRepository.findAllSortByLastUseTimeAsc();
        for (UpgradeFileInfoPO upgradeFileInfo : upgradeFileInfoList) {
            if (Boolean.FALSE.equals(upgradeFileInfo.getAutoDelete())) continue;
            this.deleteUpgradeFile(upgradeFileInfo.getFileKey());
            if ((currentTotalSize -= upgradeFileInfo.getFileSize()) + redundantSize >= this.upgradeFileManageProp.getTotalSizeLimit()) continue;
            break;
        }
    }

    private boolean checkFileValid(byte[] upgradeFile) {
        return upgradeFile != null && (long)upgradeFile.length < this.upgradeFileManageProp.getFwSizeLimit();
    }

    private boolean checkFileValid(InputStream in, long fileSize) {
        return in != null && fileSize < this.upgradeFileManageProp.getFwSizeLimit();
    }

    public void setUpgradeFileInfoRepository(UpgradeFileInfoRepository upgradeFileInfoRepository) {
        this.upgradeFileInfoRepository = upgradeFileInfoRepository;
    }

    public void setDiskUpgradeFileImpl(DiskUpgradeFileRepository diskUpgradeFileImpl) {
        this.diskUpgradeFileImpl = diskUpgradeFileImpl;
    }

    public void setFwDownloadService(FwDownloadService fwDownloadService) {
        this.fwDownloadService = fwDownloadService;
    }

    public void setScheduleCenter(LocalUpgradeFileCleanScheduleCenter scheduleCenter) {
        this.scheduleCenter = scheduleCenter;
    }

    public void setUpgradeFileManageProp(UpgradeFileManageProp upgradeFileManageProp) {
        this.upgradeFileManageProp = upgradeFileManageProp;
    }

    public void setFwDownloadUrlCache(FwDownloadUrlCache fwDownloadUrlCache) {
        this.fwDownloadUrlCache = fwDownloadUrlCache;
    }
}

