/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.core.util;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class ThreadFactoryBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThreadFactoryBuilder.class);
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String unused = ThreadFactoryBuilder.format(nameFormat, 0);
        log.trace("ThreadFactoryBuilder nameFormat example: {}", (Object)unused);
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        ThreadFactoryBuilder.checkArgument(priority >= 1, "Thread priority (%s) must be >= %s", priority, 1);
        ThreadFactoryBuilder.checkArgument(priority <= 10, "Thread priority (%s) must be <= %s", priority, 10);
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = ThreadFactoryBuilder.checkNotNull(uncaughtExceptionHandler);
        return this;
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = ThreadFactoryBuilder.checkNotNull(backingThreadFactory);
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    private static ThreadFactory doBuild(ThreadFactoryBuilder builder) {
        String nameFormat = builder.nameFormat;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        ThreadFactory backingThreadFactory = Objects.nonNull(builder.backingThreadFactory) ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong count = Objects.nonNull(nameFormat) ? new AtomicLong(0L) : null;
        return runnable -> {
            Thread thread = backingThreadFactory.newThread(runnable);
            if (Objects.nonNull(nameFormat)) {
                thread.setName(ThreadFactoryBuilder.format(nameFormat, count.getAndIncrement()));
            }
            if (Objects.nonNull(daemon)) {
                thread.setDaemon(daemon);
            }
            if (Objects.nonNull(priority)) {
                thread.setPriority(priority);
            }
            if (Objects.nonNull(uncaughtExceptionHandler)) {
                thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
            return thread;
        };
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static void checkArgument(boolean b, @Nullable String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(String.valueOf(errorMessageTemplate) + p1 + p2);
        }
    }

    private static <T> T checkNotNull(T reference) {
        if (Objects.isNull(reference)) {
            throw new NullPointerException();
        }
        return reference;
    }
}

