/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.eventcenter.core.util;

import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private final String consumerIdPrefix;

    public IdGenerator(String prefix, @Nullable String hostName) {
        this.consumerIdPrefix = Objects.isNull(hostName) ? prefix + "_UNKNOWN_HOSTNAME" : prefix + "_" + hostName;
    }

    public String createConsumerId() {
        return this.consumerIdPrefix + "_" + UUID.randomUUID().toString();
    }

    public String createGroupId(String topic) {
        return topic + "_" + UUID.randomUUID().toString();
    }
}

