/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.openapi.api.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

public class FileServerOpenApiVO {
    @Schema(name="protocol", description="File server protocol, protocol should be a value as follows: FTP: FTP protocal; SFTP: SFTP protocal; TFTP: TFTP protocal; SCP: SCP protocal.")
    @NotNull(message="Parameter [protocol] should not be null.")
    private @NotNull(message="Parameter [protocol] should not be null.") String protocol;
    @Schema(name="hostname", description="File server host name or IP. Parameter [filePath] should be 1 - 128 ASCII characters.")
    @NotNull(message="Parameter [hostname] should not be null.")
    private @NotNull(message="Parameter [hostname] should not be null.") String hostname;
    @Schema(name="port", description="File server port. The value must be between 1 and 65535.")
    @NotNull(message="Parameter [hostname] should not be null.")
    private @NotNull(message="Parameter [hostname] should not be null.") Integer port;
    @Schema(name="username", description="File server access username, if needed in FTP/SFTP/SCP protocol. Parameter [username] should be 1 - 128 ASCII characters.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String username;
    @Schema(name="password", description="File server access password, if needed in FTP/SFTP protocol. Parameter [password] should be 1 - 128 ASCII characters.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private String password;

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public FileServerOpenApiVO setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public FileServerOpenApiVO setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Generated
    public FileServerOpenApiVO setPort(Integer port) {
        this.port = port;
        return this;
    }

    @Generated
    public FileServerOpenApiVO setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public FileServerOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public String toString() {
        return "FileServerOpenApiVO(super=" + super.toString() + ", protocol=" + this.getProtocol() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public FileServerOpenApiVO() {
    }

    @Generated
    public FileServerOpenApiVO(String protocol, String hostname, Integer port, String username, String password) {
        this.protocol = protocol;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }
}

