/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.openapi.api.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.maintenance.openapi.api.vo.DeviceAccountSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.a.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="CreateSiteByTemplate")
public class CreateSiteByTemplateOpenApiVO {
    @Schema(name="siteTemplateId", description="Site template ID.")
    @NotNull(message="Parameter [siteTemplateId] should not be null")
    private @NotNull(message="Parameter [siteTemplateId] should not be null") String siteTemplateId;
    @Schema(name="name", description="Name of the site should contain 1 to 64 characters.")
    @NotNull(message="Parameter [name] should not be null")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters")
    private @NotNull(message="Parameter [name] should not be null") @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,62}[^ ]$", message="Parameter [name] should be 1 - 64 characters") String name;
    @Schema(name="region", description="Country/Region of the site; For the values of region, refer to the abbreviation of the ISO country code; For example, you need to input \"United States\" for the United States of America.")
    @NotNull(message="Parameter [region] should not be null")
    private @NotNull(message="Parameter [region] should not be null") String region;
    @Schema(name="scenario", description="For the values of the scenario of the site, refer to result of the interface for Get scenario list.")
    @NotNull(message="Parameter [scenario] should not be null")
    private @NotNull(message="Parameter [scenario] should not be null") String scenario;
    @Schema(name="tagIds", description="Site tag ID, Site tag ID can be created using \"Create new site tag\" interface, and site tag ID can be obtained from \"Get site tag list\" interface")
    private Set<String> tagIds;
    @Schema(name="longitude", description="Longitude of the site should be within the range of -180 - 180.")
    @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class})
    @Nullable
    @PII(strategy=PIIMaskStrategy.TRUNC_2)
    private @Range(min=-180L, max=180L, message="Longitude should between -180 and 180.", groups={a.a.class}) Double longitude;
    @Schema(name="latitude", description="Latitude of the site should be within the range of -90 - 90.")
    @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class})
    @Nullable
    @PII(strategy=PIIMaskStrategy.TRUNC_2)
    private @Range(min=-90L, max=90L, message="latitude should between -90 and 90.", groups={a.a.class}) Double latitude;
    @Schema(name="address", description="Address of the site")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String address;
    @Schema(name="deviceAccountSetting", description="Device Account settings")
    @NotNull(message="Parameter [deviceAccountSetting] should not be null")
    @Valid
    private @NotNull(message="Parameter [deviceAccountSetting] should not be null") @Valid DeviceAccountSettingOpenApiVO deviceAccountSetting;
    @Schema(name="supportES", description="Whether the site supports adopting Agile Series switches")
    private Boolean supportES;
    @Schema(name="supportL2", description="Whether the site supports adopting Non-Agile Series switches")
    private Boolean supportL2;

    @Generated
    public String getSiteTemplateId() {
        return this.siteTemplateId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getScenario() {
        return this.scenario;
    }

    @Generated
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    @Nullable
    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Nullable
    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public DeviceAccountSettingOpenApiVO getDeviceAccountSetting() {
        return this.deviceAccountSetting;
    }

    @Generated
    public Boolean getSupportES() {
        return this.supportES;
    }

    @Generated
    public Boolean getSupportL2() {
        return this.supportL2;
    }

    @Generated
    public void setSiteTemplateId(String siteTemplateId) {
        this.siteTemplateId = siteTemplateId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    @Generated
    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setLongitude(@Nullable Double longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setLatitude(@Nullable Double latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setDeviceAccountSetting(DeviceAccountSettingOpenApiVO deviceAccountSetting) {
        this.deviceAccountSetting = deviceAccountSetting;
    }

    @Generated
    public void setSupportES(Boolean supportES) {
        this.supportES = supportES;
    }

    @Generated
    public void setSupportL2(Boolean supportL2) {
        this.supportL2 = supportL2;
    }

    @Generated
    public String toString() {
        return "CreateSiteByTemplateOpenApiVO(siteTemplateId=" + this.getSiteTemplateId() + ", name=" + this.getName() + ", region=" + this.getRegion() + ", scenario=" + this.getScenario() + ", tagIds=" + this.getTagIds() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", address=" + this.getAddress() + ", deviceAccountSetting=" + this.getDeviceAccountSetting() + ", supportES=" + this.getSupportES() + ", supportL2=" + this.getSupportL2() + ")";
    }
}

