/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.proxy.config;

import com.tplink.smb.ecsp.common.ExecutorRejectedPolicy;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="ecsp.proxy")
public class EcspProxyProperties {
    public static final String PROXY_PREFIX = "ecsp.proxy";
    private boolean enableV1 = false;
    private boolean enableV2 = false;
    private boolean enableV3 = false;
    private String topicPrefix = "";
    private String topicGroupId = "";
    private long grpcTimeout = 0L;
    private boolean enableMonitor = true;
    private int ecspMessageCorePoolSize = Math.min(2 * Runtime.getRuntime().availableProcessors(), 32);
    private int ecspMessageMaxPoolSize = Math.max(2 * Runtime.getRuntime().availableProcessors(), 32);
    private int ecspMessageKeepAliveTime = 100;
    private int ecspMessageQueueSize = 2000;
    private ExecutorRejectedPolicy ecspMessageRejectedPolicy = ExecutorRejectedPolicy.DISCARD_OLDEST;

    public boolean isEnableV1() {
        return this.enableV1;
    }

    public boolean isEnableV2() {
        return this.enableV2;
    }

    public boolean isEnableV3() {
        return this.enableV3;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public String getTopicGroupId() {
        return this.topicGroupId;
    }

    public long getGrpcTimeout() {
        return this.grpcTimeout;
    }

    public boolean isEnableMonitor() {
        return this.enableMonitor;
    }

    public int getEcspMessageCorePoolSize() {
        return this.ecspMessageCorePoolSize;
    }

    public int getEcspMessageMaxPoolSize() {
        return this.ecspMessageMaxPoolSize;
    }

    public int getEcspMessageKeepAliveTime() {
        return this.ecspMessageKeepAliveTime;
    }

    public int getEcspMessageQueueSize() {
        return this.ecspMessageQueueSize;
    }

    public ExecutorRejectedPolicy getEcspMessageRejectedPolicy() {
        return this.ecspMessageRejectedPolicy;
    }

    public void setEnableV1(boolean enableV1) {
        this.enableV1 = enableV1;
    }

    public void setEnableV2(boolean enableV2) {
        this.enableV2 = enableV2;
    }

    public void setEnableV3(boolean enableV3) {
        this.enableV3 = enableV3;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public void setTopicGroupId(String topicGroupId) {
        this.topicGroupId = topicGroupId;
    }

    public void setGrpcTimeout(long grpcTimeout) {
        this.grpcTimeout = grpcTimeout;
    }

    public void setEnableMonitor(boolean enableMonitor) {
        this.enableMonitor = enableMonitor;
    }

    public void setEcspMessageCorePoolSize(int ecspMessageCorePoolSize) {
        this.ecspMessageCorePoolSize = ecspMessageCorePoolSize;
    }

    public void setEcspMessageMaxPoolSize(int ecspMessageMaxPoolSize) {
        this.ecspMessageMaxPoolSize = ecspMessageMaxPoolSize;
    }

    public void setEcspMessageKeepAliveTime(int ecspMessageKeepAliveTime) {
        this.ecspMessageKeepAliveTime = ecspMessageKeepAliveTime;
    }

    public void setEcspMessageQueueSize(int ecspMessageQueueSize) {
        this.ecspMessageQueueSize = ecspMessageQueueSize;
    }

    public void setEcspMessageRejectedPolicy(ExecutorRejectedPolicy ecspMessageRejectedPolicy) {
        this.ecspMessageRejectedPolicy = ecspMessageRejectedPolicy;
    }
}

