/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.central.identityaccess.subsystem.api.internal.centralportal.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.central.components.common.util.o;
import com.tplink.smb.omada.central.identityaccess.subsystem.api.internal.centralportal.dto.LicenseDetailDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ActivatedCodeEmailDTO {
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String locale;
    @PII(strategy=PIIMaskStrategy.MASK)
    private String activatedCode;
    private List<LicenseStatsDTO> licenseStats;

    public ActivatedCodeEmailDTO(String email, String locale, String activatedCode) {
        this.email = email;
        this.locale = locale;
        this.activatedCode = activatedCode;
        this.licenseStats = new ArrayList<LicenseStatsDTO>();
    }

    public static List<LicenseStatsDTO> getLicenseStats(List<LicenseDetailDTO> licenseDetailDTOS, Long operationTime) {
        HashMap<LicenseStatsDTO, Integer> licenseMap = new HashMap<LicenseStatsDTO, Integer>();
        for (LicenseDetailDTO recordDetailInfo : licenseDetailDTOS) {
            LicenseStatsDTO detail = LicenseStatsDTO.builder().category(recordDetailInfo.getCategory()).build();
            if (Boolean.TRUE.equals(recordDetailInfo.getActive())) {
                Long remainTime = ActivatedCodeEmailDTO.convertToRemainTime(recordDetailInfo.getExpirationTime(), operationTime);
                LicenseDurationInfo info = ActivatedCodeEmailDTO.convertToDurationInfoInYear(remainTime);
                detail.setYearNum(LicenseDurationInfo.convertToYear(info));
                detail.setActive("Unbound");
            } else {
                detail.setYearNum(LicenseDurationInfo.convertToYear(LicenseDurationInfo.builder().duration(recordDetailInfo.getDuration()).durationUnit(recordDetailInfo.getDurationUnit()).build()));
                detail.setActive("Unactivated");
            }
            licenseMap.put(detail, licenseMap.getOrDefault(detail, 0) + 1);
        }
        ArrayList<LicenseStatsDTO> emailLicenseDetails = new ArrayList<LicenseStatsDTO>();
        licenseMap.forEach((k, v) -> {
            k.setNumber((Integer)v);
            emailLicenseDetails.add((LicenseStatsDTO)k);
        });
        return emailLicenseDetails;
    }

    public static List<LicenseStatsDTO> getLicenseStats(String licenseDetailJsonStr, Long operationTime) {
        return ActivatedCodeEmailDTO.getLicenseStats(o.b((String)licenseDetailJsonStr, LicenseDetailDTO.class), operationTime);
    }

    public static Long convertToRemainTime(Long expirationTime, Long operationTime) {
        if (expirationTime != null && operationTime != null && expirationTime - operationTime > 0L) {
            return expirationTime - operationTime;
        }
        return 0L;
    }

    public static LicenseDurationInfo convertToDurationInfoInYear(Long time) {
        LicenseDurationInfo info = LicenseDurationInfo.builder().build();
        long seconds = time / 1000L;
        long days = (seconds + 86399L) / 86400L;
        long years = (days + 364L) / 365L;
        info.setDuration((int)years);
        info.setDurationUnit(3);
        return info;
    }

    public static Integer convertToYear(LicenseDurationInfo info) {
        Integer duration = info.getDuration();
        switch (info.getDurationUnit()) {
            case 3: {
                return duration;
            }
            case 1: {
                return (duration + 364) / 365;
            }
            case 0: {
                return (duration + 31535999) / 31536000;
            }
        }
        return null;
    }

    public static ActivatedCodeEmailDTOBuilder builder() {
        return new ActivatedCodeEmailDTOBuilder();
    }

    public String getEmail() {
        return this.email;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getActivatedCode() {
        return this.activatedCode;
    }

    public List<LicenseStatsDTO> getLicenseStats() {
        return this.licenseStats;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setActivatedCode(String activatedCode) {
        this.activatedCode = activatedCode;
    }

    public void setLicenseStats(List<LicenseStatsDTO> licenseStats) {
        this.licenseStats = licenseStats;
    }

    public String toString() {
        return "ActivatedCodeEmailDTO(email=" + this.getEmail() + ", locale=" + this.getLocale() + ", activatedCode=" + this.getActivatedCode() + ", licenseStats=" + this.getLicenseStats() + ")";
    }

    public ActivatedCodeEmailDTO() {
    }

    public ActivatedCodeEmailDTO(String email, String locale, String activatedCode, List<LicenseStatsDTO> licenseStats) {
        this.email = email;
        this.locale = locale;
        this.activatedCode = activatedCode;
        this.licenseStats = licenseStats;
    }

    public static class ActivatedCodeEmailDTOBuilder {
        private String email;
        private String locale;
        private String activatedCode;
        private List<LicenseStatsDTO> licenseStats;

        ActivatedCodeEmailDTOBuilder() {
        }

        public ActivatedCodeEmailDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        public ActivatedCodeEmailDTOBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public ActivatedCodeEmailDTOBuilder activatedCode(String activatedCode) {
            this.activatedCode = activatedCode;
            return this;
        }

        public ActivatedCodeEmailDTOBuilder licenseStats(List<LicenseStatsDTO> licenseStats) {
            this.licenseStats = licenseStats;
            return this;
        }

        public ActivatedCodeEmailDTO build() {
            return new ActivatedCodeEmailDTO(this.email, this.locale, this.activatedCode, this.licenseStats);
        }

        public String toString() {
            return "ActivatedCodeEmailDTO.ActivatedCodeEmailDTOBuilder(email=" + this.email + ", locale=" + this.locale + ", activatedCode=" + this.activatedCode + ", licenseStats=" + this.licenseStats + ")";
        }
    }

    public static class LicenseDurationInfo {
        private Integer duration;
        private Integer durationUnit;

        public static Long convertToLongTime(LicenseDurationInfo info) {
            Long duration = (long)info.getDuration();
            switch (info.getDurationUnit()) {
                case 3: {
                    return TimeUnit.DAYS.toMillis(duration * 365L);
                }
                case 1: {
                    return TimeUnit.DAYS.toMillis(duration);
                }
                case 0: {
                    return TimeUnit.SECONDS.toMillis(duration);
                }
            }
            return null;
        }

        public static Integer convertToYear(LicenseDurationInfo info) {
            Integer duration = info.getDuration();
            switch (info.getDurationUnit()) {
                case 3: {
                    return duration;
                }
                case 1: {
                    return (duration + 364) / 365;
                }
                case 0: {
                    return (duration + 31535999) / 31536000;
                }
            }
            return null;
        }

        public static LicenseDurationInfoBuilder builder() {
            return new LicenseDurationInfoBuilder();
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Integer getDurationUnit() {
            return this.durationUnit;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public void setDurationUnit(Integer durationUnit) {
            this.durationUnit = durationUnit;
        }

        public String toString() {
            return "ActivatedCodeEmailDTO.LicenseDurationInfo(duration=" + this.getDuration() + ", durationUnit=" + this.getDurationUnit() + ")";
        }

        public LicenseDurationInfo() {
        }

        public LicenseDurationInfo(Integer duration, Integer durationUnit) {
            this.duration = duration;
            this.durationUnit = durationUnit;
        }

        public static class LicenseDurationInfoBuilder {
            private Integer duration;
            private Integer durationUnit;

            LicenseDurationInfoBuilder() {
            }

            public LicenseDurationInfoBuilder duration(Integer duration) {
                this.duration = duration;
                return this;
            }

            public LicenseDurationInfoBuilder durationUnit(Integer durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            public LicenseDurationInfo build() {
                return new LicenseDurationInfo(this.duration, this.durationUnit);
            }

            public String toString() {
                return "ActivatedCodeEmailDTO.LicenseDurationInfo.LicenseDurationInfoBuilder(duration=" + this.duration + ", durationUnit=" + this.durationUnit + ")";
            }
        }
    }

    public static class LicenseStatsDTO {
        private String category;
        private String active;
        private Integer yearNum;
        private Integer number;

        public static LicenseStatsDTOBuilder builder() {
            return new LicenseStatsDTOBuilder();
        }

        public String getCategory() {
            return this.category;
        }

        public String getActive() {
            return this.active;
        }

        public Integer getYearNum() {
            return this.yearNum;
        }

        public Integer getNumber() {
            return this.number;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setActive(String active) {
            this.active = active;
        }

        public void setYearNum(Integer yearNum) {
            this.yearNum = yearNum;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }

        public String toString() {
            return "ActivatedCodeEmailDTO.LicenseStatsDTO(category=" + this.getCategory() + ", active=" + this.getActive() + ", yearNum=" + this.getYearNum() + ", number=" + this.getNumber() + ")";
        }

        public LicenseStatsDTO() {
        }

        public LicenseStatsDTO(String category, String active, Integer yearNum, Integer number) {
            this.category = category;
            this.active = active;
            this.yearNum = yearNum;
            this.number = number;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LicenseStatsDTO)) {
                return false;
            }
            LicenseStatsDTO other = (LicenseStatsDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$active = this.getActive();
            String other$active = other.getActive();
            if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
                return false;
            }
            Integer this$yearNum = this.getYearNum();
            Integer other$yearNum = other.getYearNum();
            if (this$yearNum == null ? other$yearNum != null : !((Object)this$yearNum).equals(other$yearNum)) {
                return false;
            }
            Integer this$number = this.getNumber();
            Integer other$number = other.getNumber();
            return !(this$number == null ? other$number != null : !((Object)this$number).equals(other$number));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LicenseStatsDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $active = this.getActive();
            result = result * 59 + ($active == null ? 43 : $active.hashCode());
            Integer $yearNum = this.getYearNum();
            result = result * 59 + ($yearNum == null ? 43 : ((Object)$yearNum).hashCode());
            Integer $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
            return result;
        }

        public static class LicenseStatsDTOBuilder {
            private String category;
            private String active;
            private Integer yearNum;
            private Integer number;

            LicenseStatsDTOBuilder() {
            }

            public LicenseStatsDTOBuilder category(String category) {
                this.category = category;
                return this;
            }

            public LicenseStatsDTOBuilder active(String active) {
                this.active = active;
                return this;
            }

            public LicenseStatsDTOBuilder yearNum(Integer yearNum) {
                this.yearNum = yearNum;
                return this;
            }

            public LicenseStatsDTOBuilder number(Integer number) {
                this.number = number;
                return this;
            }

            public LicenseStatsDTO build() {
                return new LicenseStatsDTO(this.category, this.active, this.yearNum, this.number);
            }

            public String toString() {
                return "ActivatedCodeEmailDTO.LicenseStatsDTO.LicenseStatsDTOBuilder(category=" + this.category + ", active=" + this.active + ", yearNum=" + this.yearNum + ", number=" + this.number + ")";
            }
        }
    }
}

