/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty.socket;

import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.tplink.smb.ecsp.transport.netty.socket.QWaveDll;
import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.SocketUtils;
import java.lang.reflect.Field;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcspNioServerSocketChannel
extends NioServerSocketChannel {
    private static final Logger log = LoggerFactory.getLogger(EcspNioServerSocketChannel.class);
    private final AtomicBoolean needIpTos = new AtomicBoolean(true);

    public int doReadMessages(List<Object> buf) throws Exception {
        SocketChannel ch = SocketUtils.accept((ServerSocketChannel)this.javaChannel());
        if (this.needIpTos.get()) {
            this.handleIpTos(ch);
        }
        try {
            if (ch != null) {
                buf.add(new NioSocketChannel((Channel)this, ch));
                return 1;
            }
        }
        catch (Throwable var6) {
            log.warn("Failed to create a new channel from an accepted socket.", var6);
            try {
                ch.close();
            }
            catch (Throwable var5) {
                log.warn("Failed to close a socket.", var5);
            }
        }
        return 0;
    }

    private void handleIpTos(SocketChannel ch) {
        try {
            if (this.isWindowsOS()) {
                if (Objects.isNull(ch)) {
                    log.trace("udp socket has no socket channel.");
                    return;
                }
                Field field = ch.getClass().getDeclaredField("fdVal");
                field.setAccessible(true);
                int fd = (Integer)field.get(ch);
                QWaveDll.QOS_VERSION.ByReference version = new QWaveDll.QOS_VERSION.ByReference();
                version.MajorVersion = new WinDef.USHORT(1L);
                version.MinorVersion = new WinDef.USHORT(0L);
                WinNT.HANDLEByReference handle = new WinNT.HANDLEByReference();
                QWaveDll.INSTANCE.QOSCreateHandle(version, handle);
                QWaveDll.INSTANCE.QOSAddSocketToFlow(handle.getValue(), fd, null, 2, 2, new IntByReference());
            } else {
                ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)160);
            }
        }
        catch (Throwable throwable) {
            this.needIpTos.set(false);
            log.info("The priority of IP_TOS header will use default.");
            log.debug("Use default IP_TOS header Reason:", throwable);
        }
    }

    private boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase(Locale.ROOT).contains("windows");
    }
}

