/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.netty;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.TransConstants;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.security.SslContexts;
import com.tplink.smb.ecsp.transport.api.transport.AbstractServer;
import com.tplink.smb.ecsp.transport.netty.NettyEventLoopFactory;
import com.tplink.smb.ecsp.transport.netty.NettyTcpServerHandler;
import com.tplink.smb.ecsp.transport.netty.RttyCodecAdapter;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.reactivex.Single;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttyNettyTcpServer
extends AbstractServer {
    private static final Logger log = LoggerFactory.getLogger(RttyNettyTcpServer.class);
    private Map<String, com.tplink.smb.ecsp.transport.api.Channel> channels;
    private ServerBootstrap rttysBootstrap;
    private Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventExecutorGroup executorGroup;
    private SSLContext serverSslContext;
    private ExecutorService kickExecutorService;

    protected RttyNettyTcpServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected void doOpen() {
        NettyTcpServerHandler nettyTcpServerHandler = new NettyTcpServerHandler(this.getUrl(), (ChannelHandler)this);
        this.channels = nettyTcpServerHandler.getChannels();
        ChannelFuture channelFuture = this.openServer(nettyTcpServerHandler);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    private ChannelFuture openServer(final NettyTcpServerHandler nettyTcpServerHandler) {
        this.rttysBootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "rtty-netty-tcp-server-boss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getParameter("io-threads", TransConstants.DEFAULT_IO_THREADS), "rtty-netty-server-worker");
        this.executorGroup = new DefaultEventExecutorGroup(this.getUrl().getParameter("executor-threads", TransConstants.DEFAULT_EXECUTOR_THREADS), (ThreadFactory)new DefaultThreadFactory("rtty-netty-message-executor"), this.getUrl().getParameter("executor-queue-size", 200000), RejectedExecutionHandlers.reject());
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.rttysBootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).option(ChannelOption.SO_BACKLOG, (Object)this.getUrl().getParameter("backlog", 1024))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.IP_TOS, (Object)160).childOption(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.rttysBootstrap.childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                RttyNettyTcpServer.this.addSslHandlerIfNeeded(ch);
                ChannelPipeline pipeline = ch.pipeline();
                RttyCodecAdapter rttyCodecAdapter = new RttyCodecAdapter(RttyNettyTcpServer.this.getUrl(), RttyNettyTcpServer.this.getChannelHandler());
                pipeline.addLast(new io.netty.channel.ChannelHandler[]{rttyCodecAdapter.getDefaultDecoder()});
                pipeline.addLast(new io.netty.channel.ChannelHandler[]{rttyCodecAdapter.getDefaultEncoder()});
                pipeline.addLast("logging", (io.netty.channel.ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
                pipeline.addLast(RttyNettyTcpServer.this.executorGroup, "handler", (io.netty.channel.ChannelHandler)nettyTcpServerHandler);
            }
        });
        return this.rttysBootstrap.bind((SocketAddress)this.getBindAddress());
    }

    private void addSslHandlerIfNeeded(SocketChannel ch) {
        if (this.getUrl().getParameter("ssl-enabled", false)) {
            if (this.serverSslContext == null) {
                this.serverSslContext = SslContexts.buildSslContext((String)this.getUrl().getParameter("ssl-cert"), (String)this.getUrl().getParameter("ssl-cert-pwd"), (String)this.getUrl().getParameter("ssl-keystore"), (String)this.getUrl().getParameter("ssl-keystore-pwd"), (String)this.getUrl().getParameter("ssl-protocol", "TLSv1.2"));
            }
            if (this.serverSslContext == null) {
                log.warn("create serverSSLContext error, protocol:{}, port: {}", (Object)this.getUrl().getProtocol(), (Object)this.getUrl().getPort());
                return;
            }
            SSLEngine sslEngine = this.serverSslContext.createSSLEngine();
            if (this.getUrl().getParameter("tls-1.3-enable", false)) {
                sslEngine.setEnabledProtocols(new String[]{"TLSv1.2", "TLSv1.3"});
            } else {
                sslEngine.setEnabledProtocols(new String[]{"TLSv1.2"});
            }
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.getUrl().getParameter("ssl-client-auth", false));
            SslHandler sslHandler = new SslHandler(sslEngine);
            log.debug("ssl enabled Protocols: {}", (Object)Arrays.toString(sslEngine.getEnabledProtocols()));
            ch.pipeline().addFirst("negotiation", (io.netty.channel.ChannelHandler)sslHandler);
        }
    }

    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.getChannels().forEach(ch -> {
                try {
                    ch.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.rttysBootstrap != null) {
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
                this.executorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.channels != null) {
                this.channels.clear();
            }
            if (this.kickExecutorService != null) {
                this.kickExecutorService.shutdown();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public ChannelHandler getChannelHandler() {
        return this.getHandler();
    }

    public Single<Boolean> send(Object message, boolean sent) {
        log.warn("tcp server do not support send message without channel. local address = {}", (Object)this.getLocalAddress());
        return Single.error((Throwable)new RemotingException(this.getLocalAddress(), null, "tcp server do not support send message without channel."));
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    @NonNull
    public Collection<com.tplink.smb.ecsp.transport.api.Channel> getChannels() {
        HashSet<com.tplink.smb.ecsp.transport.api.Channel> chs = new HashSet<com.tplink.smb.ecsp.transport.api.Channel>();
        this.channels.values().forEach(ch -> {
            if (ch.isConnected()) {
                chs.add((com.tplink.smb.ecsp.transport.api.Channel)ch);
            } else {
                this.channels.remove(NetUtils.toAddressString((InetSocketAddress)ch.getRemoteAddress()));
            }
        });
        return chs;
    }

    public com.tplink.smb.ecsp.transport.api.Channel getChannel(InetSocketAddress remoteAddress) {
        return this.channels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public int getConnections() {
        return this.channels != null ? this.channels.size() : 0;
    }

    public void kickChannels(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        this.startClose();
        if (this.kickExecutorService == null) {
            this.kickExecutorService = Executors.newSingleThreadExecutor();
        }
        this.kickExecutorService.execute(() -> this.doBatchKickChannels(kickBatchNum, kickIntervalMs, restTimeMs));
    }

    private void doBatchKickChannels(int kickBatchNum, int kickIntervalMs, int restTimeMs) {
        int kickNum = 0;
        Iterator<Map.Entry<String, com.tplink.smb.ecsp.transport.api.Channel>> it = this.channels.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry<String, com.tplink.smb.ecsp.transport.api.Channel> channelEntry = it.next();
                if (channelEntry.getValue().isConnected()) {
                    channelEntry.getValue().close();
                    ++kickNum;
                }
                it.remove();
                if (kickNum >= kickBatchNum) {
                    log.debug("batch kick {} devices done, remain = {}, rest {}ms", new Object[]{kickNum, this.channels.size(), restTimeMs});
                    Thread.sleep(restTimeMs);
                    kickNum = 0;
                } else {
                    Thread.sleep(kickIntervalMs);
                }
                if (!this.channels.isEmpty()) continue;
                log.info("kick all channels done, wait graceful shutdown this server...");
                this.kickExecutorService.shutdownNow();
                this.kickExecutorService = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean canHandleIdle() {
        return false;
    }
}

